/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.client.selector;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.Date;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.dataset.impl.DataColumnImpl;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.displayer.client.AbstractGwtDisplayer;
import org.dashbuilder.displayer.client.widgets.filter.DateParameterEditor;
import org.dashbuilder.displayer.client.widgets.filter.NumberParameterEditor;

@Dependent
public class SelectorSliderDisplayer
extends AbstractGwtDisplayer<View> {
    protected View view;
    protected DataColumn dataColumnMin;
    protected DataColumn dataColumnMax;
    protected double rangeMin = -1.0;
    protected double rangeMax = -1.0;
    protected double selectedMin = -1.0;
    protected double selectedMax = -1.0;
    protected DateParameterEditor minDateEditor;
    protected DateParameterEditor maxDateEditor;
    protected NumberParameterEditor minNumberEditor;
    protected NumberParameterEditor maxNumberEditor;

    @Inject
    public SelectorSliderDisplayer(View view, DateParameterEditor minDateEditor, DateParameterEditor maxDateEditor, NumberParameterEditor minNumberEditor, NumberParameterEditor maxNumberEditor) {
        this.view = view;
        this.view.init((Object)this);
        this.minDateEditor = minDateEditor;
        this.maxDateEditor = maxDateEditor;
        this.minNumberEditor = minNumberEditor;
        this.maxNumberEditor = maxNumberEditor;
        this.minDateEditor.setOnChangeCommand(this::onMinDateInputChange);
        this.minDateEditor.setOnFocusCommand(this::onMinDateInputFocus);
        this.minDateEditor.setOnBlurCommand(this::onMinDateInputBlur);
        this.maxDateEditor.setOnChangeCommand(this::onMaxDateInputChange);
        this.maxDateEditor.setOnFocusCommand(this::onMaxDateInputFocus);
        this.maxDateEditor.setOnBlurCommand(this::onMaxDateInputBlur);
        this.minNumberEditor.setOnChangeCommand(this::onMinNumberInputChange);
        this.maxNumberEditor.setOnChangeCommand(this::onMaxNumberInputChange);
    }

    public View getView() {
        return this.view;
    }

    public DisplayerConstraints createDisplayerConstraints() {
        DataSetLookupConstraints lookupConstraints = ((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupAllowed(false).setMaxColumns(2)).setMinColumns(1)).setFunctionRequired(false).setExtraColumnsAllowed(false)).setColumnsTitle(this.view.getColumnsTitle());
        return new DisplayerConstraints(lookupConstraints).supportsAttribute(DisplayerAttributeDef.TYPE).supportsAttribute(DisplayerAttributeDef.SUBTYPE).supportsAttribute(DisplayerAttributeDef.RENDERER).supportsAttribute(DisplayerAttributeDef.TITLE).supportsAttribute(DisplayerAttributeDef.TITLE_VISIBLE).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.SELECTOR_GROUP).excludeAttribute(DisplayerAttributeGroupDef.SELECTOR_MULTIPLE).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_MARGIN_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.COLUMNS_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.FILTER_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.REFRESH_GROUP);
    }

    protected void beforeDataSetLookup() {
        DataSetGroup group = this.dataSetHandler.getCurrentDataSetLookup().getLastGroupOp();
        if (group != null && (group.getAggregationFunctions().isEmpty() || group.getColumnGroup() != null || group.getGroupFunctions().size() < 2)) {
            group.setColumnGroup(null);
            GroupFunction minFunction = (GroupFunction)group.getGroupFunctions().get(0);
            minFunction.setFunction(AggregateFunctionType.MIN);
            GroupFunction maxFunction = minFunction.cloneInstance();
            maxFunction.setFunction(AggregateFunctionType.MAX);
            group.addGroupFunction(new GroupFunction[]{maxFunction});
        }
    }

    protected void createVisualization() {
        if (this.displayerSettings.isTitleVisible()) {
            this.view.showTitle(this.displayerSettings.getTitle());
        }
        if (this.displayerSettings.getSelectorWidth() > 0) {
            this.view.setWidth(this.displayerSettings.getSelectorWidth());
        }
        this.view.margins(this.displayerSettings.getChartMarginTop(), this.displayerSettings.getChartMarginBottom(), this.displayerSettings.getChartMarginLeft(), this.displayerSettings.getChartMarginRight());
        this.updateVisualization();
    }

    protected void updateVisualization() {
        DataColumn minColumn = this.dataSet.getColumnByIndex(0);
        DataColumn maxColumn = this.dataSet.getColumnByIndex(1);
        Object minValue = minColumn.getValues().isEmpty() ? null : minColumn.getValues().get(0);
        Object maxValue = maxColumn.getValues().isEmpty() ? null : maxColumn.getValues().get(0);
        String minColumnId = minColumn.getId();
        String maxColumnId = maxColumn.getId();
        ColumnType columnType = minColumn.getColumnType();
        this.dataColumnMin = new DataColumnImpl(minColumnId, columnType);
        this.dataColumnMax = new DataColumnImpl(maxColumnId, columnType);
        int inputsWidth = this.displayerSettings.getSelectorWidth();
        inputsWidth = inputsWidth > 0 ? inputsWidth / 2 - 10 : -1;
        int n = inputsWidth = inputsWidth > 100 ? 100 : inputsWidth;
        if (minValue == null || maxValue == null) {
            this.view.noData();
        } else if (ColumnType.DATE.equals((Object)columnType)) {
            this.rangeMin = ((Date)minValue).getTime();
            this.rangeMax = ((Date)maxValue).getTime() + 1L;
            this.selectedMin = this.selectedMin == -1.0 ? this.rangeMin : this.selectedMin;
            this.selectedMax = this.selectedMax == -1.0 ? this.rangeMax : this.selectedMax;
            this.view.showSlider(this.rangeMin, this.rangeMax, 1.0, this.selectedMin, this.selectedMax);
            if (this.displayerSettings.isSelectorInputsEnabled()) {
                this.minDateEditor.setValue((Date)minValue);
                this.maxDateEditor.setValue((Date)maxValue);
                this.minDateEditor.setWidth(inputsWidth);
                this.maxDateEditor.setWidth(inputsWidth);
                this.view.showInputs((IsWidget)this.minDateEditor, (IsWidget)this.maxDateEditor);
            }
        } else if (ColumnType.NUMBER.equals((Object)columnType)) {
            this.rangeMin = ((Number)minValue).intValue();
            this.rangeMax = ((Number)maxValue).intValue() + 1;
            this.selectedMin = this.selectedMin == -1.0 ? this.rangeMin : this.selectedMin;
            this.selectedMax = this.selectedMax == -1.0 ? this.rangeMax : this.selectedMax;
            this.view.showSlider(this.rangeMin, this.rangeMax, 1.0, this.selectedMin, this.selectedMax);
            if (this.displayerSettings.isSelectorInputsEnabled()) {
                this.minNumberEditor.setValue((Number)minValue);
                this.maxNumberEditor.setValue((Number)maxValue);
                this.minNumberEditor.setWidth(inputsWidth);
                this.maxNumberEditor.setWidth(inputsWidth);
                this.view.showInputs((IsWidget)this.minNumberEditor, (IsWidget)this.maxNumberEditor);
            }
        } else {
            this.view.textColumnsNotSupported();
        }
    }

    public Object getSelectedMin() {
        if (this.selectedMin == -1.0) {
            return new Date((long)this.rangeMin);
        }
        if (ColumnType.DATE.equals((Object)this.dataColumnMin.getColumnType())) {
            return new Date((long)this.selectedMin);
        }
        if (ColumnType.NUMBER.equals((Object)this.dataColumnMin.getColumnType())) {
            return (long)this.selectedMin;
        }
        return null;
    }

    public Object getSelectedMax() {
        if (this.selectedMax == -1.0) {
            return new Date((long)this.rangeMax);
        }
        if (ColumnType.DATE.equals((Object)this.dataColumnMax.getColumnType())) {
            return new Date((long)this.selectedMax);
        }
        if (ColumnType.NUMBER.equals((Object)this.dataColumnMax.getColumnType())) {
            return (long)this.selectedMax;
        }
        return null;
    }

    void onSliderChange(double min, double max) {
        if (this.selectedMin != min || this.selectedMax != max) {
            this.selectedMin = min;
            this.selectedMax = max;
            DataSetFilter filter = new DataSetFilter();
            CoreFunctionFilter columnFilter = new CoreFunctionFilter();
            columnFilter.setColumnId(this.dataColumnMin.getId());
            columnFilter.setType(CoreFunctionType.BETWEEN);
            filter.addFilterColumn(new ColumnFilter[]{columnFilter});
            if (ColumnType.DATE.equals((Object)this.dataColumnMin.getColumnType())) {
                Date dateFrom = new Date((long)min);
                Date dateTo = new Date((long)max);
                columnFilter.setParameters(new Comparable[]{dateFrom, dateTo});
                this.minDateEditor.setValue(dateFrom);
                this.maxDateEditor.setValue(dateTo);
                super.filterUpdate(filter);
            } else if (ColumnType.NUMBER.equals((Object)this.dataColumnMin.getColumnType())) {
                columnFilter.setParameters(new Comparable[]{Double.valueOf(min), Double.valueOf(max)});
                this.minNumberEditor.setValue((Number)min);
                this.maxNumberEditor.setValue((Number)max);
                super.filterUpdate(filter);
            }
        }
    }

    void onMinDateInputChange() {
        long min = this.minDateEditor.getValue().getTime();
        double max = this.selectedMax != -1.0 ? this.selectedMax : this.rangeMax;
        this.onSliderChange(min, max);
        this.view.showSlider(this.rangeMin, this.rangeMax, 1.0, min, max);
        this.view.setSliderEnabled(true);
    }

    void onMinDateInputFocus() {
        this.view.setSliderEnabled(false);
    }

    void onMinDateInputBlur() {
        this.view.setSliderEnabled(true);
    }

    void onMaxDateInputChange() {
        double min = this.selectedMin != -1.0 ? this.selectedMin : this.rangeMin;
        long max = this.maxDateEditor.getValue().getTime();
        this.onSliderChange(min, max);
        this.view.showSlider(this.rangeMin, this.rangeMax, 1.0, min, max);
        this.view.setSliderEnabled(true);
    }

    void onMaxDateInputFocus() {
        this.view.setSliderEnabled(false);
    }

    void onMaxDateInputBlur() {
        this.view.setSliderEnabled(true);
    }

    void onMinNumberInputChange() {
        double min = this.minNumberEditor.getValue().doubleValue();
        double max = this.selectedMax != -1.0 ? this.selectedMax : this.rangeMax;
        this.onSliderChange(min, max);
        this.view.showSlider(this.rangeMin, this.rangeMax, 1.0, min, max);
    }

    void onMaxNumberInputChange() {
        double min = this.selectedMin != -1.0 ? this.selectedMin : this.rangeMin;
        double max = this.maxNumberEditor.getValue().doubleValue();
        this.onSliderChange(min, max);
        this.view.showSlider(this.rangeMin, this.rangeMax, 1.0, min, max);
    }

    String formatRange(double min, double max) {
        String fromStr = this.formatValue(min, this.dataColumnMin);
        String toStr = this.formatValue(max, this.dataColumnMax);
        return this.view.formatRange(fromStr, toStr);
    }

    String formatValue(double val, DataColumn dataColumn) {
        if (ColumnType.DATE.equals((Object)dataColumn.getColumnType())) {
            Date date = new Date((long)val);
            return super.formatValue((Object)date, dataColumn);
        }
        if (ColumnType.NUMBER.equals((Object)dataColumn.getColumnType())) {
            return super.formatValue((Object)val, dataColumn);
        }
        return Double.toString(val);
    }

    public static interface View
    extends AbstractGwtDisplayer.View<SelectorSliderDisplayer> {
        public void showTitle(String var1);

        public void setWidth(int var1);

        public String getColumnsTitle();

        public void setSliderEnabled(boolean var1);

        public void showSlider(double var1, double var3, double var5, double var7, double var9);

        public void showInputs(IsWidget var1, IsWidget var2);

        public void margins(int var1, int var2, int var3, int var4);

        public String formatRange(String var1, String var2);

        public void textColumnsNotSupported();

        public void noData();
    }
}

