/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.client.selector;

import com.google.gwt.dom.client.Element;
import javax.inject.Inject;
import org.dashbuilder.displayer.client.AbstractErraiDisplayer;
import org.dashbuilder.displayer.client.AbstractErraiDisplayerView;
import org.dashbuilder.renderer.client.resources.i18n.SelectorConstants;
import org.dashbuilder.renderer.client.selector.SelectorLabelItem;
import org.dashbuilder.renderer.client.selector.SelectorLabelSetDisplayer;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Templated
public class SelectorLabelSetDisplayerView
extends AbstractErraiDisplayerView<SelectorLabelSetDisplayer>
implements SelectorLabelSetDisplayer.View {
    @Inject
    @DataField
    Div containerDiv;
    @Inject
    @DataField
    Span titleSpan;
    @Inject
    @DataField
    Span noDataSpan;
    @Inject
    @DataField
    Div labelSetDiv;

    public void init(SelectorLabelSetDisplayer presenter) {
        super.setPresenter((AbstractErraiDisplayer)presenter);
        super.setVisualization((Element)this.containerDiv);
    }

    @Override
    public void showTitle(String title) {
        this.titleSpan.setTextContent(title);
    }

    @Override
    public void setWidth(int width) {
        this.containerDiv.getStyle().setProperty("width", width + "px");
    }

    @Override
    public void margins(int top, int bottom, int left, int right) {
        this.containerDiv.getStyle().setProperty("margin-top", top + "px");
        this.containerDiv.getStyle().setProperty("margin-bottom", bottom + "px");
        this.containerDiv.getStyle().setProperty("margin-left", left + "px");
        this.containerDiv.getStyle().setProperty("margin-right", right + "px");
    }

    @Override
    public void clearItems() {
        DOMUtil.removeAllChildren((Node)this.labelSetDiv);
        this.noDataSpan.setTextContent("");
    }

    @Override
    public void addItem(SelectorLabelItem item) {
        HTMLElement element = item.getView().getElement();
        element.getStyle().setProperty("margin", "3px");
        this.labelSetDiv.appendChild((Node)element);
    }

    @Override
    public void noData() {
        this.noDataSpan.setTextContent(SelectorConstants.INSTANCE.selectorDisplayer_noDataAvailable());
    }

    @Override
    public String getGroupsTitle() {
        return SelectorConstants.INSTANCE.selectorDisplayer_groupsTitle();
    }

    @Override
    public String getColumnsTitle() {
        return SelectorConstants.INSTANCE.selectorDisplayer_columnsTitle();
    }
}

