/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.client.selector;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.GroupStrategy;
import org.dashbuilder.dataset.sort.DataSetSort;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.displayer.ColumnSettings;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.displayer.client.AbstractErraiDisplayer;
import org.dashbuilder.renderer.client.selector.SelectorDropDownItem;
import org.jboss.errai.ioc.client.container.SyncBeanManager;

@Dependent
public class SelectorDropDownDisplayer
extends AbstractErraiDisplayer<View> {
    protected View view;
    protected boolean filterOn = false;
    protected boolean multipleSelections = false;
    protected SyncBeanManager beanManager;
    protected Set<SelectorDropDownItem> itemCollection = new HashSet<SelectorDropDownItem>();

    @Inject
    public SelectorDropDownDisplayer(View view, SyncBeanManager beanManager) {
        this.beanManager = beanManager;
        this.view = view;
        this.view.init((Object)this);
    }

    public View getView() {
        return this.view;
    }

    public void close() {
        super.close();
        this.clearItems();
    }

    protected void clearItems() {
        this.view.clearItems();
        for (SelectorDropDownItem item : this.itemCollection) {
            this.beanManager.destroyBean((Object)item);
        }
        this.itemCollection.clear();
    }

    protected void resetItems() {
        for (SelectorDropDownItem item : this.itemCollection) {
            item.reset();
        }
    }

    public DisplayerConstraints createDisplayerConstraints() {
        DataSetLookupConstraints lookupConstraints = ((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupRequired(true).setGroupColumn(true).setMaxColumns(-1)).setMinColumns(1)).setExtraColumnsAllowed(true)).setGroupsTitle(this.view.getGroupsTitle()).setColumnsTitle(this.view.getColumnsTitle());
        return new DisplayerConstraints(lookupConstraints).supportsAttribute(DisplayerAttributeDef.TYPE).supportsAttribute(DisplayerAttributeDef.SUBTYPE).supportsAttribute(DisplayerAttributeDef.RENDERER).supportsAttribute(DisplayerAttributeDef.TITLE).supportsAttribute(DisplayerAttributeDef.TITLE_VISIBLE).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.SELECTOR_GROUP).excludeAttribute(DisplayerAttributeGroupDef.SELECTOR_SHOW_INPUTS).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_MARGIN_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.COLUMNS_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.FILTER_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.REFRESH_GROUP);
    }

    protected void beforeDataSetLookup() {
        ColumnGroup column;
        DataSetGroup group = this.dataSetHandler.getCurrentDataSetLookup().getLastGroupOp();
        if (this.dataSetHandler.getCurrentDataSetLookup().getOperationList(DataSetSort.class).isEmpty() && group != null && !GroupStrategy.FIXED.equals((Object)(column = group.getColumnGroup()).getStrategy())) {
            this.dataSetHandler.sort(column.getSourceId(), SortOrder.ASCENDING);
        }
    }

    protected void createVisualization() {
        if (this.displayerSettings.isTitleVisible()) {
            this.view.showTitle(this.displayerSettings.getTitle());
        }
        if (this.displayerSettings.getSelectorWidth() > 0) {
            this.view.setWidth(this.displayerSettings.getSelectorWidth());
        }
        this.view.margins(this.displayerSettings.getChartMarginTop(), this.displayerSettings.getChartMarginBottom(), this.displayerSettings.getChartMarginLeft(), this.displayerSettings.getChartMarginRight());
        this.multipleSelections = this.displayerSettings.isSelectorMultiple();
        this.updateVisualization();
    }

    protected void updateVisualization() {
        DataColumn firstColumn = this.dataSet.getColumnByIndex(0);
        ColumnSettings columnSettings = this.displayerSettings.getColumnSettings(firstColumn);
        String firstColumnName = columnSettings.getColumnName();
        List currentFilter = super.filterIndexes(firstColumn.getId());
        this.clearItems();
        for (int i = 0; i < this.dataSet.getRowCount(); ++i) {
            Object obj = this.dataSet.getValueAt(i, 0);
            if (obj == null) continue;
            String value = super.formatValue(i, 0);
            StringBuilder title = new StringBuilder();
            int ncolumns = this.dataSet.getColumns().size();
            if (ncolumns > 1) {
                for (int j = 1; j < ncolumns; ++j) {
                    DataColumn extraColumn = this.dataSet.getColumnByIndex(j);
                    columnSettings = this.displayerSettings.getColumnSettings(extraColumn);
                    String extraColumnName = columnSettings.getColumnName();
                    Object extraValue = this.dataSet.getValueAt(i, j);
                    if (extraValue == null) continue;
                    title.append(j > 1 ? " " : "");
                    String formattedValue = super.formatValue(i, j);
                    title.append(extraColumnName).append("=").append(formattedValue);
                }
            }
            SelectorDropDownItem item = (SelectorDropDownItem)this.beanManager.lookupBean(SelectorDropDownItem.class, new Annotation[0]).newInstance();
            item.init(i, value, title.toString());
            item.setSelectionIconVisible(this.multipleSelections);
            item.setOnSelectCommand(() -> this.onItemSelected(item));
            item.setOnResetCommand(() -> this.onItemReset(item));
            if (currentFilter.contains(i)) {
                item.select();
            } else {
                item.reset();
            }
            this.view.addItem(item);
            this.itemCollection.add(item);
        }
        if (currentFilter.isEmpty()) {
            this.view.showSelectHint(firstColumnName, this.multipleSelections);
        } else {
            this.view.showResetHint(firstColumnName, this.multipleSelections);
        }
    }

    public String getFirstColumnId() {
        DataColumn firstColumn = this.dataSet.getColumnByIndex(0);
        return firstColumn.getId();
    }

    public String getFirstColumnName() {
        DataColumn firstColumn = this.dataSet.getColumnByIndex(0);
        ColumnSettings columnSettings = this.displayerSettings.getColumnSettings(firstColumn);
        return columnSettings.getColumnName();
    }

    protected void onItemSelected(SelectorDropDownItem item) {
        if (this.displayerSettings.isFilterEnabled()) {
            List currentFilter;
            String firstColumnId = this.getFirstColumnId();
            String firstColumnName = this.getFirstColumnName();
            if (!this.multipleSelections && (currentFilter = this.filterIndexes(firstColumnId)) != null && !currentFilter.isEmpty()) {
                this.resetItems();
                super.filterReset();
                item.select();
            }
            this.filterUpdate(firstColumnId, item.getId());
            currentFilter = super.filterIndexes(firstColumnId);
            this.showSelectedItems(currentFilter);
            this.view.showResetHint(firstColumnName, this.multipleSelections);
        }
    }

    protected void onItemReset(SelectorDropDownItem item) {
        if (this.displayerSettings.isFilterEnabled()) {
            String firstColumnId = this.getFirstColumnId();
            String firstColumnName = this.getFirstColumnName();
            this.filterUpdate(firstColumnId, item.getId());
            List currentFilter = super.filterIndexes(firstColumnId);
            if (currentFilter.isEmpty()) {
                this.view.showSelectHint(firstColumnName, this.multipleSelections);
            } else {
                this.showSelectedItems(currentFilter);
            }
        }
    }

    protected void showSelectedItems(List<Integer> currentFilter) {
        ArrayList<String> itemList = new ArrayList<String>();
        for (Integer idx : currentFilter) {
            String value = super.formatValue(idx.intValue(), 0);
            itemList.add(value);
        }
        int width = this.displayerSettings.getSelectorWidth();
        String hint = this.formatItemList(itemList);
        String text = width > 0 ? this.formatItemList(itemList, width) : hint;
        this.view.showCurrentSelection(text, hint);
    }

    public String formatItemList(List<String> itemList) {
        StringBuffer out = new StringBuffer();
        for (String item : itemList) {
            if (out.length() > 0) {
                out.append(", ");
            }
            out.append(item);
        }
        return out.toString() + " ";
    }

    public String formatItemList(List<String> itemList, int maxWidth) {
        StringBuffer out = new StringBuffer();
        int charLength = 9;
        int availableChars = maxWidth / charLength;
        for (String item : itemList) {
            if (availableChars < 0) {
                out.append(" ...");
                return out.toString();
            }
            if (out.length() > 0) {
                if ((availableChars -= 2) <= 0) {
                    out.append(" ...");
                    return out.toString();
                }
                out.append(", ");
            }
            if (item.length() > availableChars) {
                out.append(item.substring(0, availableChars)).append("...");
                return out.toString();
            }
            availableChars -= item.length();
            out.append(item);
        }
        return out.toString() + " ";
    }

    void onResetSelections() {
        this.filterReset();
        this.updateVisualization();
    }

    public static interface View
    extends AbstractErraiDisplayer.View<SelectorDropDownDisplayer> {
        public void showTitle(String var1);

        public void margins(int var1, int var2, int var3, int var4);

        public void setWidth(int var1);

        public void showSelectHint(String var1, boolean var2);

        public void showResetHint(String var1, boolean var2);

        public void showCurrentSelection(String var1, String var2);

        public void clearItems();

        public void addItem(SelectorDropDownItem var1);

        public String getGroupsTitle();

        public String getColumnsTitle();
    }
}

