/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.client.selector;

import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.displayer.ColumnSettings;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.displayer.client.AbstractGwtDisplayer;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.renderer.client.selector.SelectorDisplayerView;

@Dependent
public class SelectorDisplayer
extends AbstractGwtDisplayer<View> {
    protected View view;
    protected boolean filterOn = false;

    public SelectorDisplayer() {
        this(new SelectorDisplayerView());
    }

    @Inject
    public SelectorDisplayer(View view) {
        this.view = view;
        this.view.init((Object)this);
    }

    public View getView() {
        return this.view;
    }

    public DisplayerConstraints createDisplayerConstraints() {
        DataSetLookupConstraints lookupConstraints = (DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupRequired(true).setGroupColumn(true).setMaxColumns(-1)).setMinColumns(1)).setExtraColumnsAllowed(true)).setGroupsTitle(this.view.getGroupsTitle()).setColumnsTitle(this.view.getColumnsTitle()).setColumnTypes((ColumnType[][])new ColumnType[][]{{ColumnType.LABEL}});
        return new DisplayerConstraints(lookupConstraints).supportsAttribute(DisplayerAttributeDef.TYPE).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.COLUMNS_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.FILTER_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.REFRESH_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.GENERAL_GROUP);
    }

    protected void createVisualization() {
        this.view.setFilterEnabled(this.displayerSettings.isFilterEnabled());
        this.updateVisualization();
    }

    protected void updateVisualization() {
        this.view.clearItems();
        DataColumn firstColumn = this.dataSet.getColumnByIndex(0);
        String firstColumnId = firstColumn.getId();
        ColumnSettings columnSettings = this.displayerSettings.getColumnSettings(firstColumn);
        String firstColumnName = columnSettings.getColumnName();
        List currentFilter = super.filterIndexes(firstColumnId);
        if (currentFilter.isEmpty()) {
            this.view.showSelectHint(firstColumnName);
        } else {
            this.view.showResetHint(firstColumnName);
        }
        for (int i = 0; i < this.dataSet.getRowCount(); ++i) {
            Object obj = this.dataSet.getValueAt(i, 0);
            if (obj == null) continue;
            String value = super.formatValue(i, 0);
            boolean selected = currentFilter != null && currentFilter.contains(i);
            this.view.addItem(Integer.toString(i), value, selected);
            int ncolumns = this.dataSet.getColumns().size();
            if (ncolumns <= 1) continue;
            StringBuilder out = new StringBuilder();
            for (int j = 1; j < ncolumns; ++j) {
                DataColumn extraColumn = this.dataSet.getColumnByIndex(j);
                columnSettings = this.displayerSettings.getColumnSettings(extraColumn);
                String extraColumnName = columnSettings.getColumnName();
                Object extraValue = this.dataSet.getValueAt(i, j);
                if (extraValue == null) continue;
                out.append(j > 1 ? "  " : "");
                String formattedValue = super.formatValue(i, j);
                out.append(extraColumnName).append("=").append(formattedValue);
            }
            this.view.setItemTitle(this.view.getItemCount() - 1, out.toString());
        }
    }

    public void onItemSelected() {
        DataColumn firstColumn = this.dataSet.getColumnByIndex(0);
        String firstColumnId = firstColumn.getId();
        List currentFilter = this.filterIndexes(firstColumnId);
        if (currentFilter != null && !currentFilter.isEmpty()) {
            this.filterReset();
        }
        ColumnSettings columnSettings = this.displayerSettings.getColumnSettings(firstColumn);
        String firstColumnName = columnSettings.getColumnName();
        String selected = this.view.getSelectedId();
        if (selected != null) {
            this.filterUpdate(firstColumnId, Integer.parseInt(selected));
            this.view.showResetHint(firstColumnName);
        } else {
            this.view.showSelectHint(firstColumnName);
        }
    }

    public void onFilterEnabled(Displayer displayer, DataSetGroup groupOp) {
        String firstColumnId = this.dataSet.getColumnByIndex(0).getId();
        List currentFilter = super.filterIndexes(firstColumnId);
        if (currentFilter.isEmpty()) {
            if (firstColumnId.equals(groupOp.getColumnGroup().getColumnId())) {
                this.columnSelectionMap.put(groupOp.getColumnGroup().getColumnId(), groupOp.getSelectedIntervalList());
            }
            super.onFilterEnabled(displayer, groupOp);
        }
    }

    public void onFilterReset(Displayer displayer, List<DataSetGroup> groupOps) {
        String firstColumnId = this.dataSet.getColumnByIndex(0).getId();
        List currentFilter = super.filterIndexes(firstColumnId);
        if (currentFilter.isEmpty()) {
            for (DataSetGroup groupOp : groupOps) {
                if (!firstColumnId.equals(groupOp.getColumnGroup().getColumnId())) continue;
                this.columnSelectionMap.remove(groupOp.getColumnGroup().getColumnId());
            }
            super.onFilterReset(displayer, groupOps);
        }
    }

    public static interface View
    extends AbstractGwtDisplayer.View<SelectorDisplayer> {
        public void showSelectHint(String var1);

        public void showResetHint(String var1);

        public void clearItems();

        public void addItem(String var1, String var2, boolean var3);

        public String getSelectedId();

        public int getItemCount();

        public void setItemTitle(int var1, String var2);

        public void setFilterEnabled(boolean var1);

        public String getGroupsTitle();

        public String getColumnsTitle();
    }
}

