/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.client.metric;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.ScriptInjector;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import org.dashbuilder.displayer.client.AbstractGwtDisplayer;
import org.dashbuilder.displayer.client.AbstractGwtDisplayerView;
import org.dashbuilder.renderer.client.DefaultRenderer;
import org.dashbuilder.renderer.client.metric.MetricDisplayer;
import org.dashbuilder.renderer.client.resources.i18n.MetricConstants;

@Dependent
public class MetricView
extends AbstractGwtDisplayerView<MetricDisplayer>
implements MetricDisplayer.View {
    FlowPanel container = new FlowPanel();
    HTMLPanel htmlPanel = null;
    String uniqueId = Document.get().createUniqueId();

    public void init(MetricDisplayer presenter) {
        this.container.getElement().setAttribute("id", this.uniqueId);
        super.setPresenter((AbstractGwtDisplayer)presenter);
        super.setVisualization((IsWidget)this.container);
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    public void clear() {
        super.clear();
        this.htmlPanel = null;
        this.container.clear();
        DefaultRenderer.closeDisplayer(this.uniqueId);
    }

    @Override
    public void setHtml(String html) {
        this.htmlPanel = new HTMLPanel(html);
        this.container.clear();
        this.container.add((Widget)this.htmlPanel);
    }

    @Override
    public String getNoDataString() {
        return MetricConstants.INSTANCE.metricDisplayer_noDataAvailable();
    }

    @Override
    public void eval(String js) {
        Scheduler.get().scheduleFixedDelay(() -> {
            Element el = Document.get().getElementById(this.uniqueId);
            if (el != null) {
                ScriptInjector.fromString((String)js).setWindow(ScriptInjector.TOP_WINDOW).setRemoveTag(true).inject();
                return false;
            }
            return true;
        }, 100);
    }

    @Override
    public String getColumnsTitle() {
        return MetricConstants.INSTANCE.metricDisplayer_columnsTitle();
    }
}

