/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.client.metric;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.common.client.StringTemplateBuilder;
import org.dashbuilder.common.client.StringUtils;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.displayer.client.AbstractGwtDisplayer;
import org.dashbuilder.displayer.client.resources.i18n.DisplayerConstants;
import org.dashbuilder.displayer.client.widgets.sourcecode.HasHtmlTemplate;
import org.dashbuilder.displayer.client.widgets.sourcecode.HasJsTemplate;

@Dependent
public class MetricDisplayer
extends AbstractGwtDisplayer<View>
implements HasHtmlTemplate,
HasJsTemplate {
    public static final List<String> TEMPLATE_KEYS = Arrays.asList("value.raw", "value", "title", "width", "height", "marginTop", "marginBottom", "marginRight", "marginLeft", "bgColor", "isFilterEnabled", "isFilterOn", "isEmpty", "doFilter");
    public static final String DEFAULT_HTML_TEMPLATE = "<div id=\"${this}\" class=\"card-pf card-pf-accented card-pf-aggregate-status\" style=\"background-color:${bgColor}; width:${width}px; height:${height}px; margin-top:${marginTop}px; margin-right:${marginRight}px; margin-bottom:${marginBottom}px; margin-left:${marginLeft}px;\">\n  <h3>${title}</h3>\n  <h2>${value}</h2>\n</div>";
    public static final String DEFAULT_JS_TEMPLATE = "if (${isFilterEnabled}) {  \n  var filterOn = false;\n  ${this}.style.cursor=\"pointer\";\n\n  ${this}.onmouseover = function() {\n    if (!filterOn) ${this}.style.backgroundColor = \"lightblue\";\n  };\n  ${this}.onmouseout = function() {\n    if (!filterOn) ${this}.style.backgroundColor = \"${bgColor}\";\n  };\n  ${this}.onclick = function() {\n    filterOn = !filterOn;\n    ${this}.style.backgroundColor = filterOn ? \"lightblue\" : \"${bgColor}\";\n    ${doFilter};\n  };\n}";
    protected View view;
    protected boolean filterOn = false;
    protected StringTemplateBuilder codeBuilder = new StringTemplateBuilder();

    @Inject
    public MetricDisplayer(View view) {
        this.view = view;
        this.view.init((Object)this);
    }

    public View getView() {
        return this.view;
    }

    public DisplayerConstraints createDisplayerConstraints() {
        DataSetLookupConstraints lookupConstraints = (DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupAllowed(false).setMaxColumns(1)).setMinColumns(1)).setFunctionRequired(true).setExtraColumnsAllowed(false)).setColumnsTitle(this.view.getColumnsTitle()).setColumnTypes((ColumnType[][])new ColumnType[][]{{ColumnType.NUMBER}});
        return new DisplayerConstraints(lookupConstraints).supportsAttribute(DisplayerAttributeDef.TYPE).supportsAttribute(DisplayerAttributeDef.RENDERER).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.COLUMNS_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.FILTER_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.REFRESH_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.GENERAL_GROUP).supportsAttribute(DisplayerAttributeDef.CHART_WIDTH).supportsAttribute(DisplayerAttributeDef.CHART_HEIGHT).supportsAttribute(DisplayerAttributeDef.CHART_BGCOLOR).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_MARGIN_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.METER_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.HTML_GROUP);
    }

    protected void createVisualization() {
        this.updateVisualization();
    }

    protected void updateVisualization() {
        String template = this.getHtmlTemplate();
        String html = this.parseHtmlTemplate(template);
        this.view.setHtml(html);
        String onDrawJs = this.getJsTemplate();
        if (onDrawJs != null) {
            onDrawJs = this.parseJsTemplate(onDrawJs);
            this.view.eval(onDrawJs);
        }
    }

    public String parseHtmlTemplate(String str) {
        this.parseTemplate(str);
        for (String key : this.codeBuilder.keys()) {
            if (TEMPLATE_KEYS.contains(key)) continue;
            String id = this.getExtraKeyId(key);
            this.codeBuilder.replace(key, id);
        }
        return this.codeBuilder.build();
    }

    public String parseJsTemplate(String str) {
        this.parseTemplate(str);
        for (String key : this.codeBuilder.keys()) {
            if (TEMPLATE_KEYS.contains(key)) continue;
            String id = this.getExtraKeyId(key);
            this.codeBuilder.replace(key, "document.getElementById(\"" + id + "\")");
        }
        return this.codeBuilder.build();
    }

    protected void parseTemplate(String template) {
        boolean isEmpty = this.dataSet.getRowCount() == 0;
        Double valueRaw = isEmpty ? 0.0 : (Double)this.dataSet.getValueAt(0, 0);
        String valueStr = isEmpty ? this.view.getNoDataString() : super.formatValue(0, 0);
        String title = this.displayerSettings.isTitleVisible() ? this.displayerSettings.getTitle() : "";
        String bgcolor = this.displayerSettings.getChartBackgroundColor();
        bgcolor = !StringUtils.isBlank((String)bgcolor) ? bgcolor : "white";
        try {
            Integer.parseInt(bgcolor, 16);
            bgcolor = "#" + bgcolor;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.codeBuilder.setTemplate(template);
        this.codeBuilder.replace("value.raw", Double.toString(valueRaw)).replace("value", valueStr != null ? valueStr : "").replace("title", title).replace("width", Integer.toString(this.displayerSettings.getChartWidth())).replace("height", Integer.toString(this.displayerSettings.getChartHeight())).replace("marginTop", Integer.toString(this.displayerSettings.getChartMarginTop())).replace("marginBottom", Integer.toString(this.displayerSettings.getChartMarginBottom())).replace("marginRight", Integer.toString(this.displayerSettings.getChartMarginRight())).replace("marginLeft", Integer.toString(this.displayerSettings.getChartMarginLeft())).replace("value.start", Long.toString(this.displayerSettings.getMeterStart())).replace("value.warning", Long.toString(this.displayerSettings.getMeterWarning())).replace("value.critical", Long.toString(this.displayerSettings.getMeterCritical())).replace("value.end", Long.toString(this.displayerSettings.getMeterEnd())).replace("bgColor", bgcolor).replace("isFilterEnabled", Boolean.toString(this.isFilterEnabled())).replace("isFilterOn", Boolean.toString(this.isFilterOn())).replace("isEmpty", Boolean.toString(isEmpty)).replace("doFilter", "window.metricDisplayerDoFilter('" + this.view.getUniqueId() + "')");
    }

    public String getExtraKeyId(String key) {
        return this.view.getUniqueId() + "_" + key;
    }

    public boolean isFilterOn() {
        return this.filterOn;
    }

    public void setFilterOn(boolean on) {
        this.filterOn = on;
    }

    public boolean isFilterEnabled() {
        return this.displayerSettings.isFilterEnabled() && this.fetchFilter() != null;
    }

    public void updateFilter() {
        if (this.isFilterEnabled()) {
            if (this.filterOn) {
                this.filterReset();
            } else if (this.displayerSettings.isFilterEnabled()) {
                this.filterApply();
            }
        }
    }

    public DataSetFilter fetchFilter() {
        if (this.displayerSettings.getDataSetLookup() == null) {
            return null;
        }
        List filterOps = this.displayerSettings.getDataSetLookup().getOperationList(DataSetFilter.class);
        if (filterOps == null || filterOps.isEmpty()) {
            return null;
        }
        DataSetFilter filter = new DataSetFilter();
        for (DataSetFilter filterOp : filterOps) {
            filter.getColumnFilterList().addAll(filterOp.getColumnFilterList());
        }
        return filter;
    }

    public void filterApply() {
        DataSetFilter filter = this.fetchFilter();
        if (this.displayerSettings.isFilterEnabled() && filter != null) {
            this.filterOn = true;
            super.filterApply(filter);
        }
    }

    public void filterReset() {
        DataSetFilter filter = this.fetchFilter();
        if (this.filterOn && filter != null) {
            this.filterOn = false;
            super.filterReset();
        }
    }

    public String getHtmlTemplate() {
        String template = this.displayerSettings.getHtmlTemplate();
        if (StringUtils.isBlank((String)template)) {
            return DEFAULT_HTML_TEMPLATE;
        }
        return template;
    }

    public Map<String, String> getHtmlVariableMap() {
        return this.getCommonVariableMap();
    }

    public String getJsTemplate() {
        String template = this.displayerSettings.getJsTemplate();
        if (StringUtils.isBlank((String)template)) {
            return DEFAULT_JS_TEMPLATE;
        }
        return template;
    }

    public Map<String, String> getJsVariableMap() {
        HashMap<String, String> varMap = new HashMap<String, String>();
        String template = this.getHtmlTemplate();
        this.codeBuilder.setTemplate(template);
        for (String key : this.codeBuilder.keys()) {
            if (TEMPLATE_KEYS.contains(key)) continue;
            String var = this.codeBuilder.asVar(key);
            varMap.put(var, DisplayerConstants.INSTANCE.userDefinedVariableDescription());
        }
        varMap.putAll(this.getCommonVariableMap());
        varMap.put(this.asVar("doFilter"), DisplayerConstants.INSTANCE.doFilterVariableDescription());
        return varMap;
    }

    protected Map<String, String> getCommonVariableMap() {
        HashMap<String, String> varMap = new HashMap<String, String>();
        varMap.put(this.asVar("value.raw"), DisplayerConstants.INSTANCE.valueRawVariableDescription());
        varMap.put(this.asVar("value.start"), DisplayerConstants.INSTANCE.valueStartVariableDescription());
        varMap.put(this.asVar("value.warning"), DisplayerConstants.INSTANCE.valueWarningVariableDescription());
        varMap.put(this.asVar("value.critical"), DisplayerConstants.INSTANCE.valueCriticalVariableDescription());
        varMap.put(this.asVar("value.end"), DisplayerConstants.INSTANCE.valueEndVariableDescription());
        varMap.put(this.asVar("value"), DisplayerConstants.INSTANCE.valueVariableDescription());
        varMap.put(this.asVar("title"), DisplayerConstants.INSTANCE.titleVariableDescription());
        varMap.put(this.asVar("width"), DisplayerConstants.INSTANCE.widthVariableDescription());
        varMap.put(this.asVar("height"), DisplayerConstants.INSTANCE.heightVariableDescription());
        varMap.put(this.asVar("marginTop"), DisplayerConstants.INSTANCE.marginTopVariableDescription());
        varMap.put(this.asVar("marginBottom"), DisplayerConstants.INSTANCE.marginBottomVariableDescription());
        varMap.put(this.asVar("marginRight"), DisplayerConstants.INSTANCE.marginRightVariableDescription());
        varMap.put(this.asVar("marginLeft"), DisplayerConstants.INSTANCE.marginLeftVariableDescription());
        varMap.put(this.asVar("bgColor"), DisplayerConstants.INSTANCE.bgColorVariableDescription());
        varMap.put(this.asVar("isFilterEnabled"), DisplayerConstants.INSTANCE.isFilterEnabledVariableDescription());
        varMap.put(this.asVar("isFilterOn"), DisplayerConstants.INSTANCE.isFilterOnVariableDescription());
        varMap.put(this.asVar("isEmpty"), DisplayerConstants.INSTANCE.isEmptyVariableDescription());
        return varMap;
    }

    protected String asVar(String key) {
        return this.codeBuilder.asVar(key);
    }

    public static interface View
    extends AbstractGwtDisplayer.View<MetricDisplayer> {
        public String getUniqueId();

        public void setHtml(String var1);

        public void eval(String var1);

        public String getNoDataString();

        public String getColumnsTitle();
    }
}

