/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.client.table;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.Range;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.dashbuilder.common.client.widgets.FilterLabelSet;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.displayer.client.AbstractGwtDisplayer;
import org.dashbuilder.displayer.client.AbstractGwtDisplayerView;
import org.dashbuilder.displayer.client.export.ExportFormat;
import org.dashbuilder.renderer.client.resources.i18n.TableConstants;
import org.dashbuilder.renderer.client.table.TableDisplayer;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;

public class TableDisplayerView
extends AbstractGwtDisplayerView<TableDisplayer>
implements TableDisplayer.View {
    protected HTML titleHtml = new HTML();
    protected TableProvider tableProvider = new TableProvider();
    protected VerticalPanel rootPanel = new VerticalPanel();
    protected PagedTable<Integer> table;
    protected Button exportToCsvButton;
    protected Button exportToXlsButton;

    public void init(TableDisplayer presenter) {
        super.setPresenter((AbstractGwtDisplayer)presenter);
        super.setVisualization((IsWidget)this.rootPanel);
        this.rootPanel.add((Widget)this.titleHtml);
    }

    @Override
    public void showTitle(String title) {
        this.titleHtml.setText(title);
    }

    @Override
    public String getGroupsTitle() {
        return TableConstants.INSTANCE.tableDisplayer_groupsTitle();
    }

    @Override
    public String getColumnsTitle() {
        return TableConstants.INSTANCE.tableDisplayer_columnsTitle();
    }

    @Override
    public void createTable(int pageSize, FilterLabelSet filterLabelSet) {
        this.table = new PagedTable(pageSize);
        this.table.pageSizesSelector.setVisible(false);
        this.table.setEmptyTableCaption(TableConstants.INSTANCE.tableDisplayer_noDataAvailable());
        this.table.pageSizesSelector.setForceDropup(true);
        this.table.pageSizesSelector.setDropupAuto(false);
        this.tableProvider.addDataDisplay((HasData<Integer>)this.table);
        this.tableProvider.lastPageSize = pageSize;
        HTMLElement element = filterLabelSet.getElement();
        element.getStyle().setProperty("margin-bottom", "5px");
        this.table.getLeftToolbar().add((Widget)ElementWrapperWidget.getWidget((HTMLElement)filterLabelSet.getElement()));
        this.exportToCsvButton = new Button("", IconType.FILE_TEXT, e -> ((TableDisplayer)this.getPresenter()).export(ExportFormat.CSV));
        this.exportToXlsButton = new Button("", IconType.FILE_EXCEL_O, e -> ((TableDisplayer)this.getPresenter()).export(ExportFormat.XLS));
        this.exportToCsvButton.setTitle(TableConstants.INSTANCE.tableDisplayer_export_to_csv());
        this.exportToXlsButton.setTitle(TableConstants.INSTANCE.tableDisplayer_export_to_xls());
        this.setupToolbar();
        this.rootPanel.add(this.table);
    }

    protected void setupToolbar() {
        HasWidgets rightToolbar = this.table.getRightToolbar();
        if (rightToolbar instanceof HorizontalPanel) {
            ((HorizontalPanel)rightToolbar).insert((Widget)this.exportToCsvButton, 0);
            ((HorizontalPanel)rightToolbar).insert((Widget)this.exportToXlsButton, 1);
        } else {
            rightToolbar.add((Widget)this.exportToCsvButton);
            rightToolbar.add((Widget)this.exportToXlsButton);
        }
    }

    @Override
    public void redrawTable() {
        this.table.redraw();
    }

    @Override
    public void setWidth(int width) {
        this.table.setWidth(width + "px");
    }

    @Override
    public void setSortEnabled(boolean enabled) {
        this.table.addColumnSortHandler((ColumnSortEvent.Handler)new ColumnSortEvent.AsyncHandler((HasData)this.table){

            public void onColumnSort(ColumnSortEvent event) {
                String column = ((DataColumnCell)event.getColumn().getCell()).columnId;
                SortOrder order = event.isSortAscending() ? SortOrder.ASCENDING : SortOrder.DESCENDING;
                ((TableDisplayer)TableDisplayerView.this.getPresenter()).sortBy(column, order);
            }
        });
    }

    @Override
    public void setTotalRows(int rows, boolean isExact) {
        if (this.table != null) {
            this.table.setRowCount(rows, isExact);
        }
    }

    @Override
    public void setPagerEnabled(boolean enabled) {
        this.table.pager.setVisible(enabled);
    }

    @Override
    public void setColumnPickerEnabled(boolean enabled) {
        this.table.setColumnPickerButtonVisible(enabled);
    }

    @Override
    public void setExportToCsvEnabled(boolean enabled) {
        this.exportToCsvButton.setVisible(enabled);
    }

    @Override
    public void setExportToXlsEnabled(boolean enabled) {
        this.exportToXlsButton.setVisible(enabled);
    }

    @Override
    public void addColumn(ColumnType columnType, String columnId, String columnName, int index, boolean selectEnabled, boolean sortEnabled) {
        Column<Integer, ?> column = this.createColumn(columnType, columnId, selectEnabled, index);
        if (column != null) {
            column.setSortable(sortEnabled);
            this.table.addColumn(column, columnName);
        }
    }

    @Override
    public void gotoFirstPage() {
        this.tableProvider.gotoFirstPage();
    }

    @Override
    public int getLastOffset() {
        return this.tableProvider.lastOffset;
    }

    @Override
    public int getPageSize() {
        return this.tableProvider.lastPageSize;
    }

    @Override
    public void exportNoData() {
        Window.alert((String)TableConstants.INSTANCE.tableDisplayer_export_no_data());
    }

    @Override
    public void exportTooManyRows(int rowNum, int limit) {
        Window.alert((String)TableConstants.INSTANCE.tableDisplayer_export_too_many_rows(rowNum, limit));
    }

    @Override
    public void exportFileUrl(String url) {
        Window.open((String)url, (String)"downloading", (String)"resizable=no,scrollbars=yes,status=no");
    }

    protected Column<Integer, ?> createColumn(ColumnType type, String columnId, boolean selectable, final int columnNumber) {
        switch (type) {
            case LABEL: {
                return new Column<Integer, String>((Cell)new DataColumnCell(columnId, selectable)){

                    public String getValue(Integer row) {
                        return ((TableDisplayer)TableDisplayerView.this.getPresenter()).formatValue(row, columnNumber);
                    }
                };
            }
            case NUMBER: 
            case DATE: 
            case TEXT: {
                return new Column<Integer, String>((Cell)new DataColumnCell(columnId, selectable)){

                    public String getValue(Integer row) {
                        return ((TableDisplayer)TableDisplayerView.this.getPresenter()).formatValue(row, columnNumber);
                    }
                };
            }
        }
        return null;
    }

    protected class TableProvider
    extends AsyncDataProvider<Integer> {
        protected int lastOffset = 0;
        protected int lastPageSize = 0;

        protected TableProvider() {
        }

        protected List<Integer> getCurrentPageRows(HasData<Integer> display) {
            int start = display.getVisibleRange().getStart();
            int pageSize = display.getVisibleRange().getLength();
            int items = Integer.min(pageSize, TableDisplayerView.this.table.getRowCount() > start ? TableDisplayerView.this.table.getRowCount() - start : TableDisplayerView.this.table.getRowCount());
            return IntStream.range(0, items).boxed().collect(Collectors.toList());
        }

        public void gotoFirstPage() {
            this.lastOffset = 0;
            this.lastPageSize = TableDisplayerView.this.table.getVisibleRange().getLength();
            TableDisplayerView.this.table.pager.setPage(0);
            int start = TableDisplayerView.this.table.getVisibleRange().getStart();
            List<Integer> rows = this.getCurrentPageRows((HasData<Integer>)TableDisplayerView.this.table);
            this.updateRowData(start, rows);
        }

        public void addDataDisplay(HasData<Integer> display) {
            this.lastOffset = 0;
            this.lastPageSize = TableDisplayerView.this.table.getVisibleRange().getLength();
            super.addDataDisplay(display);
        }

        protected void onRangeChanged(HasData<Integer> display) {
            Range range = display.getVisibleRange();
            if (this.lastOffset == range.getStart() && range.getLength() <= this.lastPageSize) {
                this.lastPageSize = range.getLength();
                if (TableDisplayerView.this.table.getRowCount() > range.getLength()) {
                    TableDisplayerView.this.setPagerEnabled(true);
                }
                this.updateRowData(this.lastOffset, this.getCurrentPageRows(display));
            } else {
                this.lastOffset = range.getStart();
                this.lastPageSize = range.getLength();
                ((TableDisplayer)TableDisplayerView.this.getPresenter()).lookupCurrentPage((Callback<Integer>)((Callback)rowsFetched -> {
                    List<Integer> rows = this.getCurrentPageRows(display);
                    this.updateRowData(this.lastOffset, rows);
                }));
            }
        }
    }

    protected class DataColumnCell
    extends TextCell {
        private String columnId;
        private boolean selectable = false;

        DataColumnCell(String columnId, boolean selectable) {
            this.columnId = columnId;
            this.selectable = selectable;
        }

        public Set<String> getConsumedEvents() {
            HashSet<String> consumedEvents = new HashSet<String>();
            if (this.selectable) {
                consumedEvents.add("click");
                consumedEvents.add("mouseover");
            }
            return consumedEvents;
        }

        public void onBrowserEvent(Cell.Context context, Element parent, String value, NativeEvent event, ValueUpdater<String> valueUpdater) {
            if (this.selectable) {
                String eventType;
                switch (eventType = event.getType()) {
                    case "mouseover": {
                        parent.getStyle().setCursor(Style.Cursor.POINTER);
                        break;
                    }
                    case "click": {
                        int rowIndexInPage = context.getIndex() - TableDisplayerView.this.table.getPageStart();
                        ((TableDisplayer)TableDisplayerView.this.getPresenter()).selectCell(this.columnId, rowIndexInPage);
                    }
                }
            }
        }
    }
}

