/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.client.selector;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.GroupStrategy;
import org.dashbuilder.dataset.sort.DataSetSort;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.displayer.ColumnSettings;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.displayer.client.AbstractErraiDisplayer;
import org.dashbuilder.renderer.client.selector.SelectorLabelItem;
import org.jboss.errai.ioc.client.container.SyncBeanManager;

@Dependent
public class SelectorLabelSetDisplayer
extends AbstractErraiDisplayer<View> {
    protected View view;
    protected boolean filterOn = false;
    protected boolean multipleSelections = false;
    protected SyncBeanManager beanManager;
    protected Set<SelectorLabelItem> itemCollection = new HashSet<SelectorLabelItem>();

    @Inject
    public SelectorLabelSetDisplayer(View view, SyncBeanManager beanManager) {
        this.beanManager = beanManager;
        this.view = view;
        this.view.init((Object)this);
    }

    public View getView() {
        return this.view;
    }

    public void close() {
        super.close();
        this.clearItems();
    }

    protected void clearItems() {
        this.view.clearItems();
        for (SelectorLabelItem item : this.itemCollection) {
            this.beanManager.destroyBean((Object)item);
        }
        this.itemCollection.clear();
    }

    protected void resetItems() {
        for (SelectorLabelItem item : this.itemCollection) {
            item.reset();
        }
    }

    public DisplayerConstraints createDisplayerConstraints() {
        DataSetLookupConstraints lookupConstraints = ((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupRequired(true).setGroupColumn(true).setMaxColumns(-1)).setMinColumns(1)).setExtraColumnsAllowed(true)).setGroupsTitle(this.view.getGroupsTitle()).setColumnsTitle(this.view.getColumnsTitle());
        return new DisplayerConstraints(lookupConstraints).supportsAttribute(DisplayerAttributeDef.TYPE).supportsAttribute(DisplayerAttributeDef.SUBTYPE).supportsAttribute(DisplayerAttributeDef.RENDERER).supportsAttribute(DisplayerAttributeDef.TITLE).supportsAttribute(DisplayerAttributeDef.TITLE_VISIBLE).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.SELECTOR_GROUP).excludeAttribute(DisplayerAttributeDef.SELECTOR_SHOW_INPUTS).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_MARGIN_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.COLUMNS_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.FILTER_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.REFRESH_GROUP);
    }

    protected void beforeDataSetLookup() {
        ColumnGroup column;
        DataSetGroup group = this.dataSetHandler.getCurrentDataSetLookup().getLastGroupOp();
        if (this.dataSetHandler.getCurrentDataSetLookup().getOperationList(DataSetSort.class).isEmpty() && group != null && !GroupStrategy.FIXED.equals((Object)(column = group.getColumnGroup()).getStrategy())) {
            this.dataSetHandler.sort(column.getSourceId(), SortOrder.ASCENDING);
        }
    }

    protected void createVisualization() {
        if (this.displayerSettings.isTitleVisible()) {
            this.view.showTitle(this.displayerSettings.getTitle());
        }
        this.view.margins(this.displayerSettings.getChartMarginTop(), this.displayerSettings.getChartMarginBottom(), this.displayerSettings.getChartMarginLeft(), this.displayerSettings.getChartMarginRight());
        this.multipleSelections = this.displayerSettings.isSelectorMultiple();
        this.updateVisualization();
    }

    protected void updateVisualization() {
        this.clearItems();
        if (this.dataSet.getRowCount() == 0) {
            this.view.noData();
        } else {
            for (int i = 0; i < this.dataSet.getRowCount(); ++i) {
                Object obj = this.dataSet.getValueAt(i, 0);
                if (obj == null) continue;
                String value = super.formatValue(i, 0);
                StringBuilder title = new StringBuilder();
                int ncolumns = this.dataSet.getColumns().size();
                if (ncolumns > 1) {
                    for (int j = 1; j < ncolumns; ++j) {
                        DataColumn extraColumn = this.dataSet.getColumnByIndex(j);
                        ColumnSettings columnSettings = this.displayerSettings.getColumnSettings(extraColumn);
                        String extraColumnName = columnSettings.getColumnName();
                        Object extraValue = this.dataSet.getValueAt(i, j);
                        if (extraValue == null) continue;
                        title.append(j > 1 ? " " : "");
                        String formattedValue = super.formatValue(i, j);
                        title.append(extraColumnName).append("=").append(formattedValue);
                    }
                }
                SelectorLabelItem item = (SelectorLabelItem)this.beanManager.lookupBean(SelectorLabelItem.class, new Annotation[0]).newInstance();
                item.init(i, value, title.toString());
                item.setOnSelectCommand(() -> this.onItemSelected(item));
                item.setOnResetCommand(() -> this.onItemReset(item));
                this.view.addItem(item);
                this.itemCollection.add(item);
            }
            if (this.displayerSettings.getSelectorWidth() > 0) {
                this.view.setWidth(this.displayerSettings.getSelectorWidth() + 100);
                int itemWidth = 85 / this.itemCollection.size();
                for (SelectorLabelItem labelItem : this.itemCollection) {
                    labelItem.setWidth(itemWidth);
                }
            }
        }
    }

    public String getFirstColumnId() {
        DataColumn firstColumn = this.dataSet.getColumnByIndex(0);
        return firstColumn.getId();
    }

    void onItemSelected(SelectorLabelItem item) {
        if (this.displayerSettings.isFilterEnabled()) {
            List currentFilter;
            String firstColumnId = this.getFirstColumnId();
            if (!this.multipleSelections && (currentFilter = this.filterIndexes(firstColumnId)) != null && !currentFilter.isEmpty()) {
                this.resetItems();
                super.filterReset();
                item.select();
            }
            this.filterUpdate(firstColumnId, item.getId());
        }
    }

    void onItemReset(SelectorLabelItem item) {
        if (this.displayerSettings.isFilterEnabled()) {
            String firstColumnId = this.getFirstColumnId();
            this.filterUpdate(firstColumnId, item.getId());
        }
    }

    public static interface View
    extends AbstractErraiDisplayer.View<SelectorLabelSetDisplayer> {
        public void showTitle(String var1);

        public void setWidth(int var1);

        public void margins(int var1, int var2, int var3, int var4);

        public void clearItems();

        public void addItem(SelectorLabelItem var1);

        public String getGroupsTitle();

        public String getColumnsTitle();

        public void noData();
    }
}

