/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.client.selector;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import javax.inject.Inject;
import org.dashbuilder.displayer.client.AbstractErraiDisplayer;
import org.dashbuilder.displayer.client.AbstractErraiDisplayerView;
import org.dashbuilder.renderer.client.resources.i18n.SelectorConstants;
import org.dashbuilder.renderer.client.selector.SelectorDropDownDisplayer;
import org.dashbuilder.renderer.client.selector.SelectorDropDownItem;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Templated
public class SelectorDropDownDisplayerView
extends AbstractErraiDisplayerView<SelectorDropDownDisplayer>
implements SelectorDropDownDisplayer.View {
    @Inject
    @DataField
    Div containerDiv;
    @Inject
    @DataField
    Span titleSpan;
    @Inject
    @DataField
    Div dropDownDiv;
    @Inject
    @DataField
    Button dropDownButton;
    @Inject
    @DataField
    Div dropDownText;
    @Inject
    @DataField
    UnorderedList resetMenu;
    @Inject
    @DataField
    UnorderedList dropDownMenu;
    @Inject
    @DataField
    Anchor resetAnchor;

    public void init(SelectorDropDownDisplayer presenter) {
        super.setPresenter((AbstractErraiDisplayer)presenter);
        super.setVisualization((Element)this.containerDiv);
    }

    @Override
    public void showTitle(String title) {
        this.titleSpan.setTextContent(title);
    }

    @Override
    public void margins(int top, int bottom, int left, int right) {
        this.containerDiv.getStyle().setProperty("margin-top", top + "px");
        this.containerDiv.getStyle().setProperty("margin-bottom", bottom + "px");
        this.containerDiv.getStyle().setProperty("margin-left", left + "px");
        this.containerDiv.getStyle().setProperty("margin-right", right + "px");
    }

    @Override
    public void setWidth(int width) {
        if (width > 0) {
            this.dropDownButton.getStyle().setProperty("width", width + "px");
            this.dropDownMenu.getStyle().setProperty("width", width + "px");
            this.resetMenu.getStyle().setProperty("width", width + "px");
            this.dropDownText.getStyle().setProperty("max-width", width - 30 + "px");
        } else {
            this.dropDownButton.getStyle().removeProperty("width");
            this.dropDownMenu.getStyle().removeProperty("width");
            this.resetMenu.getStyle().removeProperty("width");
            this.dropDownText.getStyle().removeProperty("max-width");
        }
    }

    @Override
    public void showSelectHint(String column, boolean multiple) {
        String hint = "- " + SelectorConstants.INSTANCE.selectorDisplayer_select() + " " + column + " - ";
        this.dropDownText.setTextContent(hint);
        this.resetMenu.getStyle().setProperty("display", "none");
    }

    @Override
    public void showResetHint(String column, boolean multiple) {
        String resetAction = multiple ? SelectorConstants.INSTANCE.selectorDisplayer_clearAll() : SelectorConstants.INSTANCE.selectorDisplayer_reset();
        this.resetAnchor.setTextContent(resetAction);
        this.resetMenu.getStyle().removeProperty("display");
        int n = this.dropDownMenu.getChildNodes().getLength() * 25;
        this.resetMenu.getStyle().setProperty("margin-top", (n > 250 ? 250 : n) + "px");
    }

    @Override
    public void showCurrentSelection(String text, String hint) {
        this.dropDownText.setTextContent(text);
        this.dropDownButton.setTitle(hint);
    }

    @Override
    public void clearItems() {
        DOMUtil.removeAllChildren((Node)this.dropDownMenu);
    }

    @Override
    public void addItem(SelectorDropDownItem item) {
        this.dropDownMenu.appendChild((Node)item.getView().getElement());
    }

    @Override
    public String getGroupsTitle() {
        return SelectorConstants.INSTANCE.selectorDisplayer_groupsTitle();
    }

    @Override
    public String getColumnsTitle() {
        return SelectorConstants.INSTANCE.selectorDisplayer_columnsTitle();
    }

    @EventHandler(value={"resetAnchor"})
    private void onResetClicked(ClickEvent event) {
        ((SelectorDropDownDisplayer)this.presenter).onResetSelections();
    }
}

