/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.client;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.displayer.DisplayerType;
import org.dashbuilder.displayer.client.AbstractRendererLibrary;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.renderer.client.metric.MetricDisplayer;
import org.dashbuilder.renderer.client.selector.SelectorDisplayer;
import org.dashbuilder.renderer.client.selector.SelectorDropDownDisplayer;
import org.dashbuilder.renderer.client.selector.SelectorLabelSetDisplayer;
import org.dashbuilder.renderer.client.selector.SelectorSliderDisplayer;
import org.dashbuilder.renderer.client.table.TableDisplayer;
import org.jboss.errai.ioc.client.container.SyncBeanManager;

@ApplicationScoped
public class DefaultRenderer
extends AbstractRendererLibrary {
    public static final String UUID = "default";
    @Inject
    protected SyncBeanManager beanManager;
    protected static Map<String, MetricDisplayer> _metricDisplayerMap = new HashMap<String, MetricDisplayer>();

    @PostConstruct
    private void init() {
        this.publishJsFunctions();
    }

    public String getUUID() {
        return UUID;
    }

    public String getName() {
        return "GWT Core";
    }

    public boolean isDefault(DisplayerType type) {
        return DisplayerType.TABLE.equals((Object)type) || DisplayerType.SELECTOR.equals((Object)type) || DisplayerType.METRIC.equals((Object)type);
    }

    public List<DisplayerType> getSupportedTypes() {
        return Arrays.asList(DisplayerType.TABLE, DisplayerType.SELECTOR, DisplayerType.METRIC);
    }

    public List<DisplayerSubType> getSupportedSubtypes(DisplayerType displayerType) {
        switch (displayerType) {
            case METRIC: {
                return Arrays.asList(DisplayerSubType.METRIC_CARD, DisplayerSubType.METRIC_CARD2, DisplayerSubType.METRIC_QUOTA, DisplayerSubType.METRIC_PLAIN_TEXT);
            }
            case SELECTOR: {
                return Arrays.asList(DisplayerSubType.SELECTOR_DROPDOWN, DisplayerSubType.SELECTOR_LABELS, DisplayerSubType.SELECTOR_SLIDER);
            }
        }
        return Collections.emptyList();
    }

    public Displayer lookupDisplayer(DisplayerSettings displayerSettings) {
        DisplayerType type = displayerSettings.getType();
        DisplayerSubType subtype = displayerSettings.getSubtype();
        if (DisplayerType.TABLE.equals((Object)type)) {
            return (Displayer)this.beanManager.lookupBean(TableDisplayer.class, new Annotation[0]).newInstance();
        }
        if (DisplayerType.SELECTOR.equals((Object)type)) {
            if (DisplayerSubType.SELECTOR_DROPDOWN.equals((Object)subtype)) {
                return (Displayer)this.beanManager.lookupBean(SelectorDropDownDisplayer.class, new Annotation[0]).newInstance();
            }
            if (DisplayerSubType.SELECTOR_LABELS.equals((Object)subtype)) {
                return (Displayer)this.beanManager.lookupBean(SelectorLabelSetDisplayer.class, new Annotation[0]).newInstance();
            }
            if (DisplayerSubType.SELECTOR_SLIDER.equals((Object)subtype)) {
                return (Displayer)this.beanManager.lookupBean(SelectorSliderDisplayer.class, new Annotation[0]).newInstance();
            }
            return (Displayer)this.beanManager.lookupBean(SelectorDisplayer.class, new Annotation[0]).newInstance();
        }
        if (DisplayerType.METRIC.equals((Object)type)) {
            MetricDisplayer displayer = (MetricDisplayer)((Object)this.beanManager.lookupBean(MetricDisplayer.class, new Annotation[0]).newInstance());
            _metricDisplayerMap.put(displayer.getView().getUniqueId(), displayer);
            return displayer;
        }
        return null;
    }

    private native void publishJsFunctions();

    public static void metricDisplayerDoFilter(String displayerId) {
        MetricDisplayer displayer = _metricDisplayerMap.get(displayerId);
        if (displayer != null) {
            displayer.updateFilter();
        }
    }

    public static void closeDisplayer(String displayerId) {
        _metricDisplayerMap.remove(displayerId);
    }
}

