/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.client.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.common.client.StringUtils;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.common.client.widgets.FilterLabel;
import org.dashbuilder.common.client.widgets.FilterLabelSet;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.displayer.ColumnSettings;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.displayer.client.AbstractGwtDisplayer;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.export.ExportCallback;
import org.dashbuilder.displayer.client.export.ExportFormat;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.mvp.Command;

@Dependent
public class TableDisplayer
extends AbstractGwtDisplayer<View> {
    protected View view;
    protected int totalRows = 0;
    protected String lastOrderedColumn = null;
    protected SortOrder lastSortOrder = null;
    protected List<Command> onCellSelectedCommands = new ArrayList<Command>();
    protected String selectedCellColumn = null;
    protected Integer selectedCellRow = null;
    protected int exportRowNumMax = 100000;
    protected FilterLabelSet filterLabelSet;

    @Inject
    public TableDisplayer(View view, FilterLabelSet filterLabelSet) {
        this.view = view;
        this.view.init((Object)this);
        this.filterLabelSet = filterLabelSet;
        this.filterLabelSet.setOnClearAllCommand(this::onFilterClearAll);
    }

    public View getView() {
        return this.view;
    }

    public FilterLabelSet getFilterLabelSet() {
        return this.filterLabelSet;
    }

    public int getTotalRows() {
        return this.totalRows;
    }

    public String getLastOrderedColumn() {
        return this.lastOrderedColumn;
    }

    public SortOrder getLastSortOrder() {
        return this.lastSortOrder;
    }

    public String getSelectedCellColumn() {
        return this.selectedCellColumn;
    }

    public Integer getSelectedCellRow() {
        return this.selectedCellRow;
    }

    public int getExportRowNumMax() {
        return this.exportRowNumMax;
    }

    public void setExportRowNumMax(int exportRowNumMax) {
        this.exportRowNumMax = exportRowNumMax;
    }

    public void addOnCellSelectedCommand(Command onCellSelectedCommand) {
        this.onCellSelectedCommands.add(onCellSelectedCommand);
    }

    public DisplayerConstraints createDisplayerConstraints() {
        DataSetLookupConstraints lookupConstraints = ((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupAllowed(true).setGroupRequired(false).setExtraColumnsAllowed(true)).setGroupsTitle(this.view.getGroupsTitle()).setColumnsTitle(this.view.getColumnsTitle());
        return new DisplayerConstraints(lookupConstraints).supportsAttribute(DisplayerAttributeDef.TYPE).supportsAttribute(DisplayerAttributeDef.RENDERER).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.COLUMNS_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.FILTER_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.REFRESH_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.GENERAL_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.EXPORT_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.TABLE_GROUP);
    }

    protected void beforeDataSetLookup() {
        String defaultSortColumn;
        if (this.lastOrderedColumn == null && !StringUtils.isBlank((String)(defaultSortColumn = this.displayerSettings.getTableDefaultSortColumnId()))) {
            this.lastOrderedColumn = defaultSortColumn;
            this.lastSortOrder = this.displayerSettings.getTableDefaultSortOrder();
        }
        if (this.lastOrderedColumn != null) {
            this.sortApply(this.lastOrderedColumn, this.lastSortOrder);
        }
        this.dataSetHandler.limitDataSetRows(this.view.getLastOffset(), this.getPageSize());
    }

    protected int getPageSize() {
        return this.view.getPageSize() == 0 ? this.displayerSettings.getTablePageSize() : this.view.getPageSize();
    }

    protected void afterDataSetLookup(DataSet dataSet) {
        this.totalRows = dataSet.getRowCountNonTrimmed();
        this.view.setTotalRows(this.totalRows, this.isTotalRowsExact(dataSet, this.totalRows));
    }

    protected void createVisualization() {
        if (this.displayerSettings.isTitleVisible()) {
            this.view.showTitle(this.displayerSettings.getTitle());
        }
        List dataColumns = this.dataSet.getColumns();
        int width = this.displayerSettings.getTableWidth();
        this.view.createTable(this.displayerSettings.getTablePageSize(), this.filterLabelSet);
        this.view.setWidth(width == 0 ? dataColumns.size() * 100 + 40 : width);
        this.view.setSortEnabled(this.displayerSettings.isTableSortEnabled());
        this.view.setTotalRows(this.totalRows, this.isTotalRowsExact(this.dataSet, this.totalRows));
        this.view.setPagerEnabled(this.isPagerEnabled(this.dataSet, this.totalRows));
        this.view.setColumnPickerEnabled(this.displayerSettings.isTableColumnPickerEnabled());
        this.view.setExportToCsvEnabled(this.displayerSettings.isCSVExportAllowed());
        this.view.setExportToXlsEnabled(this.displayerSettings.isExcelExportAllowed());
        block3: for (int i = 0; i < dataColumns.size(); ++i) {
            DataColumn dataColumn = (DataColumn)dataColumns.get(i);
            ColumnSettings columnSettings = this.displayerSettings.getColumnSettings(dataColumn);
            String columnName = columnSettings.getColumnName();
            switch (dataColumn.getColumnType()) {
                case LABEL: {
                    this.view.addColumn(dataColumn.getColumnType(), dataColumn.getId(), columnName, i, this.displayerSettings.isFilterEnabled(), true);
                    continue block3;
                }
                default: {
                    this.view.addColumn(dataColumn.getColumnType(), dataColumn.getId(), columnName, i, false, true);
                }
            }
        }
        this.view.gotoFirstPage();
    }

    protected boolean isTotalRowsExact(DataSet dataSet, int totalRows) {
        return this.isRemoteProvider(dataSet) ? totalRows < this.getPageSize() : true;
    }

    protected boolean isPagerEnabled(DataSet dataSet, int totalRows) {
        return this.isRemoteProvider(dataSet) ? totalRows == this.getPageSize() : this.getPageSize() < dataSet.getRowCountNonTrimmed();
    }

    protected boolean isRemoteProvider(DataSet dataSet) {
        DataSetDef def = dataSet.getDefinition();
        return def == null || def.getProvider() == null ? false : def.getProvider().getName().equals("REMOTE");
    }

    protected void updateVisualization() {
        this.view.setTotalRows(this.totalRows, this.isTotalRowsExact(this.dataSet, this.totalRows));
        this.view.setPagerEnabled(this.isPagerEnabled(this.dataSet, this.totalRows));
        this.view.gotoFirstPage();
        this.view.redrawTable();
        this.updateFilterStatus();
    }

    protected void updateFilterStatus() {
        this.filterLabelSet.clear();
        Set columnFilters = this.filterColumns();
        if (this.displayerSettings.isFilterEnabled() && !columnFilters.isEmpty()) {
            for (String columnId : columnFilters) {
                List selectedValues = this.filterIntervals(columnId);
                DataColumn column = this.dataSet.getColumnById(columnId);
                for (Interval interval : selectedValues) {
                    String formattedValue = this.formatInterval(interval, column);
                    FilterLabel filterLabel = this.filterLabelSet.addLabel(formattedValue);
                    filterLabel.setOnRemoveCommand(() -> this.onFilterLabelRemoved(columnId, interval.getIndex()));
                }
            }
        }
    }

    public void sortBy(String column, SortOrder order) {
        if (this.displayerSettings.isTableSortEnabled()) {
            this.lastOrderedColumn = column;
            this.lastSortOrder = order;
            super.redraw();
        }
    }

    public void selectCell(String columnId, int rowIndex) {
        if (this.displayerSettings.isFilterEnabled()) {
            this.selectedCellColumn = columnId;
            this.selectedCellRow = rowIndex;
            for (Command cmd : this.onCellSelectedCommands) {
                cmd.execute();
            }
            if (this.displayerSettings.isFilterSelfApplyEnabled()) {
                this.view.gotoFirstPage();
            }
            super.filterUpdate(columnId, rowIndex);
            this.updateFilterStatus();
        }
    }

    public void filterReset(String columnId) {
        super.filterReset(columnId);
        if (this.selectedCellColumn != null && this.selectedCellColumn.equals(columnId)) {
            this.selectedCellColumn = null;
            this.selectedCellRow = null;
        }
    }

    public void filterReset() {
        this.selectedCellColumn = null;
        this.selectedCellRow = null;
        this.filterLabelSet.clear();
        super.filterReset();
    }

    public void lookupCurrentPage(final Callback<Integer> callback) {
        try {
            this.beforeDataSetLookup();
            this.dataSetHandler.lookupDataSet(new DataSetReadyCallback(){

                public void callback(DataSet ds) {
                    try {
                        TableDisplayer.this.dataSet = ds;
                        TableDisplayer.this.afterDataSetLookup(TableDisplayer.this.dataSet);
                        callback.callback((Object)TableDisplayer.this.dataSet.getRowCount());
                    }
                    catch (Exception e) {
                        TableDisplayer.this.showError(new ClientRuntimeError((Throwable)e));
                    }
                }

                public void notFound() {
                    TableDisplayer.this.view.errorDataSetNotFound(TableDisplayer.this.displayerSettings.getDataSetLookup().getDataSetUUID());
                }

                public boolean onError(ClientRuntimeError error) {
                    TableDisplayer.this.showError(error);
                    return false;
                }
            });
        }
        catch (Exception e) {
            this.showError(new ClientRuntimeError((Throwable)e));
        }
    }

    public void export(ExportFormat format) {
        super.export(format, this.exportRowNumMax, new ExportCallback(){

            public void noData() {
                TableDisplayer.this.view.exportNoData();
            }

            public void tooManyRows(int rowNum) {
                TableDisplayer.this.view.exportTooManyRows(rowNum, TableDisplayer.this.exportRowNumMax);
            }

            public void exportFileUrl(String url) {
                TableDisplayer.this.view.exportFileUrl(url);
            }

            public void error(ClientRuntimeError error) {
                TableDisplayer.this.view.error(error);
            }
        });
    }

    void onFilterLabelRemoved(String columnId, int row) {
        super.filterUpdate(columnId, row);
        if (!this.displayerSettings.isFilterSelfApplyEnabled()) {
            this.updateVisualization();
        }
    }

    void onFilterClearAll() {
        this.filterReset();
        if (!this.displayerSettings.isFilterSelfApplyEnabled()) {
            this.updateVisualization();
        }
    }

    public void onFilterEnabled(Displayer displayer, DataSetGroup groupOp) {
        this.view.gotoFirstPage();
        super.onFilterEnabled(displayer, groupOp);
    }

    public void onFilterEnabled(Displayer displayer, DataSetFilter filter) {
        this.view.gotoFirstPage();
        super.onFilterEnabled(displayer, filter);
    }

    public void onFilterReset(Displayer displayer, List<DataSetGroup> groupOps) {
        this.view.gotoFirstPage();
        super.onFilterReset(displayer, groupOps);
    }

    public void onFilterReset(Displayer displayer, DataSetFilter filter) {
        this.view.gotoFirstPage();
        super.onFilterReset(displayer, filter);
    }

    public static interface View
    extends AbstractGwtDisplayer.View<TableDisplayer> {
        public String getGroupsTitle();

        public String getColumnsTitle();

        public void showTitle(String var1);

        public void createTable(int var1, FilterLabelSet var2);

        public void redrawTable();

        public void setWidth(int var1);

        public void setSortEnabled(boolean var1);

        public void setTotalRows(int var1, boolean var2);

        public void setPagerEnabled(boolean var1);

        public void setColumnPickerEnabled(boolean var1);

        public void setExportToCsvEnabled(boolean var1);

        public void setExportToXlsEnabled(boolean var1);

        public void addColumn(ColumnType var1, String var2, String var3, int var4, boolean var5, boolean var6);

        public void gotoFirstPage();

        public int getLastOffset();

        public int getPageSize();

        public void exportNoData();

        public void exportTooManyRows(int var1, int var2);

        public void exportFileUrl(String var1);
    }
}

