/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.client.selector;

import com.google.gwt.event.dom.client.ClickEvent;
import javax.inject.Inject;
import org.dashbuilder.renderer.client.selector.SelectorDropDownItem;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.ListItem;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Templated
public class SelectorDropDownItemView
implements SelectorDropDownItem.View,
IsElement {
    @Inject
    @DataField
    ListItem item;
    @Inject
    @DataField
    Anchor itemAnchor;
    @Inject
    @DataField
    Span itemText;
    @Inject
    @DataField
    Span itemIcon;
    SelectorDropDownItem presenter;
    boolean iconVisible = true;

    public void init(SelectorDropDownItem presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setValue(String value) {
        this.itemText.setTextContent(value);
    }

    @Override
    public void setDescription(String description) {
        this.item.setTitle(description);
    }

    @Override
    public void select() {
        this.item.setClassName("selector-dditem selected");
        if (this.iconVisible) {
            this.itemIcon.getStyle().removeProperty("display");
        }
    }

    @Override
    public void reset() {
        this.item.setClassName("selector-dditem");
        this.itemIcon.getStyle().setProperty("display", "none");
    }

    @Override
    public void setSelectionIconVisible(boolean visible) {
        this.iconVisible = visible;
        if (!this.iconVisible) {
            this.itemIcon.getStyle().setProperty("display", "none");
        }
    }

    @EventHandler(value={"itemAnchor"})
    public void onItemClick(ClickEvent event) {
        this.presenter.onItemClick();
    }
}

