/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.client.selector;

import org.dashbuilder.renderer.client.selector.SelectorItemPresenter;
import org.uberfire.mvp.Command;

public abstract class AbstractSelectorItemPresenter
implements SelectorItemPresenter {
    protected Command onSelectCommand;
    protected Command onResetCommand;
    protected int id;
    protected boolean selected = false;

    @Override
    public void init(int id, String value, String descr) {
        this.id = id;
        this.getView().setValue(value);
        this.getView().setDescription(descr);
        this.reset();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setOnSelectCommand(Command onSelectCommand) {
        this.onSelectCommand = onSelectCommand;
    }

    @Override
    public void setOnResetCommand(Command onResetCommand) {
        this.onResetCommand = onResetCommand;
    }

    @Override
    public void select() {
        this.selected = true;
        this.getView().select();
    }

    @Override
    public void reset() {
        this.selected = false;
        this.getView().reset();
    }

    public void onItemClick() {
        if (this.selected) {
            this.selected = false;
            this.getView().reset();
            if (this.onResetCommand != null) {
                this.onResetCommand.execute();
            }
        } else {
            this.selected = true;
            this.getView().select();
            if (this.onSelectCommand != null) {
                this.onSelectCommand.execute();
            }
        }
    }
}

