/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.client.selector;

import java.util.Date;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.client.engine.ClientDateFormatter;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.client.AbstractDisplayer;
import org.dashbuilder.displayer.client.AbstractDisplayerTest;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.dashbuilder.displayer.client.widgets.filter.DateParameterEditor;
import org.dashbuilder.displayer.client.widgets.filter.NumberParameterEditor;
import org.dashbuilder.displayer.impl.SelectorDisplayerSettingsBuilderImpl;
import org.dashbuilder.renderer.client.selector.SelectorSliderDisplayer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class SelectorSliderDisplayerTest
extends AbstractDisplayerTest {
    @Mock
    ClientDateFormatter clientDateFormatter;
    @Mock
    DateParameterEditor minDateInputEditor;
    @Mock
    DateParameterEditor maxDateInputEditor;
    @Mock
    NumberParameterEditor minNumberInputEditor;
    @Mock
    NumberParameterEditor maxNumberInputEditor;
    DisplayerSettings dateSelectorSettings = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).column("CREATION_DATE")).width(200)).filterOn(false, true, false)).buildSettings();
    DisplayerSettings numberSelectorSettings = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).column("AMOUNT")).width(200)).filterOn(false, true, false)).buildSettings();

    public SelectorSliderDisplayer createSelectorDisplayer(DisplayerSettings settings) {
        return (SelectorSliderDisplayer)this.initDisplayer((AbstractDisplayer)new SelectorSliderDisplayer((SelectorSliderDisplayer.View)Mockito.mock(SelectorSliderDisplayer.View.class), this.minDateInputEditor, this.maxDateInputEditor, this.minNumberInputEditor, this.maxNumberInputEditor), settings);
    }

    @Test
    public void testDateSelector() {
        SelectorSliderDisplayer presenter = this.createSelectorDisplayer(this.dateSelectorSettings);
        SelectorSliderDisplayer.View view = presenter.getView();
        DisplayerListener listener = (DisplayerListener)Mockito.mock(DisplayerListener.class);
        presenter.addListener(new DisplayerListener[]{listener});
        presenter.draw();
        ((SelectorSliderDisplayer.View)Mockito.verify((Object)view)).showSlider(Mockito.anyDouble(), Mockito.anyDouble(), Mockito.anyDouble(), Mockito.anyDouble(), Mockito.anyDouble());
        ((SelectorSliderDisplayer.View)Mockito.verify((Object)view)).margins(Mockito.anyInt(), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyInt());
        ((SelectorSliderDisplayer.View)Mockito.verify((Object)view)).setWidth(Mockito.anyInt());
        presenter.onSliderChange(1.0, 6.0);
        Mockito.reset((Object[])new DisplayerListener[]{listener});
        presenter.onSliderChange(1.0, 6.0);
        ((DisplayerListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).onFilterUpdate((Displayer)Mockito.eq((Object)presenter), (DataSetFilter)Mockito.any(DataSetFilter.class), (DataSetFilter)Mockito.any(DataSetFilter.class));
    }

    @Test
    public void testNumberSelector() {
        SelectorSliderDisplayer presenter = this.createSelectorDisplayer(this.numberSelectorSettings);
        SelectorSliderDisplayer.View view = presenter.getView();
        DisplayerListener listener = (DisplayerListener)Mockito.mock(DisplayerListener.class);
        presenter.addListener(new DisplayerListener[]{listener});
        presenter.draw();
        ((SelectorSliderDisplayer.View)Mockito.verify((Object)view)).showSlider(1.0, 1101.0, 1.0, 1.0, 1101.0);
        ((SelectorSliderDisplayer.View)Mockito.verify((Object)view)).margins(Mockito.anyInt(), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyInt());
        ((SelectorSliderDisplayer.View)Mockito.verify((Object)view)).setWidth(Mockito.anyInt());
        presenter.onSliderChange(1.0, 6.0);
        Mockito.reset((Object[])new DisplayerListener[]{listener});
        presenter.onSliderChange(1.0, 6.0);
        ((DisplayerListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).onFilterUpdate((Displayer)Mockito.eq((Object)presenter), (DataSetFilter)Mockito.any(DataSetFilter.class), (DataSetFilter)Mockito.any(DataSetFilter.class));
    }

    @Test
    public void testNoData() {
        DisplayerSettings dateSelectorSettings = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).filter("CREATION_DATE", new ColumnFilter[]{FilterFactory.isNull()})).column("CREATION_DATE")).buildSettings();
        SelectorSliderDisplayer presenter = this.createSelectorDisplayer(dateSelectorSettings);
        SelectorSliderDisplayer.View view = presenter.getView();
        presenter.draw();
        ((SelectorSliderDisplayer.View)Mockito.verify((Object)view)).noData();
        ((SelectorSliderDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).showSlider((double)Mockito.anyInt(), (double)Mockito.anyInt(), (double)Mockito.anyInt(), (double)Mockito.anyInt(), (double)Mockito.anyInt());
    }

    @Test
    public void testSelectDisabled() {
        this.dateSelectorSettings.setFilterEnabled(false);
        SelectorSliderDisplayer presenter = this.createSelectorDisplayer(this.dateSelectorSettings);
        DisplayerListener listener = (DisplayerListener)Mockito.mock(DisplayerListener.class);
        SelectorSliderDisplayer.View view = presenter.getView();
        presenter.draw();
        Mockito.reset((Object[])new SelectorSliderDisplayer.View[]{view});
        presenter.addListener(new DisplayerListener[]{listener});
        presenter.onSliderChange(0.0, 1.0);
        ((DisplayerListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).onFilterEnabled((Displayer)Mockito.eq((Object)presenter), (DataSetFilter)Mockito.any(DataSetFilter.class));
        ((DisplayerListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).onRedraw((Displayer)presenter);
        ((SelectorSliderDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).showSlider((double)Mockito.anyInt(), (double)Mockito.anyInt(), (double)Mockito.anyInt(), (double)Mockito.anyInt(), (double)Mockito.anyInt());
    }

    @Test
    public void testDateRangeSelection() {
        SelectorSliderDisplayer presenter = this.createSelectorDisplayer(this.dateSelectorSettings);
        SelectorSliderDisplayer.View view = presenter.getView();
        DisplayerListener listener = (DisplayerListener)Mockito.mock(DisplayerListener.class);
        presenter.draw();
        Mockito.reset((Object[])new SelectorSliderDisplayer.View[]{view});
        presenter.addListener(new DisplayerListener[]{listener});
        presenter.onSliderChange(1.3280508E12, 1.3332312E12);
        ((SelectorSliderDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).showSlider((double)Mockito.anyInt(), (double)Mockito.anyInt(), (double)Mockito.anyInt(), (double)Mockito.anyInt(), (double)Mockito.anyInt());
        ArgumentCaptor argument = ArgumentCaptor.forClass(DataSetFilter.class);
        ((DisplayerListener)Mockito.verify((Object)listener)).onFilterUpdate((Displayer)Mockito.eq((Object)presenter), (DataSetFilter)Mockito.any(), (DataSetFilter)argument.capture());
        ((DisplayerListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).onRedraw((Displayer)presenter);
        DataSetFilter dataSetFilter = (DataSetFilter)argument.getValue();
        CoreFunctionFilter columnFilter = (CoreFunctionFilter)dataSetFilter.getColumnFilterList().get(0);
        Assert.assertEquals((Object)columnFilter.getColumnId(), (Object)"CREATION_DATE");
        Assert.assertEquals((Object)columnFilter.getType(), (Object)CoreFunctionType.BETWEEN);
        Assert.assertEquals((long)columnFilter.getParameters().size(), (long)2L);
        Assert.assertEquals(columnFilter.getParameters().get(0), (Object)new Date(1328050800000L));
        Assert.assertEquals(columnFilter.getParameters().get(1), (Object)new Date(1333231200000L));
        Mockito.reset((Object[])new DisplayerListener[]{listener});
        presenter.onSliderChange(1.3280508E12, 1.3358232E12);
        ((DisplayerListener)Mockito.verify((Object)listener)).onFilterUpdate((Displayer)Mockito.eq((Object)presenter), (DataSetFilter)Mockito.any(), (DataSetFilter)argument.capture());
        dataSetFilter = (DataSetFilter)argument.getValue();
        columnFilter = (CoreFunctionFilter)dataSetFilter.getColumnFilterList().get(0);
        Assert.assertEquals(columnFilter.getParameters().get(0), (Object)new Date(1328050800000L));
        Assert.assertEquals(columnFilter.getParameters().get(1), (Object)new Date(1335823200000L));
    }

    @Test
    public void testNumberRangeSelection() {
        SelectorSliderDisplayer presenter = this.createSelectorDisplayer(this.numberSelectorSettings);
        SelectorSliderDisplayer.View view = presenter.getView();
        DisplayerListener listener = (DisplayerListener)Mockito.mock(DisplayerListener.class);
        presenter.draw();
        Mockito.reset((Object[])new SelectorSliderDisplayer.View[]{view});
        presenter.addListener(new DisplayerListener[]{listener});
        presenter.onSliderChange(1.0, 101.0);
        ((SelectorSliderDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).showSlider((double)Mockito.anyInt(), (double)Mockito.anyInt(), (double)Mockito.anyInt(), (double)Mockito.anyInt(), (double)Mockito.anyInt());
        ArgumentCaptor argument = ArgumentCaptor.forClass(DataSetFilter.class);
        ((DisplayerListener)Mockito.verify((Object)listener)).onFilterUpdate((Displayer)Mockito.eq((Object)presenter), (DataSetFilter)Mockito.any(), (DataSetFilter)argument.capture());
        ((DisplayerListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).onRedraw((Displayer)presenter);
        DataSetFilter dataSetFilter = (DataSetFilter)argument.getValue();
        CoreFunctionFilter columnFilter = (CoreFunctionFilter)dataSetFilter.getColumnFilterList().get(0);
        Assert.assertEquals((Object)columnFilter.getColumnId(), (Object)"AMOUNT");
        Assert.assertEquals((Object)columnFilter.getType(), (Object)CoreFunctionType.BETWEEN);
        Assert.assertEquals((long)columnFilter.getParameters().size(), (long)2L);
        Assert.assertEquals(columnFilter.getParameters().get(0), (Object)1.0);
        Assert.assertEquals(columnFilter.getParameters().get(1), (Object)101.0);
        Mockito.reset((Object[])new DisplayerListener[]{listener});
        presenter.onSliderChange(51.0, 101.0);
        ((DisplayerListener)Mockito.verify((Object)listener)).onFilterUpdate((Displayer)Mockito.eq((Object)presenter), (DataSetFilter)Mockito.any(), (DataSetFilter)argument.capture());
        dataSetFilter = (DataSetFilter)argument.getValue();
        columnFilter = (CoreFunctionFilter)dataSetFilter.getColumnFilterList().get(0);
        Assert.assertEquals(columnFilter.getParameters().get(0), (Object)51.0);
        Assert.assertEquals(columnFilter.getParameters().get(1), (Object)101.0);
    }

    @Test
    public void testIgnoreNullDates() {
        this.expensesDataSet.setValueAt(0, 4, null);
        this.expensesDataSet.setValueAt(49, 4, null);
        SelectorSliderDisplayer presenter = this.createSelectorDisplayer(this.dateSelectorSettings);
        presenter.draw();
        DataSet dataSet = presenter.getDataSetHandler().getLastDataSet();
        Object min = dataSet.getValueAt(0, 0);
        Object max = dataSet.getValueAt(0, 1);
        Assert.assertEquals((Object)min, (Object)this.expensesDataSet.getValueAt(48, 4));
        Assert.assertEquals((Object)max, (Object)this.expensesDataSet.getValueAt(1, 4));
    }

    @Test
    public void testIgnoreNullNumbers() {
        this.expensesDataSet.setValueAt(0, 5, null);
        SelectorSliderDisplayer presenter = this.createSelectorDisplayer(this.numberSelectorSettings);
        presenter.draw();
        DataSet dataSet = presenter.getDataSetHandler().getLastDataSet();
        Object min = dataSet.getValueAt(0, 0);
        Object max = dataSet.getValueAt(0, 1);
        Assert.assertEquals((Object)min, (Object)1.1);
        Assert.assertEquals((Object)max, (Object)1100.1);
    }

    @Test
    public void testDateAllNullNoData() {
        for (int i = 0; i < 50; ++i) {
            this.expensesDataSet.setValueAt(i, 4, null);
        }
        SelectorSliderDisplayer presenter = this.createSelectorDisplayer(this.dateSelectorSettings);
        presenter.draw();
        ((SelectorSliderDisplayer.View)Mockito.verify((Object)presenter.getView())).noData();
    }

    @Test
    public void testNumberAllNullNoData() {
        for (int i = 0; i < 50; ++i) {
            this.expensesDataSet.setValueAt(i, 5, null);
        }
        SelectorSliderDisplayer presenter = this.createSelectorDisplayer(this.numberSelectorSettings);
        presenter.draw();
        ((SelectorSliderDisplayer.View)Mockito.verify((Object)presenter.getView())).noData();
    }
}

