/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.client.selector;

import java.lang.annotation.Annotation;
import java.util.List;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.client.AbstractDisplayer;
import org.dashbuilder.displayer.client.AbstractDisplayerTest;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.dashbuilder.displayer.impl.SelectorDisplayerSettingsBuilderImpl;
import org.dashbuilder.renderer.client.selector.SelectorLabelItem;
import org.dashbuilder.renderer.client.selector.SelectorLabelSetDisplayer;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class SelectorLabelSetDisplayerTest
extends AbstractDisplayerTest {
    @Mock
    SyncBeanManager beanManager;
    @Mock
    SyncBeanDef<SelectorLabelItem> labelItemBean;
    @Mock
    SelectorLabelItem labelItem;

    public SelectorLabelSetDisplayer createSelectorDisplayer(DisplayerSettings settings) {
        return (SelectorLabelSetDisplayer)this.initDisplayer((AbstractDisplayer)new SelectorLabelSetDisplayer((SelectorLabelSetDisplayer.View)Mockito.mock(SelectorLabelSetDisplayer.View.class), this.beanManager), settings);
    }

    @Before
    public void setUp() {
        Mockito.when((Object)this.beanManager.lookupBean(SelectorLabelItem.class, new Annotation[0])).thenReturn(this.labelItemBean);
        Mockito.when((Object)this.labelItemBean.newInstance()).thenReturn((Object)this.labelItem);
    }

    @Test
    public void testDraw() {
        DisplayerSettings departmentList = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).group("DEPARTMENT")).column("DEPARTMENT")).column("EXPENSES_ID", AggregateFunctionType.COUNT)).filterOn(false, true, false)).buildSettings();
        SelectorLabelSetDisplayer presenter = this.createSelectorDisplayer(departmentList);
        SelectorLabelSetDisplayer.View view = presenter.getView();
        presenter.draw();
        ((SelectorLabelSetDisplayer.View)Mockito.verify((Object)view)).clearItems();
        ((SelectorLabelSetDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.times((int)5))).addItem((SelectorLabelItem)Mockito.any());
        DataSet dataSet = presenter.getDataSetHandler().getLastDataSet();
        Assert.assertEquals((Object)dataSet.getValueAt(0, 0), (Object)"Engineering");
        Assert.assertEquals((Object)dataSet.getValueAt(4, 0), (Object)"Support");
    }

    @Test
    public void testNoData() {
        DisplayerSettings departmentList = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).filter("EXPENSES_ID", new ColumnFilter[]{FilterFactory.isNull()})).group("DEPARTMENT")).column("DEPARTMENT")).column("EXPENSES_ID", AggregateFunctionType.COUNT)).buildSettings();
        SelectorLabelSetDisplayer presenter = this.createSelectorDisplayer(departmentList);
        SelectorLabelSetDisplayer.View view = presenter.getView();
        presenter.draw();
        ((SelectorLabelSetDisplayer.View)Mockito.verify((Object)view)).clearItems();
        ((SelectorLabelSetDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).addItem((SelectorLabelItem)Mockito.any());
    }

    @Test
    public void testNullNotShown() {
        DisplayerSettings departmentList = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).group("DEPARTMENT")).column("DEPARTMENT")).column("EXPENSES_ID", AggregateFunctionType.COUNT)).buildSettings();
        DataSet expensesDataSet = this.clientDataSetManager.getDataSet("expenses");
        int column = expensesDataSet.getColumnIndex(expensesDataSet.getColumnById("DEPARTMENT"));
        expensesDataSet.setValueAt(0, column, null);
        SelectorLabelSetDisplayer presenter = this.createSelectorDisplayer(departmentList);
        SelectorLabelSetDisplayer.View view = presenter.getView();
        presenter.draw();
        ((SelectorLabelSetDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.times((int)5))).addItem((SelectorLabelItem)Mockito.any());
        ((SelectorLabelSetDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).addItem(null);
    }

    @Test
    public void testSelectDisabled() {
        DisplayerSettings departmentList = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).group("DEPARTMENT")).column("DEPARTMENT")).column("EXPENSES_ID", AggregateFunctionType.COUNT)).filterOff(true)).buildSettings();
        SelectorLabelSetDisplayer presenter = this.createSelectorDisplayer(departmentList);
        DisplayerListener listener = (DisplayerListener)Mockito.mock(DisplayerListener.class);
        SelectorLabelSetDisplayer.View view = presenter.getView();
        presenter.draw();
        Mockito.reset((Object[])new SelectorLabelSetDisplayer.View[]{view});
        presenter.addListener(new DisplayerListener[]{listener});
        presenter.onItemSelected(this.labelItem);
        ((DisplayerListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).onFilterEnabled((Displayer)Mockito.eq((Object)presenter), (DataSetGroup)Mockito.any(DataSetGroup.class));
        ((DisplayerListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).onRedraw((Displayer)presenter);
        ((SelectorLabelSetDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).clearItems();
        ((SelectorLabelSetDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).addItem((SelectorLabelItem)Mockito.any());
    }

    @Test
    public void testSelectItem() {
        DisplayerSettings departmentList = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).group("DEPARTMENT")).column("DEPARTMENT")).column("EXPENSES_ID", AggregateFunctionType.COUNT)).filterOn(false, true, true)).buildSettings();
        SelectorLabelSetDisplayer presenter = this.createSelectorDisplayer(departmentList);
        SelectorLabelSetDisplayer.View view = presenter.getView();
        DisplayerListener listener = (DisplayerListener)Mockito.mock(DisplayerListener.class);
        presenter.draw();
        Mockito.reset((Object[])new SelectorLabelSetDisplayer.View[]{view});
        Mockito.when((Object)this.labelItem.getId()).thenReturn((Object)1);
        presenter.addListener(new DisplayerListener[]{listener});
        presenter.onItemSelected(this.labelItem);
        ((SelectorLabelSetDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).clearItems();
        ((SelectorLabelSetDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).addItem((SelectorLabelItem)Mockito.any());
        ArgumentCaptor argument = ArgumentCaptor.forClass(DataSetGroup.class);
        ((DisplayerListener)Mockito.verify((Object)listener)).onFilterEnabled((Displayer)Mockito.eq((Object)presenter), (DataSetGroup)argument.capture());
        ((DisplayerListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).onRedraw((Displayer)presenter);
        DataSetGroup dataSetGroup = (DataSetGroup)argument.getValue();
        List selectedIntervals = dataSetGroup.getSelectedIntervalList();
        Assert.assertEquals((long)selectedIntervals.size(), (long)1L);
        Interval selectedInterval = (Interval)selectedIntervals.get(0);
        Assert.assertEquals((Object)selectedInterval.getName(), (Object)"Management");
    }

    @Test
    public void testMultipleSelect() {
        DisplayerSettings departmentList = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).group("DEPARTMENT")).column("DEPARTMENT")).column("EXPENSES_ID", AggregateFunctionType.COUNT)).filterOn(false, true, true)).multiple(true)).buildSettings();
        SelectorLabelSetDisplayer presenter = this.createSelectorDisplayer(departmentList);
        SelectorLabelSetDisplayer.View view = presenter.getView();
        DisplayerListener listener = (DisplayerListener)Mockito.mock(DisplayerListener.class);
        presenter.draw();
        Mockito.reset((Object[])new SelectorLabelSetDisplayer.View[]{view});
        presenter.addListener(new DisplayerListener[]{listener});
        Mockito.when((Object)this.labelItem.getId()).thenReturn((Object)1);
        presenter.onItemSelected(this.labelItem);
        Mockito.when((Object)this.labelItem.getId()).thenReturn((Object)2);
        presenter.onItemSelected(this.labelItem);
        ((SelectorLabelSetDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).clearItems();
        ((SelectorLabelSetDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).addItem((SelectorLabelItem)Mockito.any());
        ArgumentCaptor argument = ArgumentCaptor.forClass(DataSetGroup.class);
        ((DisplayerListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)2))).onFilterEnabled((Displayer)Mockito.eq((Object)presenter), (DataSetGroup)argument.capture());
        ((DisplayerListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).onRedraw((Displayer)presenter);
        DataSetGroup dataSetGroup = (DataSetGroup)argument.getValue();
        List selectedIntervals = dataSetGroup.getSelectedIntervalList();
        Assert.assertEquals((long)selectedIntervals.size(), (long)2L);
        Interval selectedInterval1 = (Interval)selectedIntervals.get(0);
        Interval selectedInterval2 = (Interval)selectedIntervals.get(1);
        Assert.assertEquals((Object)selectedInterval1.getName(), (Object)"Management");
        Assert.assertEquals((Object)selectedInterval2.getName(), (Object)"Sales");
    }

    @Test
    public void testDrillDown() {
        DisplayerSettings departmentList = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).group("DEPARTMENT")).column("DEPARTMENT")).column("EXPENSES_ID", AggregateFunctionType.COUNT)).filterOn(true, true, true)).buildSettings();
        SelectorLabelSetDisplayer presenter = this.createSelectorDisplayer(departmentList);
        SelectorLabelSetDisplayer.View view = presenter.getView();
        DisplayerListener listener = (DisplayerListener)Mockito.mock(DisplayerListener.class);
        presenter.draw();
        Mockito.reset((Object[])new SelectorLabelSetDisplayer.View[]{view});
        Mockito.when((Object)this.labelItem.getId()).thenReturn((Object)1);
        presenter.addListener(new DisplayerListener[]{listener});
        presenter.onItemSelected(this.labelItem);
        ((DisplayerListener)Mockito.verify((Object)listener)).onFilterEnabled((Displayer)Mockito.eq((Object)presenter), (DataSetGroup)Mockito.any(DataSetGroup.class));
        ((DisplayerListener)Mockito.verify((Object)listener)).onRedraw((Displayer)presenter);
        ((SelectorLabelSetDisplayer.View)Mockito.verify((Object)view)).clearItems();
        ((SelectorLabelSetDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.times((int)1))).addItem((SelectorLabelItem)Mockito.any());
    }

    @Test
    public void testNullEntries() {
        DataSet expensesDataSet = this.clientDataSetManager.getDataSet("expenses");
        int column = expensesDataSet.getColumnIndex(expensesDataSet.getColumnById("DEPARTMENT"));
        expensesDataSet.setValueAt(0, column, null);
        DisplayerSettings departmentList = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).group("DEPARTMENT")).column("DEPARTMENT")).column("EXPENSES_ID", AggregateFunctionType.COUNT)).filterOn(false, true, true)).buildSettings();
        SelectorLabelSetDisplayer presenter = this.createSelectorDisplayer(departmentList);
        SelectorLabelSetDisplayer.View view = presenter.getView();
        DisplayerListener listener = (DisplayerListener)Mockito.mock(DisplayerListener.class);
        presenter.addListener(new DisplayerListener[]{listener});
        presenter.draw();
        ((SelectorLabelSetDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.times((int)5))).addItem((SelectorLabelItem)Mockito.any());
        ((SelectorLabelSetDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).addItem(null);
        Mockito.reset((Object[])new DisplayerListener[]{listener});
        Mockito.when((Object)this.labelItem.getId()).thenReturn((Object)1);
        presenter.onItemSelected(this.labelItem);
        ArgumentCaptor argument = ArgumentCaptor.forClass(DataSetGroup.class);
        ((DisplayerListener)Mockito.verify((Object)listener)).onFilterEnabled((Displayer)Mockito.eq((Object)presenter), (DataSetGroup)argument.capture());
        DataSetGroup dataSetGroup = (DataSetGroup)argument.getValue();
        Interval selectedInterval = (Interval)dataSetGroup.getSelectedIntervalList().get(0);
        Assert.assertEquals((Object)selectedInterval.getName(), (Object)"Engineering");
    }
}

