/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.client.selector;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.client.AbstractDisplayer;
import org.dashbuilder.displayer.client.AbstractDisplayerTest;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.dashbuilder.displayer.impl.SelectorDisplayerSettingsBuilderImpl;
import org.dashbuilder.renderer.client.selector.SelectorDropDownDisplayer;
import org.dashbuilder.renderer.client.selector.SelectorDropDownItem;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class SelectorDropDownDisplayerTest
extends AbstractDisplayerTest {
    @Mock
    SyncBeanManager beanManager;
    @Mock
    SyncBeanDef<SelectorDropDownItem> dropDownItemBean;
    @Mock
    SelectorDropDownItem dropDownItem;

    public SelectorDropDownDisplayer createSelectorDisplayer(DisplayerSettings settings) {
        return (SelectorDropDownDisplayer)this.initDisplayer((AbstractDisplayer)new SelectorDropDownDisplayer((SelectorDropDownDisplayer.View)Mockito.mock(SelectorDropDownDisplayer.View.class), this.beanManager), settings);
    }

    @Before
    public void setUp() {
        Mockito.when((Object)this.beanManager.lookupBean(SelectorDropDownItem.class, new Annotation[0])).thenReturn(this.dropDownItemBean);
        Mockito.when((Object)this.dropDownItemBean.newInstance()).thenReturn((Object)this.dropDownItem);
    }

    @Test
    public void testDraw() {
        DisplayerSettings departmentList = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).group("DEPARTMENT")).column("DEPARTMENT")).column("EXPENSES_ID", AggregateFunctionType.COUNT)).filterOn(false, true, false)).multiple(false)).buildSettings();
        SelectorDropDownDisplayer presenter = this.createSelectorDisplayer(departmentList);
        SelectorDropDownDisplayer.View view = presenter.getView();
        presenter.draw();
        ((SelectorDropDownDisplayer.View)Mockito.verify((Object)view)).clearItems();
        ((SelectorDropDownDisplayer.View)Mockito.verify((Object)view)).showSelectHint("DEPARTMENT", false);
        ((SelectorDropDownDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.times((int)5))).addItem((SelectorDropDownItem)Mockito.any());
        ((SelectorDropDownDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).showResetHint(Mockito.anyString(), Mockito.anyBoolean());
        DataSet dataSet = presenter.getDataSetHandler().getLastDataSet();
        Assert.assertEquals((Object)dataSet.getValueAt(0, 0), (Object)"Engineering");
        Assert.assertEquals((Object)dataSet.getValueAt(4, 0), (Object)"Support");
    }

    @Test
    public void testNoData() {
        DisplayerSettings departmentList = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).filter("EXPENSES_ID", new ColumnFilter[]{FilterFactory.isNull()})).group("DEPARTMENT")).column("DEPARTMENT")).column("EXPENSES_ID", AggregateFunctionType.COUNT)).multiple(false)).buildSettings();
        SelectorDropDownDisplayer presenter = this.createSelectorDisplayer(departmentList);
        SelectorDropDownDisplayer.View view = presenter.getView();
        presenter.draw();
        ((SelectorDropDownDisplayer.View)Mockito.verify((Object)view)).clearItems();
        ((SelectorDropDownDisplayer.View)Mockito.verify((Object)view)).showSelectHint("DEPARTMENT", false);
        ((SelectorDropDownDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).addItem((SelectorDropDownItem)Mockito.any());
    }

    @Test
    public void testNullNotShown() {
        DisplayerSettings departmentList = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).group("DEPARTMENT")).column("DEPARTMENT")).column("EXPENSES_ID", AggregateFunctionType.COUNT)).buildSettings();
        DataSet expensesDataSet = this.clientDataSetManager.getDataSet("expenses");
        int column = expensesDataSet.getColumnIndex(expensesDataSet.getColumnById("DEPARTMENT"));
        expensesDataSet.setValueAt(0, column, null);
        SelectorDropDownDisplayer presenter = this.createSelectorDisplayer(departmentList);
        SelectorDropDownDisplayer.View view = presenter.getView();
        presenter.draw();
        ((SelectorDropDownDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.times((int)5))).addItem((SelectorDropDownItem)Mockito.any());
        ((SelectorDropDownDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).addItem(null);
    }

    @Test
    public void testSelectDisabled() {
        DisplayerSettings departmentList = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).group("DEPARTMENT")).column("DEPARTMENT")).column("EXPENSES_ID", AggregateFunctionType.COUNT)).filterOff(true)).buildSettings();
        SelectorDropDownDisplayer presenter = this.createSelectorDisplayer(departmentList);
        DisplayerListener listener = (DisplayerListener)Mockito.mock(DisplayerListener.class);
        SelectorDropDownDisplayer.View view = presenter.getView();
        presenter.draw();
        Mockito.reset((Object[])new SelectorDropDownDisplayer.View[]{view});
        presenter.addListener(new DisplayerListener[]{listener});
        presenter.onItemSelected(this.dropDownItem);
        ((DisplayerListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).onFilterEnabled((Displayer)Mockito.eq((Object)presenter), (DataSetGroup)Mockito.any(DataSetGroup.class));
        ((DisplayerListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).onRedraw((Displayer)presenter);
        ((SelectorDropDownDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).showResetHint("DEPARTMENT", true);
        ((SelectorDropDownDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).clearItems();
        ((SelectorDropDownDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).showSelectHint("DEPARTMENT", true);
        ((SelectorDropDownDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).addItem((SelectorDropDownItem)Mockito.any());
    }

    @Test
    public void testSelectItem() {
        DisplayerSettings departmentList = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).group("DEPARTMENT")).column("DEPARTMENT")).column("EXPENSES_ID", AggregateFunctionType.COUNT)).filterOn(false, true, true)).multiple(false)).buildSettings();
        SelectorDropDownDisplayer presenter = this.createSelectorDisplayer(departmentList);
        SelectorDropDownDisplayer.View view = presenter.getView();
        DisplayerListener listener = (DisplayerListener)Mockito.mock(DisplayerListener.class);
        presenter.draw();
        Mockito.reset((Object[])new SelectorDropDownDisplayer.View[]{view});
        Mockito.when((Object)this.dropDownItem.getId()).thenReturn((Object)1);
        presenter.addListener(new DisplayerListener[]{listener});
        presenter.onItemSelected(this.dropDownItem);
        ((SelectorDropDownDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).clearItems();
        ((SelectorDropDownDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).addItem((SelectorDropDownItem)Mockito.any());
        ArgumentCaptor argument = ArgumentCaptor.forClass(DataSetGroup.class);
        ((SelectorDropDownDisplayer.View)Mockito.verify((Object)view)).showResetHint("DEPARTMENT", false);
        ((SelectorDropDownDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).showSelectHint("DEPARTMENT", false);
        ((DisplayerListener)Mockito.verify((Object)listener)).onFilterEnabled((Displayer)Mockito.eq((Object)presenter), (DataSetGroup)argument.capture());
        ((DisplayerListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).onRedraw((Displayer)presenter);
        DataSetGroup dataSetGroup = (DataSetGroup)argument.getValue();
        List selectedIntervals = dataSetGroup.getSelectedIntervalList();
        Assert.assertEquals((long)selectedIntervals.size(), (long)1L);
        Interval selectedInterval = (Interval)selectedIntervals.get(0);
        Assert.assertEquals((Object)selectedInterval.getName(), (Object)"Management");
    }

    @Test
    public void testMultipleSelect() {
        DisplayerSettings departmentList = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).group("DEPARTMENT")).column("DEPARTMENT")).column("EXPENSES_ID", AggregateFunctionType.COUNT)).filterOn(false, true, true)).multiple(true)).width(100)).buildSettings();
        SelectorDropDownDisplayer presenter = this.createSelectorDisplayer(departmentList);
        SelectorDropDownDisplayer.View view = presenter.getView();
        DisplayerListener listener = (DisplayerListener)Mockito.mock(DisplayerListener.class);
        presenter.draw();
        presenter.addListener(new DisplayerListener[]{listener});
        Mockito.when((Object)this.dropDownItem.getId()).thenReturn((Object)1);
        presenter.onItemSelected(this.dropDownItem);
        Mockito.reset((Object[])new SelectorDropDownDisplayer.View[]{view});
        Mockito.reset((Object[])new DisplayerListener[]{listener});
        Mockito.when((Object)this.dropDownItem.getId()).thenReturn((Object)2);
        presenter.onItemSelected(this.dropDownItem);
        ((SelectorDropDownDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).clearItems();
        ((SelectorDropDownDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).addItem((SelectorDropDownItem)Mockito.any());
        ArgumentCaptor argument = ArgumentCaptor.forClass(DataSetGroup.class);
        ((SelectorDropDownDisplayer.View)Mockito.verify((Object)view)).showResetHint("DEPARTMENT", true);
        ((SelectorDropDownDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).showSelectHint("DEPARTMENT", true);
        ((SelectorDropDownDisplayer.View)Mockito.verify((Object)view)).showCurrentSelection("Management ...", "Management, Sales ");
        ((DisplayerListener)Mockito.verify((Object)listener)).onFilterEnabled((Displayer)Mockito.eq((Object)presenter), (DataSetGroup)argument.capture());
        ((DisplayerListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).onRedraw((Displayer)presenter);
        DataSetGroup dataSetGroup = (DataSetGroup)argument.getValue();
        List selectedIntervals = dataSetGroup.getSelectedIntervalList();
        Assert.assertEquals((long)selectedIntervals.size(), (long)2L);
        Interval selectedInterval1 = (Interval)selectedIntervals.get(0);
        Interval selectedInterval2 = (Interval)selectedIntervals.get(1);
        Assert.assertEquals((Object)selectedInterval1.getName(), (Object)"Management");
        Assert.assertEquals((Object)selectedInterval2.getName(), (Object)"Sales");
    }

    @Test
    public void testFormatItemList() {
        DisplayerSettings departmentList = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).group("DEPARTMENT")).column("DEPARTMENT")).column("EXPENSES_ID", AggregateFunctionType.COUNT)).filterOn(false, true, true)).multiple(true)).width(90)).buildSettings();
        SelectorDropDownDisplayer presenter = this.createSelectorDisplayer(departmentList);
        String result = presenter.formatItemList(Arrays.asList("Sales", "Management", "IT"), 200);
        Assert.assertEquals((Object)result, (Object)"Sales, Management, IT ");
        result = presenter.formatItemList(Arrays.asList("Sales", "Management", "IT"));
        Assert.assertEquals((Object)result, (Object)"Sales, Management, IT ");
        result = presenter.formatItemList(Arrays.asList("Sales", "Management", "IT"), 150);
        Assert.assertEquals((Object)result, (Object)"Sales, Managemen...");
        result = presenter.formatItemList(Arrays.asList("Sales", "Management", "IT"), 130);
        Assert.assertEquals((Object)result, (Object)"Sales, Managem...");
        result = presenter.formatItemList(Arrays.asList("Sales", "Management", "IT"), 60);
        Assert.assertEquals((Object)result, (Object)"Sales ...");
        result = presenter.formatItemList(Arrays.asList("Sales", "Management", "IT"), 10);
        Assert.assertEquals((Object)result, (Object)"S...");
    }

    @Test
    public void testDrillDown() {
        DisplayerSettings departmentList = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).group("DEPARTMENT")).column("DEPARTMENT")).column("EXPENSES_ID", AggregateFunctionType.COUNT)).filterOn(true, true, true)).multiple(false)).buildSettings();
        SelectorDropDownDisplayer presenter = this.createSelectorDisplayer(departmentList);
        SelectorDropDownDisplayer.View view = presenter.getView();
        DisplayerListener listener = (DisplayerListener)Mockito.mock(DisplayerListener.class);
        presenter.draw();
        Mockito.reset((Object[])new SelectorDropDownDisplayer.View[]{view});
        Mockito.when((Object)this.dropDownItem.getId()).thenReturn((Object)1);
        presenter.addListener(new DisplayerListener[]{listener});
        presenter.onItemSelected(this.dropDownItem);
        ((DisplayerListener)Mockito.verify((Object)listener)).onFilterEnabled((Displayer)Mockito.eq((Object)presenter), (DataSetGroup)Mockito.any(DataSetGroup.class));
        ((DisplayerListener)Mockito.verify((Object)listener)).onRedraw((Displayer)presenter);
        ((SelectorDropDownDisplayer.View)Mockito.verify((Object)view)).clearItems();
        ((SelectorDropDownDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.atLeastOnce())).showResetHint("DEPARTMENT", false);
        ((SelectorDropDownDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).showSelectHint("DEPARTMENT", false);
        ((SelectorDropDownDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.times((int)1))).addItem((SelectorDropDownItem)Mockito.any());
    }

    @Test
    public void testNullEntries() {
        DataSet expensesDataSet = this.clientDataSetManager.getDataSet("expenses");
        int column = expensesDataSet.getColumnIndex(expensesDataSet.getColumnById("DEPARTMENT"));
        expensesDataSet.setValueAt(0, column, null);
        DisplayerSettings departmentList = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().dataset("expenses")).group("DEPARTMENT")).column("DEPARTMENT")).column("EXPENSES_ID", AggregateFunctionType.COUNT)).filterOn(false, true, true)).buildSettings();
        SelectorDropDownDisplayer presenter = this.createSelectorDisplayer(departmentList);
        SelectorDropDownDisplayer.View view = presenter.getView();
        DisplayerListener listener = (DisplayerListener)Mockito.mock(DisplayerListener.class);
        presenter.addListener(new DisplayerListener[]{listener});
        presenter.draw();
        ((SelectorDropDownDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.times((int)5))).addItem((SelectorDropDownItem)Mockito.any());
        ((SelectorDropDownDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).addItem(null);
        Mockito.reset((Object[])new DisplayerListener[]{listener});
        Mockito.when((Object)this.dropDownItem.getId()).thenReturn((Object)1);
        presenter.onItemSelected(this.dropDownItem);
        ArgumentCaptor argument = ArgumentCaptor.forClass(DataSetGroup.class);
        ((DisplayerListener)Mockito.verify((Object)listener)).onFilterEnabled((Displayer)Mockito.eq((Object)presenter), (DataSetGroup)argument.capture());
        DataSetGroup dataSetGroup = (DataSetGroup)argument.getValue();
        Interval selectedInterval = (Interval)dataSetGroup.getSelectedIntervalList().get(0);
        Assert.assertEquals((Object)selectedInterval.getName(), (Object)"Engineering");
    }
}

