/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.client.metric;

import org.dashbuilder.common.client.StringUtils;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.client.AbstractDisplayer;
import org.dashbuilder.displayer.client.AbstractDisplayerTest;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.dashbuilder.displayer.impl.MetricSettingsBuilderImpl;
import org.dashbuilder.renderer.client.metric.MetricDisplayer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class MetricDisplayerTest
extends AbstractDisplayerTest {
    public static final String HTML_TEMPLATE = "<div id=\"${this}\" style=\"background-color:${bgColor}; width:${width}px; height:${height}px; margin-top:${marginTop}px; margin-right:${marginRight}px; margin-bottom:${marginBottom}px; margin-left:${marginLeft}px;\">\n  <span>${title}</span>\n  <span>${value}</span>\n</div>";
    @Mock
    MetricDisplayer.View view;
    @Mock
    DisplayerListener listener;

    public MetricDisplayer createMetricDisplayer(DisplayerSettings settings) {
        MetricDisplayer displayer = (MetricDisplayer)this.initDisplayer((AbstractDisplayer)new MetricDisplayer(this.view), settings);
        displayer.addListener(new DisplayerListener[]{this.listener});
        return displayer;
    }

    @Before
    public void setUp() {
        Mockito.when((Object)this.view.getUniqueId()).thenReturn((Object)"test");
    }

    @Test
    public void testDraw() {
        DisplayerSettings engExpenses = ((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)DisplayerSettingsFactory.newMetricSettings().dataset("expenses")).filter("DEPARTMENT", new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"Engineering"))})).column("AMOUNT", AggregateFunctionType.SUM)).title("Title")).titleVisible(true)).width(300)).height(200)).margins(10, 20, 30, 40)).backgroundColor("FDE8D4")).filterOff(true)).htmlTemplate(HTML_TEMPLATE)).jsTemplate("alert('${value.raw}');")).buildSettings();
        MetricDisplayer presenter = this.createMetricDisplayer(engExpenses);
        presenter.draw();
        ((MetricDisplayer.View)Mockito.verify((Object)this.view)).setHtml("<div id=\"test_this\" style=\"background-color:#FDE8D4; width:300px; height:200px; margin-top:10px; margin-right:40px; margin-bottom:20px; margin-left:30px;\">\n  <span>Title</span>\n  <span>7,650.16</span>\n</div>");
        ((MetricDisplayer.View)Mockito.verify((Object)this.view)).eval("alert('7650.16');");
    }

    @Test
    public void testDefaultTemplates() {
        DisplayerSettings engExpenses = ((MetricSettingsBuilderImpl)DisplayerSettingsFactory.newMetricSettings().dataset("expenses")).buildSettings();
        MetricDisplayer presenter = this.createMetricDisplayer(engExpenses);
        String html = presenter.getHtmlTemplate();
        String js = presenter.getJsTemplate();
        Assert.assertFalse((boolean)StringUtils.isBlank((String)html));
        Assert.assertFalse((boolean)StringUtils.isBlank((String)js));
        Assert.assertFalse((boolean)html.equals(js));
    }

    @Test
    public void testNoData() {
        DisplayerSettings empty = ((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)DisplayerSettingsFactory.newMetricSettings().dataset("expenses")).filter("EXPENSES_ID", new ColumnFilter[]{FilterFactory.isNull()})).column("AMOUNT")).title("Title")).titleVisible(true)).width(300)).height(200)).margins(10, 20, 30, 40)).backgroundColor("FDE8D4")).htmlTemplate(HTML_TEMPLATE)).buildSettings();
        Mockito.when((Object)this.view.getNoDataString()).thenReturn((Object)"0,0");
        MetricDisplayer presenter = this.createMetricDisplayer(empty);
        MetricDisplayer.View view = presenter.getView();
        presenter.draw();
        ((MetricDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.atLeastOnce())).getNoDataString();
        ((MetricDisplayer.View)Mockito.verify((Object)view)).setHtml("<div id=\"test_this\" style=\"background-color:#FDE8D4; width:300px; height:200px; margin-top:10px; margin-right:40px; margin-bottom:20px; margin-left:30px;\">\n  <span>Title</span>\n  <span>0,0</span>\n</div>");
    }

    @Test
    public void testNoFilter() {
        DisplayerSettings empty = ((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)DisplayerSettingsFactory.newMetricSettings().dataset("expenses")).column("AMOUNT")).filterOn(false, true, true)).buildSettings();
        MetricDisplayer presenter = this.createMetricDisplayer(empty);
        MetricDisplayer.View view = presenter.getView();
        presenter.draw();
        Mockito.reset((Object[])new MetricDisplayer.View[]{view});
        Mockito.reset((Object[])new DisplayerListener[]{this.listener});
        presenter.filterApply();
        ((DisplayerListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onFilterEnabled((Displayer)Mockito.eq((Object)presenter), (DataSetFilter)Mockito.any(DataSetFilter.class));
    }

    @Test
    public void testSwitchOnFilter() {
        DisplayerSettings empty = ((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)DisplayerSettingsFactory.newMetricSettings().dataset("expenses")).filter("EXPENSES_ID", new ColumnFilter[]{FilterFactory.isNull()})).column("AMOUNT")).filterOn(false, true, true)).buildSettings();
        MetricDisplayer presenter = this.createMetricDisplayer(empty);
        MetricDisplayer.View view = presenter.getView();
        presenter.draw();
        Mockito.reset((Object[])new MetricDisplayer.View[]{view});
        Mockito.reset((Object[])new DisplayerListener[]{this.listener});
        presenter.updateFilter();
        ((DisplayerListener)Mockito.verify((Object)this.listener)).onFilterEnabled((Displayer)Mockito.eq((Object)presenter), (DataSetFilter)Mockito.any(DataSetFilter.class));
    }

    @Test
    public void testSwitchOffFilter() {
        DisplayerSettings empty = ((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)DisplayerSettingsFactory.newMetricSettings().dataset("expenses")).filter("EXPENSES_ID", new ColumnFilter[]{FilterFactory.isNull()})).column("AMOUNT")).filterOn(false, true, true)).buildSettings();
        MetricDisplayer presenter = this.createMetricDisplayer(empty);
        MetricDisplayer.View view = presenter.getView();
        presenter.draw();
        presenter.filterApply();
        Mockito.reset((Object[])new MetricDisplayer.View[]{view});
        Mockito.reset((Object[])new DisplayerListener[]{this.listener});
        presenter.filterReset();
        ((DisplayerListener)Mockito.verify((Object)this.listener)).onFilterReset((Displayer)Mockito.eq((Object)presenter), (DataSetFilter)Mockito.any(DataSetFilter.class));
    }
}

