/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.client.table;

import com.github.gwtbootstrap.client.ui.Label;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dashbuilder.common.client.StringUtils;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.displayer.ColumnSettings;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.displayer.client.AbstractDisplayer;
import org.dashbuilder.renderer.client.resources.i18n.CommonConstants;
import org.dashbuilder.renderer.client.resources.i18n.TableConstants;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;

public class TableDisplayer
extends AbstractDisplayer {
    protected Widget currentSelectionWidget = null;
    protected int numberOfRows = 0;
    protected String lastOrderedColumn = null;
    protected SortOrder lastSortOrder = null;
    protected PagedTable<Integer> table;
    protected TableProvider tableProvider = new TableProvider();

    public DisplayerConstraints createDisplayerConstraints() {
        DataSetLookupConstraints lookupConstraints = ((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupAllowed(true).setGroupRequired(false).setMaxColumns(-1)).setMinColumns(1)).setExtraColumnsAllowed(true)).setGroupsTitle(TableConstants.INSTANCE.tableDisplayer_groupsTitle()).setColumnsTitle(TableConstants.INSTANCE.tableDisplayer_columnsTitle());
        return new DisplayerConstraints(lookupConstraints).supportsAttribute(DisplayerAttributeDef.TYPE).supportsAttribute(DisplayerAttributeDef.RENDERER).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.COLUMNS_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.FILTER_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.REFRESH_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.GENERAL_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.TABLE_GROUP);
    }

    protected void beforeDataSetLookup() {
        String defaultSortColumn;
        if (this.lastOrderedColumn == null && !StringUtils.isBlank((String)(defaultSortColumn = this.displayerSettings.getTableDefaultSortColumnId()))) {
            this.lastOrderedColumn = defaultSortColumn;
            this.lastSortOrder = this.displayerSettings.getTableDefaultSortOrder();
        }
        if (this.lastOrderedColumn != null) {
            this.sortApply(this.lastOrderedColumn, this.lastSortOrder);
        }
        this.dataSetHandler.limitDataSetRows(this.tableProvider.lastOffset, this.displayerSettings.getTablePageSize());
    }

    protected void afterDataSetLookup(DataSet dataSet) {
        this.numberOfRows = dataSet.getRowCountNonTrimmed();
    }

    protected Widget createVisualization() {
        this.table = this.createTable();
        this.tableProvider.addDataDisplay((HasData<Integer>)this.table);
        this.updateVisualization();
        HTML titleHtml = new HTML();
        if (this.displayerSettings.isTitleVisible()) {
            titleHtml.setText(this.displayerSettings.getTitle());
        }
        VerticalPanel verticalPanel = new VerticalPanel();
        verticalPanel.add((Widget)titleHtml);
        verticalPanel.add(this.table);
        return verticalPanel;
    }

    protected void updateVisualization() {
        this.tableProvider.gotoFirstPage();
        this.table.setRowCount(this.numberOfRows, true);
        int height = 42 + 37 * (this.dataSet.getRowCount() == 0 ? 1 : this.dataSet.getRowCount());
        this.table.setHeight((height > Window.getClientHeight() - this.getAbsoluteTop() ? Window.getClientHeight() - this.getAbsoluteTop() : height) + "px");
        if (this.table.getPageSize() >= this.table.getRowCount()) {
            this.table.pager.setVisible(false);
        } else {
            this.table.pager.setVisible(true);
        }
        this.table.redraw();
        this.redrawColumnSelectionWidget();
    }

    protected PagedTable<Integer> createTable() {
        PagedTable pagedTable = new PagedTable(this.displayerSettings.getTablePageSize());
        pagedTable.pageSizesSelector.setVisible(false);
        List dataColumns = this.dataSet.getColumns();
        for (int i = 0; i < dataColumns.size(); ++i) {
            DataColumn dataColumn = (DataColumn)dataColumns.get(i);
            ColumnSettings columnSettings = this.displayerSettings.getColumnSettings(dataColumn);
            String columnName = columnSettings.getColumnName();
            Column<Integer, ?> column = this.createColumn(dataColumn, i);
            if (column == null) continue;
            column.setSortable(true);
            pagedTable.addColumn(column, columnName);
        }
        pagedTable.pager.setPageSize(this.displayerSettings.getTablePageSize());
        int tableWidth = this.displayerSettings.getTableWidth();
        pagedTable.setWidth(tableWidth == 0 ? dataColumns.size() * 100 + 40 + "px" : tableWidth + "px");
        pagedTable.setEmptyTableCaption(TableConstants.INSTANCE.tableDisplayer_noDataAvailable());
        if (this.displayerSettings.isTableSortEnabled()) {
            pagedTable.addColumnSortHandler((ColumnSortEvent.Handler)new ColumnSortEvent.AsyncHandler((HasData)pagedTable){

                public void onColumnSort(ColumnSortEvent event) {
                    TableDisplayer.this.lastOrderedColumn = ((DataColumnCell)event.getColumn().getCell()).columnId;
                    TableDisplayer.this.lastSortOrder = event.isSortAscending() ? SortOrder.ASCENDING : SortOrder.DESCENDING;
                    TableDisplayer.this.redraw();
                }
            });
        }
        return pagedTable;
    }

    protected Column<Integer, ?> createColumn(final DataColumn column, final int columnNumber) {
        switch (column.getColumnType()) {
            case LABEL: {
                return new Column<Integer, String>((Cell)new DataColumnCell(column.getId(), true)){

                    public String getValue(Integer row) {
                        Object value = TableDisplayer.this.dataSet.getValueAt(row.intValue(), columnNumber);
                        return TableDisplayer.this.formatValue(value, column);
                    }
                };
            }
            case NUMBER: 
            case DATE: 
            case TEXT: {
                return new Column<Integer, String>((Cell)new DataColumnCell(column.getId(), false)){

                    public String getValue(Integer row) {
                        Object value = TableDisplayer.this.dataSet.getValueAt(row.intValue(), columnNumber);
                        return TableDisplayer.this.formatValue(value, column);
                    }
                };
            }
        }
        return null;
    }

    protected Widget createCurrentSelectionWidget() {
        if (!this.displayerSettings.isFilterEnabled()) {
            return null;
        }
        Set columnFilters = this.filterColumns();
        if (columnFilters.isEmpty()) {
            return null;
        }
        HorizontalPanel panel = new HorizontalPanel();
        panel.getElement().setAttribute("cellpadding", "2");
        for (String columnId : columnFilters) {
            List selectedValues = this.filterIntervals(columnId);
            DataColumn column = this.dataSet.getColumnById(columnId);
            for (Interval interval : selectedValues) {
                String formattedValue = this.formatInterval(interval, column);
                panel.add((Widget)new Label(formattedValue));
            }
        }
        Anchor anchor = new Anchor(TableConstants.INSTANCE.tableDisplayer_reset());
        panel.add((Widget)anchor);
        anchor.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TableDisplayer.this.filterReset();
                TableDisplayer.this.redrawColumnSelectionWidget();
            }
        });
        return panel;
    }

    protected void redrawColumnSelectionWidget() {
        if (this.currentSelectionWidget != null) {
            this.table.getLeftToolbar().remove(this.currentSelectionWidget);
        }
        this.currentSelectionWidget = this.createCurrentSelectionWidget();
        if (this.currentSelectionWidget != null) {
            this.table.getLeftToolbar().add(this.currentSelectionWidget);
        }
    }

    protected void onCellSelected(String columnId, boolean selectable, int rowIndex) {
        if (!selectable || !this.displayerSettings.isFilterEnabled()) {
            return;
        }
        this.tableProvider.lastOffset = 0;
        this.filterUpdate(columnId, rowIndex);
        this.redrawColumnSelectionWidget();
    }

    protected class TableProvider
    extends AsyncDataProvider<Integer> {
        protected int lastOffset = 0;

        protected TableProvider() {
        }

        protected List<Integer> getCurrentPageRows(HasData<Integer> display) {
            int pageSize;
            int start = ((PagedTable)display).getPageStart();
            int end = start + (pageSize = ((PagedTable)display).getPageSize());
            if (end > TableDisplayer.this.numberOfRows) {
                end = TableDisplayer.this.numberOfRows;
            }
            ArrayList<Integer> rows = new ArrayList<Integer>(end - start);
            for (int i = 0; i < end - start; ++i) {
                rows.add(i);
            }
            return rows;
        }

        public void gotoFirstPage() {
            this.lastOffset = 0;
            TableDisplayer.this.table.pager.setPage(0);
            int start = TableDisplayer.this.table.getPageStart();
            List<Integer> rows = this.getCurrentPageRows((HasData<Integer>)TableDisplayer.this.table);
            this.updateRowData(start, rows);
        }

        public void addDataDisplay(HasData<Integer> display) {
            this.lastOffset = 0;
            super.addDataDisplay(display);
        }

        protected void onRangeChanged(HasData<Integer> display) {
            int start = ((PagedTable)display).getPageStart();
            final List<Integer> rows = this.getCurrentPageRows(display);
            if (this.lastOffset == start) {
                this.updateRowData(start, rows);
            } else {
                try {
                    this.lastOffset = start;
                    TableDisplayer.this.beforeDataSetLookup();
                    TableDisplayer.this.dataSetHandler.lookupDataSet(new DataSetReadyCallback(){

                        public void callback(DataSet ds) {
                            try {
                                TableDisplayer.this.dataSet = ds;
                                TableDisplayer.this.afterDataSetLookup(TableDisplayer.this.dataSet);
                                TableProvider.this.updateRowData(TableProvider.this.lastOffset, rows);
                                int height = 42 + 37 * (TableDisplayer.this.dataSet.getRowCount() == 0 ? 1 : TableDisplayer.this.dataSet.getRowCount());
                                TableDisplayer.this.table.setHeight(height + "px");
                            }
                            catch (Exception e) {
                                TableDisplayer.this.displayMessage(CommonConstants.INSTANCE.error() + e.getMessage());
                                TableDisplayer.this.afterError(e);
                            }
                        }

                        public void notFound() {
                            TableDisplayer.this.displayMessage(CommonConstants.INSTANCE.error() + CommonConstants.INSTANCE.error_dataset_notfound());
                            TableDisplayer.this.afterError(new ClientRuntimeError(CommonConstants.INSTANCE.error_dataset_notfound()));
                        }

                        public boolean onError(ClientRuntimeError error) {
                            TableDisplayer.this.displayMessage(CommonConstants.INSTANCE.error() + error.getMessage());
                            TableDisplayer.this.afterError(error);
                            return false;
                        }
                    });
                }
                catch (Exception e) {
                    TableDisplayer.this.displayMessage(CommonConstants.INSTANCE.error() + e.getMessage());
                    TableDisplayer.this.afterError(e);
                }
            }
        }
    }

    protected class DataColumnCell
    extends TextCell {
        private String columnId;
        private boolean selectable = false;

        DataColumnCell(String columnId, boolean selectable) {
            this.columnId = columnId;
            this.selectable = selectable;
        }

        public Set<String> getConsumedEvents() {
            HashSet<String> consumedEvents = new HashSet<String>();
            consumedEvents.add("click");
            return consumedEvents;
        }

        public void onBrowserEvent(Cell.Context context, Element parent, String value, NativeEvent event, ValueUpdater<String> valueUpdater) {
            int rowIndexInPage = context.getIndex() - TableDisplayer.this.table.getPageStart();
            TableDisplayer.this.onCellSelected(this.columnId, this.selectable, rowIndexInPage);
        }
    }
}

