/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.client.selector;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.OptionElement;
import com.google.gwt.dom.client.SelectElement;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.displayer.ColumnSettings;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.displayer.client.AbstractDisplayer;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.renderer.client.resources.i18n.SelectorConstants;

public class SelectorDisplayer
extends AbstractDisplayer {
    ListBox listBox = null;

    public DisplayerConstraints createDisplayerConstraints() {
        DataSetLookupConstraints lookupConstraints = (DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupRequired(true).setGroupColumn(true).setMaxColumns(-1)).setMinColumns(1)).setExtraColumnsAllowed(true)).setGroupsTitle(SelectorConstants.INSTANCE.selectorDisplayer_groupsTitle()).setColumnsTitle(SelectorConstants.INSTANCE.selectorDisplayer_columnsTitle()).setColumnTypes((ColumnType[][])new ColumnType[][]{{ColumnType.LABEL}});
        return new DisplayerConstraints(lookupConstraints).supportsAttribute(DisplayerAttributeDef.TYPE).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.COLUMNS_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.FILTER_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.REFRESH_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.GENERAL_GROUP);
    }

    protected Widget createVisualization() {
        this.listBox = new ListBox();
        this.updateVisualization();
        this.listBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                int index;
                String firstColumnId = SelectorDisplayer.this.dataSet.getColumnByIndex(0).getId();
                List currentFilter = SelectorDisplayer.this.filterIndexes(firstColumnId);
                if (currentFilter != null && !currentFilter.isEmpty()) {
                    SelectorDisplayer.this.filterReset();
                }
                if ((index = SelectorDisplayer.this.listBox.getSelectedIndex()) > 0) {
                    SelectorDisplayer.this.filterUpdate(firstColumnId, index - 1);
                }
            }
        });
        return this.listBox;
    }

    protected void updateVisualization() {
        this.listBox.clear();
        DataColumn firstColumn = this.dataSet.getColumnByIndex(0);
        String firstColumnId = firstColumn.getId();
        ColumnSettings columnSettings = this.displayerSettings.getColumnSettings(firstColumn);
        String firstColumnName = columnSettings.getColumnName();
        this.listBox.addItem("- " + SelectorConstants.INSTANCE.selectorDisplayer_select() + " " + firstColumnName + " -");
        SelectElement selectElement = SelectElement.as((Element)this.listBox.getElement());
        NodeList options = selectElement.getOptions();
        List currentFilter = super.filterIndexes(firstColumnId);
        for (int i = 0; i < this.dataSet.getRowCount(); ++i) {
            int ncolumns;
            Object obj = this.dataSet.getValueAt(i, 0);
            if (obj == null) continue;
            String value = super.formatValue(obj, firstColumn);
            this.listBox.addItem(value);
            if (currentFilter != null && currentFilter.contains(i)) {
                this.listBox.setSelectedIndex(i + 1);
            }
            if ((ncolumns = this.getNumberOfColumns(this.dataSet)) <= 1) continue;
            StringBuilder out = new StringBuilder();
            for (int j = 1; j < ncolumns; ++j) {
                DataColumn extraColumn = this.dataSet.getColumnByIndex(j);
                columnSettings = this.displayerSettings.getColumnSettings(extraColumn);
                String extraColumnName = columnSettings.getColumnName();
                Object extraValue = this.dataSet.getValueAt(i, j);
                if (extraValue == null) continue;
                if (j > 1) {
                    out.append("  ");
                }
                String formattedValue = super.formatValue(extraValue, extraColumn);
                out.append(extraColumnName).append("=").append(formattedValue);
            }
            OptionElement optionElement = (OptionElement)options.getItem(i + 1);
            if (optionElement == null) continue;
            optionElement.setTitle(out.toString());
        }
    }

    protected int getNumberOfColumns(DataSet dataSet) {
        return dataSet.getColumns().size();
    }

    public void onFilterEnabled(Displayer displayer, DataSetGroup groupOp) {
        String firstColumnId = this.dataSet.getColumnByIndex(0).getId();
        if (firstColumnId.equals(groupOp.getColumnGroup().getColumnId())) {
            this.columnSelectionMap.put(groupOp.getColumnGroup().getColumnId(), groupOp.getSelectedIntervalList());
        }
        super.onFilterEnabled(displayer, groupOp);
    }

    public void onFilterReset(Displayer displayer, List<DataSetGroup> groupOps) {
        String firstColumnId = this.dataSet.getColumnByIndex(0).getId();
        for (DataSetGroup groupOp : groupOps) {
            if (!firstColumnId.equals(groupOp.getColumnGroup().getColumnId())) continue;
            this.columnSelectionMap.remove(groupOp.getColumnGroup().getColumnId());
        }
        super.onFilterReset(displayer, groupOps);
    }
}

