/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.client.metric;

import com.github.gwtbootstrap.client.ui.Heading;
import com.github.gwtbootstrap.client.ui.Hero;
import com.github.gwtbootstrap.client.ui.Paragraph;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import org.dashbuilder.common.client.StringUtils;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.renderer.client.metric.MetricView;

public class MetricViewImpl
extends Composite
implements MetricView {
    @UiField
    protected Hero heroPanel;
    @UiField
    protected FocusPanel centerPanel;
    @UiField
    protected Paragraph titlePanel;
    @UiField
    protected Panel metricPanel;
    @UiField
    protected Heading metricHeading;
    protected DisplayerSettings displayerSettings;
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);

    public MetricViewImpl() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    @Override
    public void applySettings(DisplayerSettings displayerSettings) {
        this.displayerSettings = displayerSettings;
        int w = displayerSettings.getChartWidth();
        int h = displayerSettings.getChartHeight();
        int mtop = displayerSettings.getChartMarginTop();
        int mbottom = displayerSettings.getChartMarginBottom();
        int mleft = displayerSettings.getChartMarginLeft();
        int mright = displayerSettings.getChartMarginRight();
        Style style = this.heroPanel.getElement().getStyle();
        style.setPadding(0.0, Style.Unit.PX);
        style.setWidth((double)w, Style.Unit.PX);
        style.setHeight((double)h, Style.Unit.PX);
        style.setTextAlign(Style.TextAlign.CENTER);
        style.setVerticalAlign(Style.VerticalAlign.MIDDLE);
        if (!StringUtils.isBlank((String)displayerSettings.getChartBackgroundColor())) {
            style.setBackgroundColor("#" + displayerSettings.getChartBackgroundColor());
        }
        style = this.centerPanel.getElement().getStyle();
        style.setPaddingTop((double)mtop, Style.Unit.PX);
        style.setPaddingBottom((double)mbottom, Style.Unit.PX);
        style.setPaddingLeft((double)mleft, Style.Unit.PX);
        style.setPaddingRight((double)mright, Style.Unit.PX);
        this.titlePanel.setVisible(displayerSettings.isTitleVisible());
        this.titlePanel.setText(displayerSettings.getTitle());
    }

    @Override
    public void updateMetric(String value) {
        this.metricHeading.setText(value);
    }

    public HandlerRegistration addClickHandler(ClickHandler clickHandler) {
        Style style = this.centerPanel.getElement().getStyle();
        style.setCursor(Style.Cursor.POINTER);
        return this.centerPanel.addClickHandler(clickHandler);
    }

    static interface Binder
    extends UiBinder<Widget, MetricViewImpl> {
    }
}

