/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.client.metric;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.renderer.client.metric.AbstractMetricDisplayer;
import org.dashbuilder.renderer.client.metric.MetricView;
import org.dashbuilder.renderer.client.metric.MetricViewImpl;
import org.dashbuilder.renderer.client.resources.i18n.MetricConstants;

public class MetricDisplayer
extends AbstractMetricDisplayer {
    protected MetricView metricView = null;
    protected boolean filterOn = false;

    protected Widget createVisualization() {
        this.metricView = this.createMetricView();
        this.metricView.applySettings(this.displayerSettings);
        this.updateVisualization();
        if (this.displayerSettings.isFilterEnabled()) {
            this.metricView.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent clickEvent) {
                    MetricDisplayer.this.updateFilter();
                }
            });
        }
        return this.metricView.asWidget();
    }

    protected void updateVisualization() {
        if (this.dataSet.getRowCount() == 0) {
            this.metricView.updateMetric(MetricConstants.INSTANCE.metricDisplayer_noDataAvailable());
        } else {
            Number value = (Number)this.dataSet.getValueAt(0, 0);
            String valueStr = super.formatValue((Object)value, this.dataSet.getColumnByIndex(0));
            this.metricView.updateMetric(valueStr);
        }
    }

    protected MetricView createMetricView() {
        return new MetricViewImpl();
    }

    public boolean isFilterOn() {
        return this.filterOn;
    }

    protected void updateFilter() {
        if (this.filterOn) {
            this.filterReset();
        } else {
            this.filterApply();
        }
    }

    protected DataSetFilter fetchFilter() {
        if (this.displayerSettings.getDataSetLookup() == null) {
            return null;
        }
        List filterOps = this.displayerSettings.getDataSetLookup().getOperationList(DataSetFilter.class);
        if (filterOps == null || filterOps.isEmpty()) {
            return null;
        }
        DataSetFilter filter = new DataSetFilter();
        for (DataSetFilter filterOp : filterOps) {
            filter.getColumnFilterList().addAll(filterOp.getColumnFilterList());
        }
        return filter;
    }

    public void applySettings(DisplayerSettings displayerSettings) {
        this.metricView.applySettings(displayerSettings);
    }

    public void filterApply() {
        this.filterOn = true;
        DisplayerSettings clone = this.displayerSettings.cloneInstance();
        clone.setChartBackgroundColor("DDDDDD");
        this.metricView.applySettings(clone);
        DataSetFilter filter = this.fetchFilter();
        super.filterApply(filter);
    }

    public void filterReset() {
        this.filterOn = false;
        this.metricView.applySettings(this.displayerSettings);
        DataSetFilter filter = this.fetchFilter();
        if (filter != null) {
            super.filterReset();
        }
    }
}

