/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget.editor;

import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.IsWidget;
import javax.inject.Inject;
import org.dashbuilder.client.navigation.resources.i18n.NavigationConstants;
import org.dashbuilder.client.navigation.widget.editor.TargetPerspectiveEditor;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.mvp.Command;

@Templated
public class TargetPerspectiveEditorView
implements TargetPerspectiveEditor.View,
IsElement {
    @Inject
    @DataField
    Div perspectiveSelectorDiv;
    @Inject
    @DataField
    Div groupSelectorDiv;
    @Inject
    @DataField
    Span navGroupSelection;
    @Inject
    @DataField
    UnorderedList navGroupItems;
    @Inject
    @DataField
    Span perspectiveSelectorHelp;
    @Inject
    @DataField
    Span navGroupSelectorHelp;
    TargetPerspectiveEditor presenter;

    public void init(TargetPerspectiveEditor presenter) {
        this.presenter = presenter;
        this.perspectiveSelectorHelp.setTitle(NavigationConstants.INSTANCE.navItemEditorPerspectiveHelp());
        this.navGroupSelectorHelp.setTitle(NavigationConstants.INSTANCE.navItemEditorGroupHelp());
    }

    @Override
    public void setPerspectiveSelector(IsWidget perspectiveDropDown) {
        perspectiveDropDown.asWidget().getElement().getStyle().setWidth(150.0, Style.Unit.PX);
        DOMUtil.removeAllChildren((org.jboss.errai.common.client.dom.Node)this.perspectiveSelectorDiv);
        DOMUtil.appendWidgetToElement((HTMLElement)this.perspectiveSelectorDiv, (IsWidget)perspectiveDropDown);
    }

    @Override
    public void clearNavGroupItems() {
        DOMUtil.removeAllChildren((org.jboss.errai.common.client.dom.Node)this.navGroupItems);
        this.navGroupSelection.setTextContent(NavigationConstants.INSTANCE.navGroupSelectorHint());
    }

    @Override
    public void setNavGroupEnabled(boolean enabled) {
        if (enabled) {
            this.groupSelectorDiv.getStyle().removeProperty("display");
            this.navGroupSelectorHelp.getStyle().removeProperty("display");
        } else {
            this.groupSelectorDiv.getStyle().setProperty("display", "none");
            this.navGroupSelectorHelp.getStyle().setProperty("display", "none");
        }
    }

    @Override
    public void addNavGroupItem(String name, Command onSelect) {
        this.addItem(this.navGroupItems, name, false, onSelect);
    }

    @Override
    public void setNavGroupSelection(String name, Command onReset) {
        this.navGroupSelection.setTextContent(name);
        this.navGroupSelection.setTitle(name);
        this.addItem(this.navGroupItems, name, true, onReset);
    }

    private void addItem(UnorderedList unorderedList, String name, boolean selected, Command onSelect) {
        AnchorElement anchor = Document.get().createAnchorElement();
        anchor.setInnerText(name);
        LIElement li = Document.get().createLIElement();
        li.getStyle().setCursor(Style.Cursor.POINTER);
        li.appendChild((Node)anchor);
        li.setClassName(selected ? "selected" : "");
        unorderedList.appendChild((org.jboss.errai.common.client.dom.Node)li);
        Event.sinkEvents((Element)anchor, (int)1);
        Event.setEventListener((Element)anchor, event -> {
            if (1 == event.getTypeInt()) {
                onSelect.execute();
            }
        });
    }
}

