/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget.editor;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.client.navigation.plugin.PerspectivePluginManager;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.uberfire.client.authz.PerspectiveTreeProvider;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.widgets.common.client.dropdown.PerspectiveDropDown;
import org.uberfire.ext.widgets.common.client.dropdown.PerspectiveNameProvider;
import org.uberfire.mvp.Command;

@Dependent
public class TargetPerspectiveEditor
implements IsElement,
PerspectiveNameProvider {
    View view;
    String navGroupId;
    PerspectiveDropDown perspectiveDropDown;
    PerspectivePluginManager perspectivePluginManager;
    PerspectiveTreeProvider perspectiveTreeProvider;
    List<NavItem> navItemList;
    Command onUpdateCommand;

    @Inject
    public TargetPerspectiveEditor(View view, PerspectiveDropDown perspectiveDropDown, PerspectivePluginManager perspectivePluginManager, PerspectiveTreeProvider perspectiveTreeProvider) {
        this.view = view;
        this.perspectiveDropDown = perspectiveDropDown;
        this.perspectivePluginManager = perspectivePluginManager;
        this.perspectiveTreeProvider = perspectiveTreeProvider;
        this.perspectiveDropDown.setPerspectiveNameProvider((PerspectiveNameProvider)this);
        this.perspectiveDropDown.setMaxItems(50);
        this.perspectiveDropDown.setWidth(150);
        this.perspectiveDropDown.setOnChange(this::onPerspectiveChanged);
        this.view.init(this);
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    public void setNavItemList(List<NavItem> navItemList) {
        this.navItemList = navItemList;
    }

    public void setOnUpdateCommand(Command onUpdateCommand) {
        this.onUpdateCommand = onUpdateCommand;
    }

    public void setPerspectiveIdsExcluded(Set<String> perspectiveIdsExcluded) {
        this.perspectiveDropDown.setPerspectiveIdsExcluded(perspectiveIdsExcluded);
    }

    public void setPerspectiveId(String perspectiveId) {
        this.perspectiveDropDown.setSelectedPerspective(perspectiveId);
    }

    public String getPerspectiveId() {
        return this.perspectiveDropDown.getSelectedPerspective().getIdentifier();
    }

    public String getPerspectiveName(String perspectiveId) {
        if (this.perspectivePluginManager.isRuntimePerspective(perspectiveId)) {
            return perspectiveId;
        }
        return this.perspectiveTreeProvider.getPerspectiveName(perspectiveId);
    }

    public void setNavGroupEnabled(boolean enabled) {
        this.view.setNavGroupEnabled(enabled);
    }

    public void setNavGroupId(String navGroupId) {
        this.navGroupId = navGroupId;
    }

    public String getNavGroupId() {
        return this.navGroupId;
    }

    public void show() {
        this.view.setPerspectiveSelector((IsWidget)this.perspectiveDropDown);
        this.updateNavGroups();
    }

    public void clear() {
        this.navGroupId = null;
        this.perspectiveDropDown.clear();
        this.view.clearNavGroupItems();
    }

    private void updateNavGroups() {
        this.view.clearNavGroupItems();
        if (this.navItemList != null) {
            this.updateNavGroups(this.navItemList);
        }
    }

    private void updateNavGroups(List<NavItem> navItemList) {
        navItemList.stream().filter(navItem -> navItem instanceof NavGroup).forEach(this::addNavGroup);
    }

    private void addNavGroup(NavItem navItem) {
        if (navItem.getName() != null) {
            String fullPath = this.calculateFullPath(navItem);
            if (this.navGroupId != null && navItem.getId().equals(this.navGroupId)) {
                this.view.setNavGroupSelection(fullPath, () -> this.onGroupSelected(null));
            } else {
                this.view.addNavGroupItem(fullPath, () -> this.onGroupSelected(navItem.getId()));
            }
        }
        this.updateNavGroups(((NavGroup)navItem).getChildren());
    }

    private String calculateFullPath(NavItem navItem) {
        StringBuilder out = new StringBuilder();
        for (NavGroup parent = navItem.getParent(); parent != null && parent.getName() != null; parent = parent.getParent()) {
            out.insert(0, parent.getName() + ">");
        }
        out.append(navItem.getName());
        return out.toString();
    }

    public void onGroupSelected(String id) {
        this.navGroupId = id;
        this.updateNavGroups();
        if (this.onUpdateCommand != null) {
            this.onUpdateCommand.execute();
        }
    }

    public void onPerspectiveChanged() {
        if (this.onUpdateCommand != null) {
            this.onUpdateCommand.execute();
        }
    }

    public static interface View
    extends UberElement<TargetPerspectiveEditor> {
        public void setPerspectiveSelector(IsWidget var1);

        public void clearNavGroupItems();

        public void setNavGroupEnabled(boolean var1);

        public void addNavGroupItem(String var1, Command var2);

        public void setNavGroupSelection(String var1, Command var2);
    }
}

