/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget;

import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.client.navigation.widget.NavTreeWidget;
import org.dashbuilder.client.navigation.widget.TargetDivNavWidgetView;
import org.dashbuilder.common.client.widgets.AlertBox;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.mvp.Command;

@Dependent
@Templated
public class NavTreeWidgetView
extends TargetDivNavWidgetView<NavTreeWidget>
implements NavTreeWidget.View {
    @Inject
    @DataField
    Div mainDiv;
    NavTreeWidget presenter;

    @Inject
    public NavTreeWidgetView(AlertBox alertBox) {
        super(alertBox);
    }

    public void init(NavTreeWidget presenter) {
        this.presenter = presenter;
        this.navWidget = this.mainDiv;
    }

    @Override
    public void addDivider() {
    }

    @Override
    public void setLevel(int level) {
        int margin = level * 10;
        this.mainDiv.getStyle().setProperty("margin-left", margin + "px");
        if (level == 0) {
            this.mainDiv.getStyle().setProperty("padding", "10px");
        }
    }

    @Override
    public void addRuntimePerspective(String id, String name, String description, Command onClicked) {
        this.addItem("pficon-virtual-machine", id, name, description, onClicked);
    }

    @Override
    public void addPerspective(String id, String name, String description, Command onClicked) {
        this.addItem("pficon-screen", id, name, description, onClicked);
    }

    @Override
    public void addGroupItem(String id, String name, String description, IsWidget widget) {
        this.addItem("pficon-folder-open", id, name, description, null);
        super.addGroupItem(id, name, description, widget);
    }

    @Override
    protected void setSelectedEnabled(boolean enabled) {
        String cname = this.selectedItem.getClassName();
        if (!cname.equals("uf-navtree-widget-non-clickable")) {
            if (enabled) {
                this.selectedItem.setClassName("uf-navtree-widget-clicked");
            } else {
                this.selectedItem.setClassName("uf-navtree-widget-non-clicked");
            }
        }
    }

    protected void addItem(String iconClass, String id, String name, String description, Command onClicked) {
        AnchorElement nameEl = onClicked != null ? Document.get().createAnchorElement() : Document.get().createSpanElement();
        nameEl.setInnerText(name);
        nameEl.setClassName(onClicked != null ? "uf-navtree-widget-non-clicked" : "uf-navtree-widget-non-clickable");
        if (description != null && !description.equals(name)) {
            nameEl.setTitle(description);
        }
        SpanElement iconSpan = Document.get().createSpanElement();
        iconSpan.setClassName("uf-navtree-widget-icon " + iconClass);
        DivElement div = Document.get().createDivElement();
        div.appendChild((com.google.gwt.dom.client.Node)iconSpan);
        div.appendChild((com.google.gwt.dom.client.Node)nameEl);
        this.navWidget.appendChild((Node)div);
        this.itemMap.put(id, nameEl);
        if (onClicked != null) {
            Event.sinkEvents((Element)nameEl, (int)1);
            Event.setEventListener((Element)nameEl, event -> {
                if (1 == event.getTypeInt()) {
                    onClicked.execute();
                }
            });
        }
    }
}

