/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget;

import com.google.gwt.event.dom.client.ClickEvent;
import javax.inject.Inject;
import org.dashbuilder.client.navigation.resources.i18n.NavigationConstants;
import org.dashbuilder.client.navigation.widget.NavItemTileWidget;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Templated
public class NavItemTileWidgetView
implements NavItemTileWidget.View,
IsElement {
    @Inject
    @DataField
    Div mainDiv;
    @Inject
    @DataField
    Div iconDiv;
    @Inject
    @DataField
    Span iconSpan;
    @Inject
    @DataField
    Span textSpan;
    NavItemTileWidget presenter;

    public void init(NavItemTileWidget presenter) {
        this.presenter = presenter;
    }

    @Override
    public void show(String name, String descr, NavItemTileWidget.View.ItemType type) {
        this.textSpan.setTextContent(name);
        this.mainDiv.getStyle().setProperty("title", descr);
        if (NavItemTileWidget.View.ItemType.GROUP == type) {
            this.mainDiv.setClassName("uf-navitem-tile-body uf-navitem-tile-group");
            this.iconSpan.setClassName("pficon-folder-open");
            this.mainDiv.setTitle(NavigationConstants.INSTANCE.openNavItem(name));
        } else if (NavItemTileWidget.View.ItemType.PERSPECTIVE == type) {
            this.mainDiv.setClassName("uf-navitem-tile-body uf-navitem-tile-perspective");
            this.iconSpan.setClassName("pficon-screen");
            this.mainDiv.setTitle(NavigationConstants.INSTANCE.gotoNavItem(name));
        } else if (NavItemTileWidget.View.ItemType.RUNTIME_PERSPECTIVE == type) {
            this.mainDiv.setClassName("uf-navitem-tile-body uf-navitem-tile-runtime-perspective");
            this.iconSpan.setClassName("pficon-virtual-machine");
            this.mainDiv.setTitle(NavigationConstants.INSTANCE.showNavItem(name));
        }
    }

    @EventHandler(value={"mainDiv"})
    public void onMainDivClick(ClickEvent event) {
        this.presenter.onClick();
    }
}

