/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget.editor;

import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.user.client.Event;
import javax.inject.Inject;
import org.dashbuilder.client.navigation.resources.i18n.NavigationConstants;
import org.dashbuilder.client.navigation.widget.editor.NavItemEditor;
import org.dashbuilder.client.navigation.widget.editor.NavItemEditorView;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Input;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.mvp.Command;

@Templated
public class NavItemDefaultEditorView
extends NavItemEditorView<NavItemEditor>
implements NavItemEditor.View<NavItemEditor> {
    @Inject
    @DataField
    Span itemIcon;
    @Inject
    @DataField
    Span itemMenuIcon;
    @Inject
    @DataField
    Span itemEditIcon;
    @Inject
    @DataField
    Span itemDeleteIcon;
    @Inject
    @DataField
    Span itemConfirmIcon;
    @Inject
    @DataField
    Span itemCancelIcon;
    @Inject
    @DataField
    Span itemName;
    @Inject
    @DataField
    Input itemNameInput;
    @Inject
    @DataField
    Div extraDiv;
    @Inject
    @DataField
    Div itemViewDiv;
    @Inject
    @DataField
    Div itemEditDiv;
    @Inject
    @DataField
    UnorderedList commandMenu;
    @Inject
    @DataField
    Div childrenDiv;
    NavItemEditor presenter;

    public void init(NavItemEditor presenter) {
        this.presenter = presenter;
        this.itemViewDiv.setHidden(false);
        this.itemEditDiv.setHidden(true);
        this.itemMenuIcon.setTitle(this.i18n.itemMenuTitle());
        this.itemEditIcon.setTitle(this.i18n.editItem());
        this.itemDeleteIcon.setTitle(this.i18n.deleteItem());
    }

    @Override
    public void clearChildren() {
        DOMUtil.removeAllChildren((org.jboss.errai.common.client.dom.Node)this.childrenDiv);
    }

    @Override
    public void addChild(IsElement editor) {
        this.childrenDiv.appendChild((org.jboss.errai.common.client.dom.Node)editor.getElement());
    }

    @Override
    public void setExpandEnabled(boolean enabled) {
        if (enabled) {
            this.itemIcon.getStyle().removeProperty("opacity");
            this.itemIcon.getStyle().removeProperty("pointer-events");
            this.itemIcon.getStyle().setProperty("cursor", "pointer");
            this.itemName.getStyle().setProperty("cursor", "pointer");
        } else {
            this.itemIcon.getStyle().setProperty("opacity", ".5");
            this.itemIcon.getStyle().setProperty("pointer-events", "none");
            this.itemIcon.getStyle().removeProperty("cursor");
            this.itemName.getStyle().removeProperty("cursor");
        }
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.itemIcon.setClassName(expanded ? "fa fa-angle-down" : "fa fa-angle-right");
        this.childrenDiv.setHidden(!expanded);
    }

    @Override
    public void setItemName(String name) {
        this.itemName.setTextContent(name);
        this.itemNameInput.setValue(name);
    }

    @Override
    public String getItemName() {
        return this.itemNameInput.getValue();
    }

    @Override
    public void setItemNameError(boolean hasError) {
        String classes = "uf-navitem-name-input" + (hasError ? " uf-navitem-name-error" : " form-control");
        this.itemNameInput.setClassName(classes);
    }

    @Override
    public void setItemDescription(String description) {
        this.itemName.setTitle(description);
    }

    @Override
    public void setItemType(NavItemEditor.ItemType type) {
        this.itemIcon.getStyle().removeProperty("cursor");
        if (type == NavItemEditor.ItemType.GROUP) {
            this.itemIcon.setClassName("fa fa-angle-right");
            this.itemEditDiv.getStyle().setProperty("height", "25px");
            this.itemIcon.setTitle("");
        } else if (type == NavItemEditor.ItemType.DIVIDER) {
            this.itemIcon.setClassName("fa fa-minus");
            this.itemIcon.setTitle("");
        } else if (type == NavItemEditor.ItemType.PERSPECTIVE) {
            this.itemIcon.setClassName("fa fa-file-text-o");
            this.itemIcon.setTitle(NavigationConstants.INSTANCE.perspectiveIconTitle());
        } else if (type == NavItemEditor.ItemType.RUNTIME_PERSPECTIVE) {
            this.itemIcon.setClassName("fa fa-file-text-o");
            this.itemIcon.setTitle(NavigationConstants.INSTANCE.pageIconTitle());
        }
    }

    @Override
    public void addCommand(String name, Command command) {
        AnchorElement anchor = Document.get().createAnchorElement();
        anchor.setInnerText(name);
        LIElement li = Document.get().createLIElement();
        li.getStyle().setCursor(Style.Cursor.POINTER);
        li.appendChild((Node)anchor);
        this.commandMenu.appendChild((org.jboss.errai.common.client.dom.Node)li);
        Event.sinkEvents((Element)anchor, (int)1);
        Event.setEventListener((Element)anchor, event -> {
            if (1 == event.getTypeInt()) {
                command.execute();
            }
        });
    }

    @Override
    public void addCommandDivider() {
        LIElement li = Document.get().createLIElement();
        li.setClassName("divider");
        this.commandMenu.appendChild((org.jboss.errai.common.client.dom.Node)li);
    }

    @Override
    public void setCommandsEnabled(boolean enabled) {
        this.itemMenuIcon.setHidden(!enabled);
        this.commandMenu.setHidden(!enabled);
    }

    @Override
    public void clearCommands() {
        DOMUtil.removeAllChildren((org.jboss.errai.common.client.dom.Node)this.commandMenu);
    }

    @Override
    public void startItemEdition() {
        this.itemViewDiv.setHidden(true);
        this.itemEditDiv.setHidden(false);
        this.itemNameInput.focus();
    }

    @Override
    public void finishItemEdition() {
        this.itemViewDiv.setHidden(false);
        this.itemEditDiv.setHidden(true);
    }

    @Override
    public void setContextWidget(IsElement widget) {
        this.extraDiv.getStyle().setProperty("display", "block");
        DOMUtil.removeAllChildren((org.jboss.errai.common.client.dom.Node)this.extraDiv);
        this.extraDiv.appendChild((org.jboss.errai.common.client.dom.Node)widget.getElement());
    }

    @Override
    public void setItemEditable(boolean editable) {
        if (editable) {
            this.itemEditIcon.getStyle().removeProperty("display");
        } else {
            this.itemEditIcon.getStyle().setProperty("display", "none");
        }
    }

    @Override
    public void setItemDeletable(boolean deletable) {
        if (deletable) {
            this.itemDeleteIcon.getStyle().removeProperty("display");
        } else {
            this.itemDeleteIcon.getStyle().setProperty("display", "none");
        }
    }

    @EventHandler(value={"itemIcon"})
    public void onItemIconClick(ClickEvent event) {
        this.presenter.expandOrCollapse();
    }

    @EventHandler(value={"itemName"})
    public void onItemNameClick(ClickEvent event) {
        this.presenter.expandOrCollapse();
    }

    @EventHandler(value={"itemEditIcon"})
    public void onItemEditClick(ClickEvent event) {
        this.presenter.startEdition();
    }

    @EventHandler(value={"itemDeleteIcon"})
    public void onItemDeleteClick(ClickEvent event) {
        this.presenter.deleteItemCommand();
    }

    @EventHandler(value={"itemConfirmIcon"})
    public void onItemEditOkClick(ClickEvent event) {
        this.presenter.onChangesOk();
    }

    @EventHandler(value={"itemCancelIcon"})
    public void onItemEditCancelClick(ClickEvent event) {
        this.presenter.cancelEdition();
    }

    @EventHandler(value={"itemNameInput"})
    public void onItemNameInputOver(MouseOverEvent event) {
        this.itemNameInput.focus();
    }

    @EventHandler(value={"itemNameInput"})
    public void onItemNameChanged(KeyPressEvent keyEvent) {
        if (keyEvent.getNativeEvent().getKeyCode() == 13) {
            this.presenter.onChangesOk();
        } else {
            this.presenter.onItemNameChanged();
        }
    }
}

