/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.List;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.client.navigation.NavigationManager;
import org.dashbuilder.client.navigation.plugin.PerspectivePluginManager;
import org.dashbuilder.client.navigation.widget.BaseNavWidget;
import org.dashbuilder.client.navigation.widget.HasDefaultNavItem;
import org.dashbuilder.client.navigation.widget.HasTargetDiv;
import org.dashbuilder.client.navigation.widget.NavWidget;
import org.dashbuilder.client.navigation.widget.NavWidgetView;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.layout.LayoutRecursionIssue;
import org.dashbuilder.navigation.layout.LayoutRecursionIssueI18n;
import org.dashbuilder.navigation.layout.LayoutTemplateContext;
import org.dashbuilder.navigation.workbench.NavWorkbenchCtx;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.plugin.event.PluginSaved;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.mvp.ParameterizedCommand;

public abstract class TargetDivNavWidget
extends BaseNavWidget
implements HasTargetDiv,
HasDefaultNavItem {
    View view;
    PerspectivePluginManager pluginManager;
    PlaceManager placeManager;
    String targetDivId = null;
    String defaultNavItemId = null;
    boolean gotoItemEnabled = false;

    @Inject
    public TargetDivNavWidget(View view, PerspectivePluginManager pluginManager, PlaceManager placeManager, NavigationManager navigationManager) {
        super(view, navigationManager);
        this.view = view;
        this.pluginManager = pluginManager;
        this.placeManager = placeManager;
    }

    public View getView() {
        return this.view;
    }

    @Override
    public void setGotoItemEnabled(boolean enabled) {
        this.gotoItemEnabled = enabled;
    }

    @Override
    public String getTargetDivId() {
        return this.targetDivId;
    }

    @Override
    public void setTargetDivId(String targetDivId) {
        this.targetDivId = targetDivId;
    }

    @Override
    public String getDefaultNavItemId() {
        return this.defaultNavItemId;
    }

    @Override
    public void setDefaultNavItemId(String defaultNavItemId) {
        this.defaultNavItemId = defaultNavItemId;
    }

    @Override
    public void show(List<NavItem> itemList) {
        super.show(itemList);
        if (this.parent == null && this.gotoItemEnabled) {
            this.gotoDefaultItem();
        }
    }

    protected boolean gotoDefaultItem() {
        boolean gotoItem = this._gotoDefaultItem();
        if (!gotoItem) {
            this.defaultNavItemId = this.getFirstRuntimePerspective(this.navItemList);
            gotoItem = this._gotoDefaultItem();
        }
        return gotoItem;
    }

    protected boolean _gotoDefaultItem() {
        if (this.defaultNavItemId != null && this.setSelectedItem(this.defaultNavItemId)) {
            this.gotoNavItem(true);
            if (this.parent != null && this.onItemSelectedCommand != null) {
                this.onItemSelectedCommand.execute();
            }
            return true;
        }
        return false;
    }

    protected String getFirstRuntimePerspective(List<NavItem> itemList) {
        if (itemList.isEmpty()) {
            return null;
        }
        for (NavItem navItem : itemList) {
            String result;
            if (this.pluginManager.isRuntimePerspective(navItem)) {
                return navItem.getId();
            }
            if (!(navItem instanceof NavGroup) || (result = this.getFirstRuntimePerspective(((NavGroup)navItem).getChildren())) == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void onItemClicked(NavItem navItem) {
        super.onItemClicked(navItem);
        this.gotoNavItem(false);
    }

    @Override
    public void onSubGroupItemClicked(NavWidget subGroup) {
        super.onSubGroupItemClicked(subGroup);
        this.gotoNavItem(false);
    }

    protected void gotoNavItem(boolean onlyRuntimePerspectives) {
        if (this.parent == null && this.gotoItemEnabled) {
            NavWorkbenchCtx navCtx = NavWorkbenchCtx.get((NavItem)this.getItemSelected());
            String resourceId = navCtx.getResourceId();
            String navRootId = navCtx.getNavGroupId();
            if (resourceId != null) {
                if (this.pluginManager.isRuntimePerspective(resourceId)) {
                    LayoutTemplateContext layoutCtx = new LayoutTemplateContext(navRootId);
                    this.pluginManager.buildPerspectiveWidget(resourceId, layoutCtx, (ParameterizedCommand<IsWidget>)((ParameterizedCommand)w -> this.view.showContent(this.targetDivId, (IsWidget)w)), (ParameterizedCommand<LayoutRecursionIssue>)((ParameterizedCommand)this::onInfiniteRecursion));
                } else if (!onlyRuntimePerspectives) {
                    this.placeManager.goTo(resourceId);
                }
            } else {
                this.view.clearContent(this.targetDivId);
            }
        }
    }

    public void onInfiniteRecursion(LayoutRecursionIssue issue) {
        String cause = issue.printReport(this.navigationManager.getNavTree(), (LayoutRecursionIssueI18n)this.view);
        this.view.infiniteRecursionError(this.targetDivId, cause);
    }

    private void onPluginSaved(@Observes PluginSaved event) {
        Plugin plugin = event.getPlugin();
        String pluginName = plugin.getName();
        String selectedPerspectiveId = this.pluginManager.getRuntimePerspectiveId(this.itemSelected);
        if (selectedPerspectiveId != null && selectedPerspectiveId.equals(pluginName)) {
            this.gotoNavItem(true);
        }
    }

    public static interface View<T extends TargetDivNavWidget>
    extends NavWidgetView<T>,
    LayoutRecursionIssueI18n {
        public void clearContent(String var1);

        public void showContent(String var1, IsWidget var2);

        public void infiniteRecursionError(String var1, String var2);
    }
}

