/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.navigation.widget;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.client.navigation.plugin.PerspectivePluginManager;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.workbench.NavWorkbenchCtx;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.ActivityResourceType;

@Dependent
public class NavItemTileWidget
implements IsElement {
    View view;
    PerspectivePluginManager perspectivePluginManager;
    Command onClick = null;

    @Inject
    public NavItemTileWidget(View view, PerspectivePluginManager perspectivePluginManager) {
        this.view = view;
        this.perspectivePluginManager = perspectivePluginManager;
        this.view.init(this);
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    public void setOnClick(Command onClick) {
        this.onClick = onClick;
    }

    public void show(NavItem navItem) {
        String name = navItem.getName();
        String descr = navItem.getDescription();
        if (navItem instanceof NavGroup) {
            this.view.show(name, descr, View.ItemType.GROUP);
        } else {
            NavWorkbenchCtx navCtx = NavWorkbenchCtx.get((NavItem)navItem);
            String resourceId = navCtx.getResourceId();
            if (resourceId != null && ActivityResourceType.PERSPECTIVE.equals((Object)navCtx.getResourceType())) {
                if (this.perspectivePluginManager.isRuntimePerspective(resourceId)) {
                    this.view.show(name, descr, View.ItemType.RUNTIME_PERSPECTIVE);
                } else {
                    this.view.show(name, descr, View.ItemType.PERSPECTIVE);
                }
            }
        }
    }

    void onClick() {
        if (this.onClick != null) {
            this.onClick.execute();
        }
    }

    public static interface View
    extends UberElement<NavItemTileWidget> {
        public void show(String var1, String var2, ItemType var3);

        public static enum ItemType {
            GROUP,
            PERSPECTIVE,
            RUNTIME_PERSPECTIVE;

        }
    }
}

