/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.xml;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.metadata.AnnotationIgnores;
import org.hibernate.validator.metadata.ConstraintHelper;
import org.hibernate.validator.metadata.MetaConstraint;

public class XmlMappingParser {
    private static final String VALIDATION_MAPPING_XSD = "META-INF/validation-mapping-1.0.xsd";
    private static final String MESSAGE_PARAM = "message";
    private static final String GROUPS_PARAM = "groups";
    private static final String PAYLOAD_PARAM = "payload";
    private static final String PACKAGE_SEPARATOR = ".";
    private final Set<Class<?>> processedClasses = new HashSet();
    private final ConstraintHelper constraintHelper;
    private final AnnotationIgnores annotationIgnores;
    private final Map<Class<?>, List<MetaConstraint<?, ? extends Annotation>>> constraintMap;
    private final Map<Class<?>, List<Member>> cascadedMembers;
    private final Map<Class<?>, List<Class<?>>> defaultSequences;

    public XmlMappingParser(ConstraintHelper constraintHelper) {
        this.constraintHelper = constraintHelper;
        this.annotationIgnores = new AnnotationIgnores();
        this.constraintMap = new HashMap();
        this.cascadedMembers = new HashMap();
        this.defaultSequences = new HashMap();
    }

    public void parse(Set<InputStream> mappingStreams) {
    }

    public Set<Class<?>> getXmlConfiguredClasses() {
        return this.processedClasses;
    }

    public AnnotationIgnores getAnnotationIgnores() {
        return this.annotationIgnores;
    }

    public <T> List<MetaConstraint<T, ? extends Annotation>> getConstraintsForClass(Class<T> beanClass) {
        ArrayList<MetaConstraint<T, Annotation>> list = new ArrayList<MetaConstraint<T, Annotation>>();
        if (this.constraintMap.containsKey(beanClass)) {
            Iterator<MetaConstraint<?, Annotation>> i$ = this.constraintMap.get(beanClass).iterator();
            while (i$.hasNext()) {
                MetaConstraint<?, Annotation> metaConstraint;
                MetaConstraint<?, Annotation> boundMetaConstraint = metaConstraint = i$.next();
                list.add(boundMetaConstraint);
            }
            return list;
        }
        return Collections.emptyList();
    }

    public List<Member> getCascadedMembersForClass(Class<?> beanClass) {
        if (this.cascadedMembers.containsKey(beanClass)) {
            return this.cascadedMembers.get(beanClass);
        }
        return Collections.emptyList();
    }

    public List<Class<?>> getDefaultSequenceForClass(Class<?> beanClass) {
        if (this.defaultSequences.containsKey(beanClass)) {
            return this.defaultSequences.get(beanClass);
        }
        return Collections.emptyList();
    }
}

