/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.util.privilegedactions;

import java.security.PrivilegedAction;
import javax.validation.ValidationException;

public class LoadClass
implements PrivilegedAction<Class<?>> {
    private final String className;
    private final Class<?> caller;

    public static LoadClass action(String className, Class<?> caller) {
        return new LoadClass(className, caller);
    }

    private LoadClass(String className, Class<?> caller) {
        this.className = className;
        this.caller = caller;
    }

    @Override
    public Class<?> run() {
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                return contextClassLoader.loadClass(this.className);
            }
        }
        catch (ClassNotFoundException contextClassLoader) {
        }
        catch (RuntimeException contextClassLoader) {
            // empty catch block
        }
        try {
            return Class.forName(this.className, true, this.caller.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new ValidationException("Unable to load class: " + this.className, (Throwable)e);
        }
    }
}

