/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.util.privilegedactions;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedAction;
import javax.validation.ValidationException;

public class ConstructorInstance<T>
implements PrivilegedAction<T> {
    private final Constructor<T> constructor;
    private final Object[] initArgs;

    public static <T> ConstructorInstance<T> action(Constructor<T> constructor, Object ... initArgs) {
        return new ConstructorInstance<T>(constructor, initArgs);
    }

    private ConstructorInstance(Constructor<T> constructor, Object ... initArgs) {
        this.constructor = constructor;
        this.initArgs = initArgs;
    }

    @Override
    public T run() {
        try {
            return this.constructor.newInstance(this.initArgs);
        }
        catch (InstantiationException e) {
            throw new ValidationException("Unable to instantiate" + this.constructor.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ValidationException("Unable to instantiate" + this.constructor.getName(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ValidationException("Unable to instantiate" + this.constructor.getName(), (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new ValidationException("Unable to instantiate" + this.constructor.getName(), (Throwable)e);
        }
    }
}

