/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.util.annotationfactory;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.hibernate.validator.util.ReflectionHelper;
import org.hibernate.validator.util.annotationfactory.AnnotationDescriptor;

public class AnnotationProxy
implements Annotation,
InvocationHandler,
Serializable {
    private static final long serialVersionUID = 6907601010599429454L;
    private final Class<? extends Annotation> annotationType;
    private final Map<String, Object> values;

    public AnnotationProxy(AnnotationDescriptor descriptor) {
        this.annotationType = descriptor.type();
        this.values = this.getAnnotationValues(descriptor);
    }

    private Map<String, Object> getAnnotationValues(AnnotationDescriptor descriptor) {
        Method[] declaredMethods;
        HashMap<String, Object> result = new HashMap<String, Object>();
        int processedValuesFromDescriptor = 0;
        for (Method m : declaredMethods = ReflectionHelper.getMethods(this.annotationType)) {
            if (descriptor.containsElement(m.getName())) {
                result.put(m.getName(), descriptor.valueOf(m.getName()));
                ++processedValuesFromDescriptor;
                continue;
            }
            if (m.getDefaultValue() != null) {
                result.put(m.getName(), m.getDefaultValue());
                continue;
            }
            throw new IllegalArgumentException("No value provided for " + m.getName());
        }
        if (processedValuesFromDescriptor != descriptor.numberOfElements()) {
            throw new RuntimeException("Trying to instantiate " + this.annotationType + " with unknown parameters.");
        }
        return result;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.values.containsKey(method.getName())) {
            return this.values.get(method.getName());
        }
        return method.invoke((Object)this, args);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('@').append(this.annotationType.getName()).append('(');
        for (String s : this.getRegisteredMethodsInAlphabeticalOrder()) {
            result.append(s).append('=').append(this.values.get(s)).append(", ");
        }
        if (this.values.size() > 0) {
            result.delete(result.length() - 2, result.length());
            result.append(")");
        } else {
            result.delete(result.length() - 1, result.length());
        }
        return result.toString();
    }

    private SortedSet<String> getRegisteredMethodsInAlphabeticalOrder() {
        TreeSet<String> result = new TreeSet<String>();
        result.addAll(this.values.keySet());
        return result;
    }
}

