/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.resourceloading;

import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.validator.resourceloading.DelegatingResourceBundleLocator;
import org.hibernate.validator.resourceloading.ResourceBundleLocator;

public class CachingResourceBundleLocator
extends DelegatingResourceBundleLocator {
    private final ConcurrentMap<Locale, ResourceBundle> bundleCache = new ConcurrentHashMap<Locale, ResourceBundle>();

    public CachingResourceBundleLocator(ResourceBundleLocator delegate) {
        super(delegate);
    }

    @Override
    public ResourceBundle getResourceBundle(Locale locale) {
        if (this.bundleCache.containsKey(locale)) {
            return (ResourceBundle)this.bundleCache.get(locale);
        }
        ResourceBundle bundle = super.getResourceBundle(locale);
        if (bundle != null) {
            this.bundleCache.put(locale, bundle);
        }
        return bundle;
    }
}

