/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.Constraint;
import javax.validation.ConstraintDefinitionException;
import javax.validation.ConstraintValidator;
import javax.validation.ValidationException;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Past;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.impl.AssertFalseValidator;
import org.hibernate.validator.constraints.impl.AssertTrueValidator;
import org.hibernate.validator.constraints.impl.DecimalMaxValidatorForNumber;
import org.hibernate.validator.constraints.impl.DecimalMaxValidatorForString;
import org.hibernate.validator.constraints.impl.DecimalMinValidatorForNumber;
import org.hibernate.validator.constraints.impl.DecimalMinValidatorForString;
import org.hibernate.validator.constraints.impl.DigitsValidatorForNumber;
import org.hibernate.validator.constraints.impl.DigitsValidatorForString;
import org.hibernate.validator.constraints.impl.FutureValidatorForCalendar;
import org.hibernate.validator.constraints.impl.FutureValidatorForDate;
import org.hibernate.validator.constraints.impl.MaxValidatorForNumber;
import org.hibernate.validator.constraints.impl.MaxValidatorForString;
import org.hibernate.validator.constraints.impl.MinValidatorForNumber;
import org.hibernate.validator.constraints.impl.MinValidatorForString;
import org.hibernate.validator.constraints.impl.NotNullValidator;
import org.hibernate.validator.constraints.impl.NullValidator;
import org.hibernate.validator.constraints.impl.PastValidatorForCalendar;
import org.hibernate.validator.constraints.impl.PastValidatorForDate;
import org.hibernate.validator.constraints.impl.PatternValidator;
import org.hibernate.validator.constraints.impl.SizeValidatorForArray;
import org.hibernate.validator.constraints.impl.SizeValidatorForArraysOfBoolean;
import org.hibernate.validator.constraints.impl.SizeValidatorForArraysOfByte;
import org.hibernate.validator.constraints.impl.SizeValidatorForArraysOfChar;
import org.hibernate.validator.constraints.impl.SizeValidatorForArraysOfDouble;
import org.hibernate.validator.constraints.impl.SizeValidatorForArraysOfFloat;
import org.hibernate.validator.constraints.impl.SizeValidatorForArraysOfInt;
import org.hibernate.validator.constraints.impl.SizeValidatorForArraysOfLong;
import org.hibernate.validator.constraints.impl.SizeValidatorForCollection;
import org.hibernate.validator.constraints.impl.SizeValidatorForMap;
import org.hibernate.validator.constraints.impl.SizeValidatorForString;
import org.hibernate.validator.util.ReflectionHelper;

public class ConstraintHelper {
    private final ConcurrentHashMap<Class<? extends Annotation>, List<Class<? extends ConstraintValidator<?, ?>>>> builtinConstraints = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<? extends Annotation>, List<Class<? extends ConstraintValidator<? extends Annotation, ?>>>> constraintValidatorDefinitions = new ConcurrentHashMap();

    public ConstraintHelper() {
        ArrayList<Class> constraintList = new ArrayList<Class>();
        constraintList.add(AssertFalseValidator.class);
        this.builtinConstraints.put(AssertFalse.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(AssertTrueValidator.class);
        this.builtinConstraints.put(AssertTrue.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(DecimalMaxValidatorForNumber.class);
        constraintList.add(DecimalMaxValidatorForString.class);
        this.builtinConstraints.put(DecimalMax.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(DecimalMinValidatorForNumber.class);
        constraintList.add(DecimalMinValidatorForString.class);
        this.builtinConstraints.put(DecimalMin.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(DigitsValidatorForString.class);
        constraintList.add(DigitsValidatorForNumber.class);
        this.builtinConstraints.put(Digits.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(FutureValidatorForCalendar.class);
        constraintList.add(FutureValidatorForDate.class);
        this.builtinConstraints.put(Future.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(MaxValidatorForNumber.class);
        constraintList.add(MaxValidatorForString.class);
        this.builtinConstraints.put(Max.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(MinValidatorForNumber.class);
        constraintList.add(MinValidatorForString.class);
        this.builtinConstraints.put(Min.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(NotNullValidator.class);
        this.builtinConstraints.put(NotNull.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(NullValidator.class);
        this.builtinConstraints.put(Null.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(PastValidatorForCalendar.class);
        constraintList.add(PastValidatorForDate.class);
        this.builtinConstraints.put(Past.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(PatternValidator.class);
        this.builtinConstraints.put(Pattern.class, constraintList);
        constraintList = new ArrayList();
        constraintList.add(SizeValidatorForString.class);
        constraintList.add(SizeValidatorForCollection.class);
        constraintList.add(SizeValidatorForArray.class);
        constraintList.add(SizeValidatorForMap.class);
        constraintList.add(SizeValidatorForArraysOfBoolean.class);
        constraintList.add(SizeValidatorForArraysOfByte.class);
        constraintList.add(SizeValidatorForArraysOfChar.class);
        constraintList.add(SizeValidatorForArraysOfDouble.class);
        constraintList.add(SizeValidatorForArraysOfFloat.class);
        constraintList.add(SizeValidatorForArraysOfInt.class);
        constraintList.add(SizeValidatorForArraysOfLong.class);
        this.builtinConstraints.put(Size.class, constraintList);
    }

    public List<Class<? extends ConstraintValidator<? extends Annotation, ?>>> getBuiltInConstraints(Class<? extends Annotation> annotationClass) {
        List<Class<ConstraintValidator<?, ?>>> builtInList = this.builtinConstraints.get(annotationClass);
        if (builtInList == null || builtInList.size() == 0) {
            throw new ValidationException("Unable to find constraints for  " + annotationClass);
        }
        ArrayList constraints = new ArrayList(builtInList.size());
        Iterator<Class<ConstraintValidator<?, ?>>> i$ = builtInList.iterator();
        while (i$.hasNext()) {
            Class<ConstraintValidator<?, ?>> validatorClass;
            Class<ConstraintValidator<?, ?>> safeValidatorClass = validatorClass = i$.next();
            constraints.add(safeValidatorClass);
        }
        return constraints;
    }

    public boolean isBuiltinConstraint(Class<? extends Annotation> annotationType) {
        return this.builtinConstraints.containsKey(annotationType);
    }

    public boolean isMultiValueConstraint(Class<? extends Annotation> annotationType) {
        Class<?> returnType;
        boolean isMultiValueConstraint = false;
        Method method = ReflectionHelper.getMethod(annotationType, "value");
        if (method != null && (returnType = method.getReturnType()).isArray() && returnType.getComponentType().isAnnotation()) {
            Class<?> componentType = returnType.getComponentType();
            isMultiValueConstraint = this.isConstraintAnnotation(componentType) || this.isBuiltinConstraint(componentType);
        }
        return isMultiValueConstraint;
    }

    public <A extends Annotation> List<Annotation> getMultiValueConstraints(A annotation) {
        ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
        try {
            Class<?> returnType;
            Method method = ReflectionHelper.getMethod(annotation.getClass(), "value");
            if (method != null && (returnType = method.getReturnType()).isArray() && returnType.getComponentType().isAnnotation()) {
                Annotation[] annotations;
                for (Annotation a : annotations = (Annotation[])method.invoke(annotation, new Object[0])) {
                    Class<? extends Annotation> annotationType = a.annotationType();
                    if (!this.isConstraintAnnotation(annotationType) && !this.isBuiltinConstraint(annotationType)) continue;
                    annotationList.add(a);
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return annotationList;
    }

    public boolean isConstraintAnnotation(Class<? extends Annotation> annotationType) {
        Constraint constraint = annotationType.getAnnotation(Constraint.class);
        if (constraint == null) {
            return false;
        }
        this.assertMessageParameterExists(annotationType);
        this.assertGroupsParameterExists(annotationType);
        this.assertPayloadParameterExists(annotationType);
        this.assertNoParameterStartsWithValid(annotationType);
        return true;
    }

    private void assertNoParameterStartsWithValid(Class<? extends Annotation> annotationType) {
        Method[] methods;
        for (Method m : methods = ReflectionHelper.getMethods(annotationType)) {
            if (!m.getName().startsWith("valid")) continue;
            String msg = "Parameters starting with 'valid' are not allowed in a constraint.";
            throw new ConstraintDefinitionException(msg);
        }
    }

    private void assertPayloadParameterExists(Class<? extends Annotation> annotationType) {
        try {
            Method method = ReflectionHelper.getMethod(annotationType, "payload");
            if (method == null) {
                String msg = annotationType.getName() + " contains Constraint annotation, but does " + "not contain a payload parameter.";
                throw new ConstraintDefinitionException(msg);
            }
            Class[] defaultPayload = (Class[])method.getDefaultValue();
            if (defaultPayload.length != 0) {
                String msg = annotationType.getName() + " contains Constraint annotation, but the payload " + "parameter default value is not the empty array.";
                throw new ConstraintDefinitionException(msg);
            }
        }
        catch (ClassCastException e) {
            String msg = annotationType.getName() + " contains Constraint annotation, but the " + "payload parameter is of wrong type.";
            throw new ConstraintDefinitionException(msg);
        }
    }

    private void assertGroupsParameterExists(Class<? extends Annotation> annotationType) {
        try {
            Method method = ReflectionHelper.getMethod(annotationType, "groups");
            if (method == null) {
                String msg = annotationType.getName() + " contains Constraint annotation, but does " + "not contain a groups parameter.";
                throw new ConstraintDefinitionException(msg);
            }
            Class[] defaultGroups = (Class[])method.getDefaultValue();
            if (defaultGroups.length != 0) {
                String msg = annotationType.getName() + " contains Constraint annotation, but the groups " + "parameter default value is not the empty array.";
                throw new ConstraintDefinitionException(msg);
            }
        }
        catch (ClassCastException e) {
            String msg = annotationType.getName() + " contains Constraint annotation, but the " + "groups parameter is of wrong type.";
            throw new ConstraintDefinitionException(msg);
        }
    }

    private void assertMessageParameterExists(Class<? extends Annotation> annotationType) {
        try {
            Method method = ReflectionHelper.getMethod(annotationType, "message");
            if (method == null) {
                String msg = annotationType.getName() + " contains Constraint annotation, but does " + "not contain a message parameter.";
                throw new ConstraintDefinitionException(msg);
            }
            if (method.getReturnType() != String.class) {
                String msg = annotationType.getName() + " contains Constraint annotation, but the message parameter " + "is not of type java.lang.String.";
                throw new ConstraintDefinitionException(msg);
            }
        }
        catch (ClassCastException e) {
            String msg = annotationType.getName() + " contains Constraint annotation, but the " + "groups parameter is of wrong type.";
            throw new ConstraintDefinitionException(msg);
        }
    }

    public <T extends Annotation> List<Class<? extends ConstraintValidator<T, ?>>> getConstraintValidatorDefinition(Class<T> annotationClass) {
        if (annotationClass == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        List<Class<ConstraintValidator<Annotation, ?>>> list = this.constraintValidatorDefinitions.get(annotationClass);
        ArrayList constraintsValidators = new ArrayList(list.size());
        Iterator<Class<ConstraintValidator<Annotation, ?>>> i$ = list.iterator();
        while (i$.hasNext()) {
            Class<ConstraintValidator<Annotation, ?>> validatorClass;
            Class<ConstraintValidator<Annotation, ?>> safeValidatorClass = validatorClass = i$.next();
            constraintsValidators.add(safeValidatorClass);
        }
        return constraintsValidators;
    }

    public <A extends Annotation> void addConstraintValidatorDefinition(Class<A> annotationClass, List<Class<? extends ConstraintValidator<? extends Annotation, ?>>> definitionClasses) {
        this.constraintValidatorDefinitions.putIfAbsent(annotationClass, definitionClasses);
    }

    public boolean containsConstraintValidatorDefinition(Class<? extends Annotation> annotationClass) {
        return this.constraintValidatorDefinitions.containsKey(annotationClass);
    }
}

