/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.engine;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import javax.validation.spi.ConfigurationState;
import org.hibernate.validator.cfg.CascadeDef;
import org.hibernate.validator.cfg.ConstraintDefWrapper;
import org.hibernate.validator.cfg.ConstraintMapping;
import org.hibernate.validator.engine.ConfigurationImpl;
import org.hibernate.validator.engine.ValidatorContextImpl;
import org.hibernate.validator.metadata.AnnotationIgnores;
import org.hibernate.validator.metadata.BeanMetaDataCache;
import org.hibernate.validator.metadata.BeanMetaDataImpl;
import org.hibernate.validator.metadata.ConstraintDescriptorImpl;
import org.hibernate.validator.metadata.ConstraintHelper;
import org.hibernate.validator.metadata.ConstraintOrigin;
import org.hibernate.validator.metadata.MetaConstraint;
import org.hibernate.validator.util.ReflectionHelper;
import org.hibernate.validator.util.annotationfactory.AnnotationDescriptor;
import org.hibernate.validator.util.annotationfactory.AnnotationFactory;
import org.hibernate.validator.xml.XmlMappingParser;

public class ValidatorFactoryImpl
implements ValidatorFactory {
    private final MessageInterpolator messageInterpolator;
    private final TraversableResolver traversableResolver;
    private final ConstraintValidatorFactory constraintValidatorFactory;
    private final ConstraintHelper constraintHelper;
    private final BeanMetaDataCache beanMetaDataCache;

    public ValidatorFactoryImpl(ConfigurationState configurationState) {
        ConfigurationImpl hibernateSpecificConfig;
        this.messageInterpolator = configurationState.getMessageInterpolator();
        this.constraintValidatorFactory = configurationState.getConstraintValidatorFactory();
        this.traversableResolver = configurationState.getTraversableResolver();
        this.constraintHelper = new ConstraintHelper();
        this.beanMetaDataCache = new BeanMetaDataCache();
        if (!configurationState.getMappingStreams().isEmpty()) {
            this.initXmlConfiguration(configurationState.getMappingStreams());
        }
        if (configurationState instanceof ConfigurationImpl && (hibernateSpecificConfig = (ConfigurationImpl)configurationState).getMapping() != null) {
            this.initProgrammaticConfiguration(hibernateSpecificConfig.getMapping());
        }
    }

    public Validator getValidator() {
        return this.usingContext().getValidator();
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator;
    }

    public TraversableResolver getTraversableResolver() {
        return this.traversableResolver;
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorFactory;
    }

    public <T> T unwrap(Class<T> type) {
        throw new ValidationException("Type " + type + " not supported");
    }

    public ValidatorContext usingContext() {
        return new ValidatorContextImpl(this.constraintValidatorFactory, this.messageInterpolator, this.traversableResolver, this.constraintHelper, this.beanMetaDataCache);
    }

    private <T> void initProgrammaticConfiguration(ConstraintMapping mapping) {
        Iterator<Class<?>> i$ = mapping.getConfiguredClasses().iterator();
        while (i$.hasNext()) {
            Class<?> clazz;
            Class<?> beanClass = clazz = i$.next();
            List<Class<?>> classes = ReflectionHelper.computeClassHierarchy(beanClass);
            Map<Class<?>, List<MetaConstraint<T, ?>>> constraints = this.createEmptyConstraintMap();
            ArrayList<Member> cascadedMembers = new ArrayList<Member>();
            for (Class<?> classInHierarchy : classes) {
                if (mapping.getConstraintConfig().keySet().contains(classInHierarchy)) {
                    this.addProgrammaticConfiguredConstraints(mapping.getConstraintConfig().get(classInHierarchy), beanClass, classInHierarchy, constraints);
                }
                if (!mapping.getCascadeConfig().keySet().contains(classInHierarchy)) continue;
                this.addProgrammaticConfiguredCascade(mapping.getCascadeConfig().get(classInHierarchy), cascadedMembers);
            }
            BeanMetaDataImpl metaData = new BeanMetaDataImpl(beanClass, this.constraintHelper, mapping.getDefaultSequence(beanClass), constraints, cascadedMembers, new AnnotationIgnores(), this.beanMetaDataCache);
            this.beanMetaDataCache.addBeanMetaData(beanClass, metaData);
        }
    }

    private <T> void initXmlConfiguration(Set<InputStream> mappingStreams) {
        XmlMappingParser mappingParser = new XmlMappingParser(this.constraintHelper);
        mappingParser.parse(mappingStreams);
        Set<Class<?>> xmlConfiguredClasses = mappingParser.getXmlConfiguredClasses();
        AnnotationIgnores annotationIgnores = mappingParser.getAnnotationIgnores();
        Iterator<Class<?>> i$ = xmlConfiguredClasses.iterator();
        while (i$.hasNext()) {
            Class<?> clazz;
            Class<?> beanClass = clazz = i$.next();
            List<Class<?>> classes = ReflectionHelper.computeClassHierarchy(beanClass);
            Map<Class<?>, List<MetaConstraint<T, ?>>> constraints = this.createEmptyConstraintMap();
            ArrayList<Member> cascadedMembers = new ArrayList<Member>();
            for (Class<?> classInHierarchy : classes) {
                if (!xmlConfiguredClasses.contains(classInHierarchy)) continue;
                this.addXmlConfiguredConstraints(mappingParser, beanClass, classInHierarchy, constraints);
                this.addXmlCascadedMember(mappingParser, classInHierarchy, cascadedMembers);
            }
            BeanMetaDataImpl metaData = new BeanMetaDataImpl(beanClass, this.constraintHelper, mappingParser.getDefaultSequenceForClass(beanClass), constraints, cascadedMembers, annotationIgnores, this.beanMetaDataCache);
            this.beanMetaDataCache.addBeanMetaData(beanClass, metaData);
        }
    }

    private <T, A extends Annotation> void addXmlConfiguredConstraints(XmlMappingParser mappingParser, Class<T> rootClass, Class<?> hierarchyClass, Map<Class<?>, List<MetaConstraint<T, ?>>> constraints) {
        for (MetaConstraint<?, Annotation> constraint : mappingParser.getConstraintsForClass(hierarchyClass)) {
            ConstraintOrigin definedIn = this.definedIn(rootClass, hierarchyClass);
            ConstraintDescriptorImpl<Annotation> descriptor = new ConstraintDescriptorImpl<Annotation>(constraint.getDescriptor().getAnnotation(), this.constraintHelper, constraint.getElementType(), definedIn);
            MetaConstraint<T, Annotation> newMetaConstraint = new MetaConstraint<T, Annotation>(rootClass, constraint.getMember(), descriptor);
            this.addConstraintToMap(hierarchyClass, newMetaConstraint, constraints);
        }
    }

    private <T, A extends Annotation> void addProgrammaticConfiguredConstraints(List<ConstraintDefWrapper<?>> definitions, Class<T> rootClass, Class<?> hierarchyClass, Map<Class<?>, List<MetaConstraint<T, ?>>> constraints) {
        for (ConstraintDefWrapper<?> config : definitions) {
            Annotation annotation = this.createAnnotationProxy(config);
            ConstraintOrigin definedIn = this.definedIn(rootClass, hierarchyClass);
            ConstraintDescriptorImpl<Annotation> constraintDescriptor = new ConstraintDescriptorImpl<Annotation>(annotation, this.constraintHelper, config.getElementType(), definedIn);
            Member member = null;
            if (!config.getProperty().isEmpty()) {
                member = ReflectionHelper.getMember(config.getBeanType(), config.getProperty(), config.getElementType());
            }
            MetaConstraint metaConstraint = new MetaConstraint(config.getBeanType(), member, constraintDescriptor);
            this.addConstraintToMap(hierarchyClass, metaConstraint, constraints);
        }
    }

    private <T, A extends Annotation> void addConstraintToMap(Class<?> hierarchyClass, MetaConstraint<T, A> constraint, Map<Class<?>, List<MetaConstraint<T, ?>>> constraints) {
        List<MetaConstraint<T, ?>> constraintList = constraints.get(hierarchyClass);
        if (constraintList == null) {
            constraintList = new ArrayList();
            constraints.put(hierarchyClass, constraintList);
        }
        constraintList.add(constraint);
    }

    private void addXmlCascadedMember(XmlMappingParser mappingParser, Class<?> hierarchyClass, List<Member> cascadedMembers) {
        for (Member m : mappingParser.getCascadedMembersForClass(hierarchyClass)) {
            cascadedMembers.add(m);
        }
    }

    private void addProgrammaticConfiguredCascade(List<CascadeDef> cascades, List<Member> cascadedMembers) {
        if (cascades == null) {
            return;
        }
        for (CascadeDef cascade : cascades) {
            Member m = ReflectionHelper.getMember(cascade.getBeanType(), cascade.getProperty(), cascade.getElementType());
            cascadedMembers.add(m);
        }
    }

    private ConstraintOrigin definedIn(Class<?> rootClass, Class<?> hierarchyClass) {
        if (hierarchyClass.equals(rootClass)) {
            return ConstraintOrigin.DEFINED_LOCALLY;
        }
        return ConstraintOrigin.DEFINED_IN_HIERARCHY;
    }

    private <A extends Annotation> Annotation createAnnotationProxy(ConstraintDefWrapper<?> config) {
        Object annotation;
        Class<?> constraintType = config.getConstraintType();
        AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(constraintType);
        for (Map.Entry<String, Object> parameter : config.getParameters().entrySet()) {
            annotationDescriptor.setValue(parameter.getKey(), parameter.getValue());
        }
        try {
            annotation = AnnotationFactory.create(annotationDescriptor);
        }
        catch (RuntimeException e) {
            throw new ValidationException("Unable to create annotation for configured constraint: " + e.getMessage(), (Throwable)e);
        }
        return annotation;
    }

    private <T> Map<Class<?>, List<MetaConstraint<T, ?>>> createEmptyConstraintMap() {
        return new HashMap();
    }
}

