/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.constraints.impl;

import java.math.BigDecimal;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.Min;

public class MinValidatorForString
implements ConstraintValidator<Min, String> {
    private long minValue;

    public void initialize(Min minValue) {
        this.minValue = minValue.value();
    }

    public boolean isValid(String value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        try {
            return new BigDecimal(value).compareTo(BigDecimal.valueOf(this.minValue)) != -1;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

