/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.cfg;

import java.lang.annotation.ElementType;
import javax.validation.ValidationException;
import org.hibernate.validator.util.ReflectionHelper;

public class CascadeDef {
    private final Class<?> beanType;
    private final ElementType elementType;
    private final String property;

    public CascadeDef(Class<?> beanType, String property, ElementType elementType) {
        if (beanType == null) {
            throw new ValidationException("Null is not a valid bean type");
        }
        if (ElementType.FIELD.equals((Object)elementType) || ElementType.METHOD.equals((Object)elementType)) {
            if (property == null || property.length() == 0) {
                throw new ValidationException("A valid property name has to be specified");
            }
            if (!ReflectionHelper.propertyExists(beanType, property, elementType)) {
                throw new ValidationException("The class " + beanType + " does not have a property '" + property + "' with access " + (Object)((Object)elementType));
            }
        }
        this.beanType = beanType;
        this.property = property;
        this.elementType = elementType;
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public Class<?> getBeanType() {
        return this.beanType;
    }

    public String getProperty() {
        return this.property;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CascadeDefinition");
        sb.append("{beanType=").append(this.beanType);
        sb.append(", elementType=").append((Object)this.elementType);
        sb.append(", property='").append(this.property).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

