/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.group;

import java.util.List;
import javax.enterprise.event.Event;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.displayer.client.events.GroupFunctionChangedEvent;
import org.dashbuilder.displayer.client.events.GroupFunctionDeletedEvent;
import org.dashbuilder.displayer.client.widgets.group.ColumnDetailsEditor;
import org.dashbuilder.displayer.client.widgets.group.ColumnFunctionEditor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ColumnFunctionEditorTest {
    @Mock
    ColumnFunctionEditor.View view;
    @Mock
    ColumnDetailsEditor columnDetailsEditor;
    @Mock
    Event<GroupFunctionChangedEvent> changeEvent;
    @Mock
    Event<GroupFunctionDeletedEvent> deleteEvent;
    @Mock
    DataSetMetadata metadata;
    ColumnFunctionEditor presenter;

    @Before
    public void init() {
        this.presenter = new ColumnFunctionEditor(this.view, this.columnDetailsEditor, this.changeEvent, this.deleteEvent);
        Mockito.when((Object)this.metadata.getNumberOfColumns()).thenReturn((Object)3);
        Mockito.when((Object)this.metadata.getColumnId(0)).thenReturn((Object)"column1");
        Mockito.when((Object)this.metadata.getColumnId(1)).thenReturn((Object)"column2");
        Mockito.when((Object)this.metadata.getColumnId(2)).thenReturn((Object)"column3");
        Mockito.when((Object)this.metadata.getColumnType(0)).thenReturn((Object)ColumnType.LABEL);
        Mockito.when((Object)this.metadata.getColumnType(1)).thenReturn((Object)ColumnType.NUMBER);
        Mockito.when((Object)this.metadata.getColumnType(2)).thenReturn((Object)ColumnType.DATE);
        Mockito.when((Object)this.metadata.getColumnType("column1")).thenReturn((Object)ColumnType.LABEL);
        Mockito.when((Object)this.metadata.getColumnType("column2")).thenReturn((Object)ColumnType.NUMBER);
        Mockito.when((Object)this.metadata.getColumnType("column3")).thenReturn((Object)ColumnType.DATE);
    }

    @Test
    public void testViewInitialization() {
        GroupFunction groupFunction = new GroupFunction("column1", "column1", null);
        this.presenter.init(this.metadata, groupFunction, null, "Title", false, false);
        ((ColumnFunctionEditor.View)Mockito.verify((Object)this.view)).setDeleteOptionEnabled(false);
        ((ColumnFunctionEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setDeleteOptionEnabled(true);
        ((ColumnFunctionEditor.View)Mockito.verify((Object)this.view)).setColumnSelectorTitle("Title");
        ((ColumnFunctionEditor.View)Mockito.verify((Object)this.view)).clearColumnSelector();
        ((ColumnFunctionEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).addColumnItem(Mockito.anyString());
        ((ColumnFunctionEditor.View)Mockito.verify((Object)this.view)).setSelectedColumnIndex(0);
        ((ColumnFunctionEditor.View)Mockito.verify((Object)this.view)).setFunctionSelectorEnabled(false);
        ((ColumnFunctionEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setFunctionSelectorEnabled(true);
    }

    @Test
    public void testLabelTarget() {
        GroupFunction groupFunction = new GroupFunction("column1", "column1", null);
        this.presenter.init(this.metadata, groupFunction, ColumnType.LABEL, "Title", true, true);
        ((ColumnFunctionEditor.View)Mockito.verify((Object)this.view)).clearColumnSelector();
        ((ColumnFunctionEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addColumnItem(Mockito.anyString());
        ((ColumnFunctionEditor.View)Mockito.verify((Object)this.view)).setSelectedColumnIndex(0);
        ((ColumnFunctionEditor.View)Mockito.verify((Object)this.view)).setFunctionSelectorEnabled(false);
        ((ColumnFunctionEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setFunctionSelectorEnabled(true);
    }

    @Test
    public void testNumericTarget() {
        GroupFunction groupFunction = new GroupFunction("column1", "column1", null);
        this.presenter.init(this.metadata, groupFunction, ColumnType.NUMBER, "Title", true, true);
        ((ColumnFunctionEditor.View)Mockito.verify((Object)this.view)).clearColumnSelector();
        ((ColumnFunctionEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).addColumnItem(Mockito.anyString());
        ((ColumnFunctionEditor.View)Mockito.verify((Object)this.view)).setSelectedColumnIndex(0);
        ((ColumnFunctionEditor.View)Mockito.verify((Object)this.view)).setFunctionSelectorEnabled(true);
        ((ColumnFunctionEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setVoidFunctionEnabled(true);
        ((ColumnFunctionEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)this.presenter.getSupportedFunctionTypes().size()))).addFunctionItem((AggregateFunctionType)Mockito.any(AggregateFunctionType.class));
        ((ColumnFunctionEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setSelectedFunctionIndex(Mockito.anyInt());
    }

    @Test
    public void testUnspecifiedTarget() {
        GroupFunction groupFunction = new GroupFunction("column1", "column1", AggregateFunctionType.COUNT);
        this.presenter.init(this.metadata, groupFunction, null, "Title", true, true);
        ((ColumnFunctionEditor.View)Mockito.verify((Object)this.view)).clearColumnSelector();
        ((ColumnFunctionEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).addColumnItem(Mockito.anyString());
        ((ColumnFunctionEditor.View)Mockito.verify((Object)this.view)).setSelectedColumnIndex(0);
        List supportedFunctions = this.presenter.getSupportedFunctionTypes();
        ((ColumnFunctionEditor.View)Mockito.verify((Object)this.view)).setFunctionSelectorEnabled(true);
        ((ColumnFunctionEditor.View)Mockito.verify((Object)this.view)).setVoidFunctionEnabled(true);
        ((ColumnFunctionEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)supportedFunctions.size()))).addFunctionItem((AggregateFunctionType)Mockito.any(AggregateFunctionType.class));
        ((ColumnFunctionEditor.View)Mockito.verify((Object)this.view)).setSelectedFunctionIndex(Mockito.anyInt());
    }

    @Test
    public void testSelectColumn() {
        Mockito.when((Object)this.view.getSelectedColumnId()).thenReturn((Object)"column2");
        GroupFunction groupFunction = new GroupFunction("column1", "column1", AggregateFunctionType.COUNT);
        this.presenter.init(this.metadata, groupFunction, null, "Title", true, true);
        this.presenter.onColumnSelected();
        Assert.assertEquals((Object)this.presenter.getGroupFunction().getSourceId(), (Object)"column2");
        ((Event)Mockito.verify(this.changeEvent)).fire(Mockito.any(GroupFunctionChangedEvent.class));
    }

    @Test
    public void testUpdateFunctionsAvailable() {
        GroupFunction groupFunction = new GroupFunction("column1", "column1", AggregateFunctionType.COUNT);
        this.presenter.init(this.metadata, groupFunction, null, "Title", true, true);
        List typeListColumn1 = this.presenter.getSupportedFunctionTypes();
        List typeListLabel = this.presenter.getSupportedFunctionTypes(ColumnType.LABEL);
        Assert.assertEquals((long)typeListColumn1.size(), (long)typeListLabel.size());
        ((ColumnFunctionEditor.View)Mockito.verify((Object)this.view)).clearFunctionSelector();
        ((ColumnFunctionEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)typeListLabel.size()))).addFunctionItem((AggregateFunctionType)Mockito.any(AggregateFunctionType.class));
        Mockito.reset((Object[])new ColumnFunctionEditor.View[]{this.view});
        Mockito.when((Object)this.view.getSelectedColumnId()).thenReturn((Object)"column2");
        this.presenter.onColumnSelected();
        List typeListColumn2 = this.presenter.getSupportedFunctionTypes();
        List typeListNumber = this.presenter.getSupportedFunctionTypes(ColumnType.NUMBER);
        Assert.assertEquals((long)typeListColumn2.size(), (long)typeListNumber.size());
        Assert.assertEquals((Object)this.presenter.getGroupFunction().getSourceId(), (Object)"column2");
        ((ColumnFunctionEditor.View)Mockito.verify((Object)this.view)).clearFunctionSelector();
        ((ColumnFunctionEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)typeListNumber.size()))).addFunctionItem((AggregateFunctionType)Mockito.any(AggregateFunctionType.class));
        ((Event)Mockito.verify(this.changeEvent)).fire(Mockito.any(GroupFunctionChangedEvent.class));
    }

    @Test
    public void testSelectFunction() {
        Mockito.when((Object)this.view.getSelectedFunctionIndex()).thenReturn((Object)1);
        GroupFunction groupFunction = new GroupFunction("column1", "column1", AggregateFunctionType.COUNT);
        this.presenter.init(this.metadata, groupFunction, null, "Title", true, true);
        this.presenter.onFunctionSelected();
        List supportedFunctions = this.presenter.getSupportedFunctionTypes();
        Assert.assertEquals((Object)this.presenter.getGroupFunction().getFunction(), supportedFunctions.get(1));
        ((Event)Mockito.verify(this.changeEvent)).fire(Mockito.any(GroupFunctionChangedEvent.class));
    }

    @Test
    public void testDelete() {
        GroupFunction groupFunction = new GroupFunction("column1", "column1", AggregateFunctionType.COUNT);
        this.presenter.init(this.metadata, groupFunction, null, "Title", true, true);
        this.presenter.delete();
        ((Event)Mockito.verify(this.deleteEvent)).fire(Mockito.any(GroupFunctionDeletedEvent.class));
    }
}

