/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.filter;

import org.dashbuilder.dataset.date.TimeAmount;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.displayer.client.widgets.filter.TimeAmountEditor;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class TimeAmountEditorTest {
    @Mock
    TimeAmountEditor.View timeAmountView;
    @Mock
    Command changeCommand;

    @Test
    public void testViewInitialization() {
        TimeAmount timeAmount = new TimeAmount(10L, DateIntervalType.DAY);
        TimeAmountEditor editor = new TimeAmountEditor(this.timeAmountView);
        editor.init(timeAmount, this.changeCommand);
        ((TimeAmountEditor.View)Mockito.verify((Object)this.timeAmountView)).clearIntervalTypeSelector();
        ((TimeAmountEditor.View)Mockito.verify((Object)this.timeAmountView, (VerificationMode)Mockito.times((int)TimeAmountEditor.INTERVAL_TYPES.size()))).addIntervalTypeItem((DateIntervalType)Mockito.any(DateIntervalType.class));
        ((TimeAmountEditor.View)Mockito.verify((Object)this.timeAmountView)).setSelectedTypeIndex(3);
        ((TimeAmountEditor.View)Mockito.verify((Object)this.timeAmountView)).setQuantity(10L);
    }

    @Test
    public void testNullInitialization() {
        TimeAmountEditor editor = new TimeAmountEditor(this.timeAmountView);
        editor.init(null, this.changeCommand);
        ((TimeAmountEditor.View)Mockito.verify((Object)this.timeAmountView)).clearIntervalTypeSelector();
        ((TimeAmountEditor.View)Mockito.verify((Object)this.timeAmountView, (VerificationMode)Mockito.times((int)TimeAmountEditor.INTERVAL_TYPES.size()))).addIntervalTypeItem((DateIntervalType)Mockito.any(DateIntervalType.class));
        ((TimeAmountEditor.View)Mockito.verify((Object)this.timeAmountView)).setSelectedTypeIndex(7);
        ((TimeAmountEditor.View)Mockito.verify((Object)this.timeAmountView)).setQuantity(0L);
    }

    @Test
    public void testDecreaseQuantity() {
        TimeAmount timeAmount = new TimeAmount(10L, DateIntervalType.DAY);
        TimeAmountEditor timeAmountEditor = new TimeAmountEditor(this.timeAmountView);
        timeAmountEditor.init(timeAmount, this.changeCommand);
        timeAmountEditor.decreaseQuantity();
        ((TimeAmountEditor.View)Mockito.verify((Object)this.timeAmountView)).setQuantity(9L);
        ((Command)Mockito.verify((Object)this.changeCommand)).execute();
        Assert.assertEquals((long)timeAmount.getQuantity(), (long)9L);
    }

    @Test
    public void testIncreaseQuantity() {
        TimeAmount timeAmount = new TimeAmount(10L, DateIntervalType.DAY);
        TimeAmountEditor timeAmountEditor = new TimeAmountEditor(this.timeAmountView);
        timeAmountEditor.init(timeAmount, this.changeCommand);
        timeAmountEditor.increaseQuantity();
        ((TimeAmountEditor.View)Mockito.verify((Object)this.timeAmountView)).setQuantity(11L);
        ((Command)Mockito.verify((Object)this.changeCommand)).execute();
        Assert.assertEquals((long)timeAmount.getQuantity(), (long)11L);
    }
}

