/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.filter;

import org.dashbuilder.displayer.client.widgets.filter.NumberParameterEditor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class NumberParameterEditorTest {
    NumberParameterEditor presenter;
    @Mock
    NumberParameterEditor.View view;
    @Mock
    Command changedEvent;

    @Before
    public void init() {
        this.presenter = new NumberParameterEditor(this.view);
    }

    @Test
    public void testShowValue() {
        this.presenter.setValue((Number)10.0);
        ((NumberParameterEditor.View)Mockito.verify((Object)this.view)).setValue("10.0");
    }

    @Test
    public void testParseVoidInput() {
        Mockito.when((Object)this.view.getValue()).thenReturn((Object)"");
        this.presenter.valueChanged();
        Assert.assertNull((Object)this.presenter.getValue());
        ((NumberParameterEditor.View)Mockito.verify((Object)this.view)).error();
    }

    @Test
    public void testParseSingleInput() {
        Mockito.when((Object)this.view.getValue()).thenReturn((Object)"3");
        this.presenter.valueChanged();
        ((NumberParameterEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).error();
        Assert.assertEquals((Object)this.presenter.getValue(), (Object)3.0);
    }

    @Test
    public void testInputError() {
        Mockito.when((Object)this.view.getValue()).thenReturn((Object)"a");
        this.presenter.valueChanged();
        Assert.assertNull((Object)this.presenter.getValue());
        ((NumberParameterEditor.View)Mockito.verify((Object)this.view)).error();
    }
}

