/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.displayer.DisplayerType;
import org.dashbuilder.displayer.client.RendererLibrary;
import org.dashbuilder.displayer.client.RendererManager;
import org.dashbuilder.displayer.client.resources.i18n.CommonConstants;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class RendererManagerTest {
    private static final String REND2_NAME = "renderer 2";
    private static final String REND1_NAME = "renderer 1";
    private static final String REND2_UUID = "rend2";
    private static final String REND1_UUID = "rend1";
    private static final String DEFAULT_REND_FOR_BARCHART_UUID = "rend1";
    @Mock
    SyncBeanManager beanManager;
    @Mock
    DisplayerSettings displayerSettings;
    @InjectMocks
    RendererManager rendererManager;
    int totalBeans;

    @Before
    public void setUp() {
        this.mockConstants();
        HashMap<DisplayerType, List<DisplayerSubType>> typesAndSubTypes1 = new HashMap<DisplayerType, List<DisplayerSubType>>();
        typesAndSubTypes1.put(DisplayerType.BARCHART, Arrays.asList(DisplayerSubType.BAR));
        typesAndSubTypes1.put(DisplayerType.AREACHART, Arrays.asList(DisplayerSubType.AREA));
        typesAndSubTypes1.put(DisplayerType.LINECHART, Arrays.asList(DisplayerSubType.LINE));
        HashMap<DisplayerType, List<DisplayerSubType>> typesAndSubTypes2 = new HashMap<DisplayerType, List<DisplayerSubType>>();
        typesAndSubTypes2.put(DisplayerType.LINECHART, Arrays.asList(DisplayerSubType.LINE, DisplayerSubType.SMOOTH));
        typesAndSubTypes2.put(DisplayerType.BARCHART, Arrays.asList(DisplayerSubType.BAR, DisplayerSubType.BAR_STACKED));
        List<SyncBeanDef> rendererLibrariesBeans = Arrays.asList(this.mockSyncBeanForRendererLib(REND1_NAME, "rend1", Arrays.asList(DisplayerType.BARCHART), typesAndSubTypes1), this.mockSyncBeanForRendererLib(REND2_NAME, REND2_UUID, Collections.emptyList(), typesAndSubTypes2));
        this.totalBeans = rendererLibrariesBeans.size();
        Mockito.when((Object)this.beanManager.lookupBeans(RendererLibrary.class)).thenReturn(rendererLibrariesBeans);
        this.rendererManager.init();
    }

    @Test
    public void renderersForType2Test() {
        List renderersForType = this.rendererManager.getRenderersForType(null, null);
        Assert.assertEquals((long)this.totalBeans, (long)renderersForType.size());
        renderersForType = this.rendererManager.getRenderersForType(DisplayerType.BARCHART, null);
        Assert.assertEquals((long)2L, (long)renderersForType.size());
        renderersForType = this.rendererManager.getRenderersForType(DisplayerType.AREACHART, DisplayerSubType.AREA);
        Assert.assertEquals((long)1L, (long)renderersForType.size());
        renderersForType = this.rendererManager.getRenderersForType(DisplayerType.BARCHART, DisplayerSubType.BAR);
        Assert.assertEquals((long)2L, (long)renderersForType.size());
        renderersForType = this.rendererManager.getRenderersForType(DisplayerType.MAP, null);
        Assert.assertEquals((long)0L, (long)renderersForType.size());
        renderersForType = this.rendererManager.getRenderersForType(DisplayerType.MAP, DisplayerSubType.MAP_REGIONS);
        Assert.assertEquals((long)0L, (long)renderersForType.size());
    }

    @Test
    public void renderersForType2SubTypesTest() {
        List renderersForSubType = this.rendererManager.getRenderersForType(null, DisplayerSubType.AREA);
        Assert.assertEquals((long)1L, (long)renderersForSubType.size());
        renderersForSubType = this.rendererManager.getRenderersForType(null, DisplayerSubType.LINE);
        Assert.assertEquals((long)2L, (long)renderersForSubType.size());
        renderersForSubType = this.rendererManager.getRenderersForType(null, DisplayerSubType.MAP_REGIONS);
        Assert.assertEquals((long)0L, (long)renderersForSubType.size());
    }

    @Test
    public void rendererForTypeTest() {
        List renderers = this.rendererManager.getRenderers();
        Assert.assertEquals((long)this.totalBeans, (long)renderers.size());
        Assert.assertEquals((long)2L, (long)this.rendererManager.getRenderersForType(DisplayerType.BARCHART).size());
        Assert.assertEquals((long)1L, (long)this.rendererManager.getRenderersForType(DisplayerType.AREACHART).size());
    }

    @Test
    public void rendererForSubTypeTest() {
        Assert.assertEquals((long)2L, (long)this.rendererManager.getRenderersForType(DisplayerType.BARCHART).size());
        Assert.assertEquals((long)1L, (long)this.rendererManager.getRenderersForType(DisplayerType.AREACHART).size());
    }

    @Test
    public void rendererByNameTest() {
        Assert.assertNotNull((Object)this.rendererManager.getRendererByName(REND1_NAME));
    }

    @Test(expected=RuntimeException.class)
    public void rendererByNameNotFoundTest() {
        Assert.assertNotNull((Object)this.rendererManager.getRendererByName("NO NAME"));
    }

    @Test
    public void rendererByUUIDTest() {
        Assert.assertNotNull((Object)this.rendererManager.getRendererByUUID("rend1"));
    }

    @Test(expected=RuntimeException.class)
    public void rendererByUUIDNotFoundTest() {
        Assert.assertNotNull((Object)this.rendererManager.getRendererByUUID("NO UUID"));
    }

    @Test
    public void typeSupportedTest() {
        Assert.assertTrue((boolean)this.rendererManager.isTypeSupported(DisplayerType.BARCHART));
        Assert.assertTrue((!this.rendererManager.isTypeSupported(DisplayerType.MAP) ? 1 : 0) != 0);
    }

    @Test
    public void rendererByDisplayerTest() {
        DisplayerSettings settings = (DisplayerSettings)Mockito.mock(DisplayerSettings.class);
        Mockito.when((Object)settings.getRenderer()).thenReturn((Object)"rend1");
        Mockito.when((Object)settings.getType()).thenReturn((Object)DisplayerType.BARCHART);
        Mockito.when((Object)settings.getSubtype()).thenReturn((Object)DisplayerSubType.BAR);
        RendererLibrary lib = this.rendererManager.getRendererForDisplayer(settings);
        Assert.assertNotNull((Object)lib);
        Assert.assertEquals((Object)"rend1", (Object)lib.getUUID());
    }

    @Test
    public void rendererByDisplayerWithoutUUIDTest() {
        DisplayerSettings settings = (DisplayerSettings)Mockito.mock(DisplayerSettings.class);
        Mockito.when((Object)settings.getType()).thenReturn((Object)DisplayerType.BARCHART);
        Mockito.when((Object)settings.getSubtype()).thenReturn((Object)DisplayerSubType.BAR);
        RendererLibrary lib = this.rendererManager.getRendererForDisplayer(settings);
        Assert.assertNotNull((Object)lib);
        Assert.assertEquals((Object)"rend1", (Object)lib.getUUID());
    }

    @Test(expected=RuntimeException.class)
    public void rendererByDisplayerTypeNotSupportedTest() {
        DisplayerSettings settings = (DisplayerSettings)Mockito.mock(DisplayerSettings.class);
        Mockito.when((Object)settings.getType()).thenReturn((Object)DisplayerType.MAP);
        Mockito.when((Object)settings.getSubtype()).thenReturn((Object)DisplayerSubType.MAP_MARKERS);
        this.rendererManager.getRendererForDisplayer(settings);
    }

    @Test
    public void defaultRendererTest() {
        Assert.assertNotNull((Object)this.rendererManager.getDefaultRenderer(DisplayerType.BARCHART));
        Assert.assertNull((Object)this.rendererManager.getDefaultRenderer(DisplayerType.LINECHART));
    }

    private SyncBeanDef<RendererLibrary> mockSyncBeanForRendererLib(String name, String uuid, List<DisplayerType> defaultTypes, Map<DisplayerType, List<DisplayerSubType>> typesAndSubTypes) {
        SyncBeanDef libBean = (SyncBeanDef)Mockito.mock(SyncBeanDef.class);
        RendererLibrary lib = (RendererLibrary)Mockito.mock(RendererLibrary.class);
        Mockito.when((Object)lib.getName()).thenReturn((Object)name);
        Mockito.when((Object)lib.getUUID()).thenReturn((Object)uuid);
        List supportedTypesList = typesAndSubTypes.keySet().stream().collect(Collectors.toList());
        Mockito.when((Object)lib.getSupportedTypes()).thenReturn(supportedTypesList);
        typesAndSubTypes.forEach((type, subTypes) -> Mockito.when((Object)lib.getSupportedSubtypes(type)).thenReturn(subTypes));
        defaultTypes.forEach(type -> Mockito.when((Object)lib.isDefault(type)).thenReturn((Object)true));
        Mockito.when((Object)libBean.getInstance()).thenReturn((Object)lib);
        return libBean;
    }

    private void mockConstants() {
        this.rendererManager.i18n = (CommonConstants)Mockito.mock(CommonConstants.class, invocation -> Mockito.RETURNS_DEFAULTS.answer(invocation));
    }
}

