/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.csv;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dashbuilder.dataprovider.csv.CSVFileStorage;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.def.CSVDataSetDef;
import org.dashbuilder.dataset.def.DataColumnDef;

public class CSVParser {
    public static final String DATE_FORMAT_EPOCH = "epoch";
    protected transient Map<String, DateFormat> _dateFormatMap = new HashMap<String, DateFormat>();
    protected transient Map<String, DecimalFormat> _numberFormatMap = new HashMap<String, DecimalFormat>();
    protected CSVDataSetDef dataSetDef;
    protected CSVFileStorage csvStorage;

    public CSVParser(CSVDataSetDef def, CSVFileStorage csvFileStorage) {
        this.dataSetDef = def;
        this.csvStorage = csvFileStorage;
    }

    protected boolean isColumnIncluded(String columnId) {
        if (this.dataSetDef.isAllColumnsEnabled()) {
            return true;
        }
        if (this.dataSetDef.getColumns() == null) {
            return false;
        }
        return this.dataSetDef.getColumnById(columnId) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSet load() throws Exception {
        try (InputStream is = this.getCSVInputStream();){
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            CSVReader csvReader = new CSVReader((Reader)br, this.dataSetDef.getSeparatorChar().charValue(), this.dataSetDef.getQuoteChar().charValue(), this.dataSetDef.getEscapeChar().charValue());
            String[] header = csvReader.readNext();
            if (header == null) {
                throw new IOException("CSV has no header: " + this.dataSetDef);
            }
            String[] firstRow = csvReader.readNext();
            if (firstRow == null || firstRow.length < header.length) {
                firstRow = null;
            }
            ArrayList<Integer> _columnIdxs = new ArrayList<Integer>();
            DataSet dataSet = DataSetFactory.newEmptyDataSet();
            for (int i = 0; i < header.length; ++i) {
                String columnId = header[i];
                if (!this.isColumnIncluded(columnId)) continue;
                ColumnType type = ColumnType.LABEL;
                if (firstRow != null) {
                    type = this.calculateType(columnId, firstRow[i]);
                }
                dataSet.addColumn(columnId, type);
                _columnIdxs.add(i);
            }
            if (firstRow != null) {
                Object[] _rowArray = new Object[dataSet.getColumns().size()];
                this._processLine(dataSet, _rowArray, firstRow, _columnIdxs);
                dataSet.setValuesAt(dataSet.getRowCount(), _rowArray);
                String[] _line = csvReader.readNext();
                while (_line != null && _line.length == header.length) {
                    this._processLine(dataSet, _rowArray, _line, _columnIdxs);
                    dataSet.setValuesAt(dataSet.getRowCount(), _rowArray);
                    _line = csvReader.readNext();
                }
            }
            DataSet dataSet2 = dataSet;
            return dataSet2;
        }
    }

    protected InputStream getCSVInputStream() throws Exception {
        InputStream is;
        File f;
        String url = this.dataSetDef.getFileURL();
        if (!StringUtils.isBlank((CharSequence)url)) {
            return new URL(url).openStream();
        }
        String path = this.dataSetDef.getFilePath();
        if (!StringUtils.isBlank((CharSequence)path) && (f = new File(path)).exists()) {
            return new FileInputStream(f);
        }
        if (this.csvStorage != null && (is = this.csvStorage.getCSVInputStream(this.dataSetDef)) != null) {
            return is;
        }
        throw new IllegalArgumentException("CSV content not found: " + this.dataSetDef);
    }

    protected ColumnType calculateType(String columnId, String value) {
        DataColumnDef column = this.dataSetDef.getColumnById(columnId);
        if (column != null) {
            return column.getColumnType();
        }
        try {
            DateFormat dateFormat = this.getDateFormat(columnId);
            dateFormat.parse(value);
            return ColumnType.DATE;
        }
        catch (Exception e) {
            try {
                DecimalFormat numberFormat = this.getNumberFormat(columnId);
                numberFormat.parse(value);
                return ColumnType.NUMBER;
            }
            catch (Exception ee) {
                return ColumnType.LABEL;
            }
        }
    }

    protected void _processLine(DataSet dataSet, Object[] row, String[] line, List<Integer> columnIdxs) throws Exception {
        List columns = dataSet.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            DataColumn column = dataSet.getColumnByIndex(i);
            int columnIdx = columnIdxs.get(i);
            String valueStr = line[columnIdx];
            row[i] = !StringUtils.isBlank((CharSequence)valueStr) ? this.parseValue(column, valueStr) : null;
        }
    }

    protected Object parseValue(DataColumn column, String value) throws Exception {
        ColumnType type = column.getColumnType();
        try {
            if (type.equals((Object)ColumnType.DATE)) {
                String pattern = this.dataSetDef.getPattern(column.getId());
                if (pattern != null && DATE_FORMAT_EPOCH.equalsIgnoreCase(pattern)) {
                    Double _epoch = Double.parseDouble(value);
                    return new Date(_epoch.longValue() * 1000L);
                }
                DateFormat dateFormat = this.getDateFormat(column.getId());
                return dateFormat.parse(value);
            }
            if (type.equals((Object)ColumnType.NUMBER)) {
                DecimalFormat numberFormat = this.getNumberFormat(column.getId());
                return numberFormat.parse(value).doubleValue();
            }
            return value;
        }
        catch (ParseException e) {
            String msg = "Error parsing value: " + value + ", " + e.getMessage() + ". Check column's data type consistency!";
            throw new Exception(msg);
        }
    }

    protected DateFormat getDateFormat(String columnId) {
        DateFormat format = this._dateFormatMap.get(columnId);
        if (format == null) {
            format = new SimpleDateFormat(this.dataSetDef.getDatePattern(columnId));
            this._dateFormatMap.put(columnId, format);
        }
        return format;
    }

    protected DecimalFormat getNumberFormat(String columnId) {
        DecimalFormat format = this._numberFormatMap.get(columnId);
        if (format == null) {
            DecimalFormatSymbols numberSymbols = new DecimalFormatSymbols();
            numberSymbols.setGroupingSeparator(this.dataSetDef.getNumberGroupSeparator(columnId));
            numberSymbols.setDecimalSeparator(this.dataSetDef.getNumberDecimalSeparator(columnId));
            format = new DecimalFormat(this.dataSetDef.getNumberPattern(columnId), numberSymbols);
            this._numberFormatMap.put(columnId, format);
        }
        return format;
    }
}

