/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.csv;

import java.net.URL;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetManager;
import org.dashbuilder.dataset.backend.DataSetDefJSONMarshaller;
import org.dashbuilder.dataset.def.CSVDataSetDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.test.ShrinkWrapHelper;
import org.fest.assertions.api.Assertions;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class CSVDataSetDefJSONTest {
    @Inject
    DataSetDefJSONMarshaller jsonMarshaller;
    @Inject
    DataSetManager dataSetManager;

    @Deployment
    public static Archive<?> createTestArchive() {
        return ShrinkWrapHelper.createJavaArchive().addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void testParseCSVJson() throws Exception {
        URL fileURL = Thread.currentThread().getContextClassLoader().getResource("expenseReports.dset");
        String json = IOUtils.toString((URL)fileURL);
        DataSetDef def = this.jsonMarshaller.fromJson(json);
        Assertions.assertThat((Object)def.getProvider()).isEqualTo((Object)DataSetProviderType.CSV);
        Assertions.assertThat((boolean)def.isPublic()).isEqualTo(true);
        Assertions.assertThat((boolean)def.isPushEnabled()).isEqualTo(true);
        Assertions.assertThat((Integer)def.getPushMaxSize()).isEqualTo(1024);
        CSVDataSetDef csvDef = (CSVDataSetDef)def;
        Assertions.assertThat((Character)csvDef.getSeparatorChar()).isEqualTo(';');
        Assertions.assertThat((Character)csvDef.getEscapeChar()).isEqualTo('\\');
        Assertions.assertThat((Character)csvDef.getQuoteChar()).isEqualTo('\"');
        Assertions.assertThat((String)csvDef.getDatePattern()).isEqualTo((Object)"MM-dd-yyyy");
        Assertions.assertThat((String)csvDef.getNumberPattern()).isEqualTo((Object)"#,###.##");
        Assertions.assertThat((String)csvDef.getPattern("date")).isEqualTo((Object)"MM-dd-yyyy");
        Assertions.assertThat((String)csvDef.getPattern("amount")).isEqualTo((Object)"#,###.##");
        Assertions.assertThat((Object)csvDef.getColumnById("id").getColumnType()).isEqualTo((Object)ColumnType.LABEL);
        Assertions.assertThat((Object)csvDef.getColumnById("amount").getColumnType()).isEqualTo((Object)ColumnType.NUMBER);
        Assertions.assertThat((Object)csvDef.getColumnById("date").getColumnType()).isEqualTo((Object)ColumnType.DATE);
    }
}

