/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.uuid;

import javax.inject.Inject;
import org.dashbuilder.dataset.uuid.UUIDGenerator;
import org.dashbuilder.test.ShrinkWrapHelper;
import org.fest.assertions.api.Assertions;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class UUIDGeneratorTest {
    @Inject
    private UUIDGenerator uuidGenerator;

    @Deployment
    public static Archive<?> createTestArchive() {
        return ShrinkWrapHelper.createJavaArchive().addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void testUUIDLength() {
        String uuid = this.uuidGenerator.newUuidBase64();
        Assertions.assertThat((int)uuid.length()).isEqualTo(22);
    }

    @Test
    public void testURLSafe() {
        String uuid = this.uuidGenerator.newUuidBase64();
        Assertions.assertThat((boolean)uuid.contains("=")).isFalse();
        Assertions.assertThat((boolean)uuid.contains("/")).isFalse();
        Assertions.assertThat((boolean)uuid.contains("+")).isFalse();
        Assertions.assertThat((boolean)uuid.contains("&")).isFalse();
    }

    @Test
    public void testDecoding() {
        String uuid = this.uuidGenerator.newUuid();
        String base64 = this.uuidGenerator.uuidToBase64(uuid);
        String back = this.uuidGenerator.uuidFromBase64(base64);
        Assertions.assertThat((String)back).isEqualTo((Object)uuid);
    }
}

