/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.date;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.dashbuilder.dataset.backend.date.DateUtils;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.group.GroupStrategy;
import org.fest.assertions.api.Assertions;
import org.junit.Test;

public class DateUtilsTest {
    public static final SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Test
    public void testMonthFormat() throws Exception {
        String result = DateUtils.ensureTwoDigits((String)"2015-M1", (DateIntervalType)DateIntervalType.MONTH);
        Assertions.assertThat((String)result).isEqualTo((Object)"2015-01");
        result = DateUtils.ensureTwoDigits((String)"2015-M12", (DateIntervalType)DateIntervalType.MONTH);
        Assertions.assertThat((String)result).isEqualTo((Object)"2015-12");
    }

    @Test
    public void testDayFormat() throws Exception {
        String result = DateUtils.ensureTwoDigits((String)"2015-M1-D23", (DateIntervalType)DateIntervalType.DAY);
        Assertions.assertThat((String)result).isEqualTo((Object)"2015-01-23");
        result = DateUtils.ensureTwoDigits((String)"2015-M11-D01", (DateIntervalType)DateIntervalType.DAY);
        Assertions.assertThat((String)result).isEqualTo((Object)"2015-11-01");
    }

    @Test
    public void testHourFormat() throws Exception {
        String result = DateUtils.ensureTwoDigits((String)"2015-M1-D23 H3", (DateIntervalType)DateIntervalType.HOUR);
        Assertions.assertThat((String)result).isEqualTo((Object)"2015-01-23 03");
        result = DateUtils.ensureTwoDigits((String)"2015-M11-D01 H23", (DateIntervalType)DateIntervalType.HOUR);
        Assertions.assertThat((String)result).isEqualTo((Object)"2015-11-01 23");
    }

    @Test
    public void testMinuteFormat() throws Exception {
        String result = DateUtils.ensureTwoDigits((String)"2015-M1-D23 H3:m0", (DateIntervalType)DateIntervalType.MINUTE);
        Assertions.assertThat((String)result).isEqualTo((Object)"2015-01-23 03:00");
        result = DateUtils.ensureTwoDigits((String)"2015-M11-D01 H23:m59", (DateIntervalType)DateIntervalType.MINUTE);
        Assertions.assertThat((String)result).isEqualTo((Object)"2015-11-01 23:59");
    }

    @Test
    public void testSecondsFormat() throws Exception {
        String result = DateUtils.ensureTwoDigits((String)"2015-M1-D23 H3:m0:s0", (DateIntervalType)DateIntervalType.SECOND);
        Assertions.assertThat((String)result).isEqualTo((Object)"2015-01-23 03:00:00");
        result = DateUtils.ensureTwoDigits((String)"2015-M11-D01 H23:m59:s59", (DateIntervalType)DateIntervalType.SECOND);
        Assertions.assertThat((String)result).isEqualTo((Object)"2015-11-01 23:59:59");
    }

    @Test
    public void testParseSecond() throws Exception {
        Date result = DateUtils.parseDate((DateIntervalType)DateIntervalType.SECOND, (GroupStrategy)GroupStrategy.DYNAMIC, (Object)"2015-1-23 3:0:1");
        Assertions.assertThat((String)df.format(result)).isEqualTo((Object)"2015-01-23 03:00:01");
    }

    @Test
    public void testParseMinute() throws Exception {
        Date result = DateUtils.parseDate((DateIntervalType)DateIntervalType.MINUTE, (GroupStrategy)GroupStrategy.DYNAMIC, (Object)"2015-1-23 3:1");
        Assertions.assertThat((String)df.format(result)).isEqualTo((Object)"2015-01-23 03:01:00");
    }

    @Test
    public void testParseHour() throws Exception {
        Date result = DateUtils.parseDate((DateIntervalType)DateIntervalType.HOUR, (GroupStrategy)GroupStrategy.DYNAMIC, (Object)"2015-1-23 3");
        Assertions.assertThat((String)df.format(result)).isEqualTo((Object)"2015-01-23 03:00:00");
    }

    @Test
    public void testParseDay() throws Exception {
        Date result = DateUtils.parseDate((DateIntervalType)DateIntervalType.DAY, (GroupStrategy)GroupStrategy.DYNAMIC, (Object)"2015-1-23");
        Assertions.assertThat((String)df.format(result)).isEqualTo((Object)"2015-01-23 00:00:00");
    }

    @Test
    public void testParseMonth() throws Exception {
        Date result = DateUtils.parseDate((DateIntervalType)DateIntervalType.MONTH, (GroupStrategy)GroupStrategy.DYNAMIC, (Object)"2015-1");
        Assertions.assertThat((String)df.format(result)).isEqualTo((Object)"2015-01-01 00:00:00");
    }
}

