/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset;

import javax.inject.Inject;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.DataSetFormatter;
import org.dashbuilder.dataset.DataSetManager;
import org.dashbuilder.dataset.RawDataSetSamples;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.dashbuilder.test.ShrinkWrapHelper;
import org.fest.assertions.api.Assertions;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class DataSetTrimTest {
    public static final String EXPENSE_REPORTS = "expense_reports";
    @Inject
    public DataSetManager dataSetManager;
    @Inject
    public DataSetFormatter dataSetFormatter;

    @Deployment
    public static Archive<?> createTestArchive() {
        return ShrinkWrapHelper.createJavaArchive().addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void setUp() throws Exception {
        DataSet dataSet = RawDataSetSamples.EXPENSE_REPORTS.toDataSet();
        dataSet.setUUID(EXPENSE_REPORTS);
        this.dataSetManager.registerDataSet(dataSet);
        this.dataSetFormatter = new DataSetFormatter();
    }

    @Test
    public void testTrim() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EXPENSE_REPORTS)).rowNumber(10)).buildLookup());
        Assertions.assertThat((int)result.getColumns().size()).isEqualTo(6);
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(10);
    }

    @Test
    public void testDuplicatedColumns() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EXPENSE_REPORTS)).column("city", "city1")).column("city", "city2")).rowNumber(10)).buildLookup());
        Assertions.assertThat((int)result.getColumns().size()).isEqualTo(2);
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(10);
    }
}

