/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset;

import javax.inject.Inject;
import org.dashbuilder.dataset.Assertions;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.DataSetFormatter;
import org.dashbuilder.dataset.DataSetManager;
import org.dashbuilder.dataset.RawDataSetSamples;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.test.ShrinkWrapHelper;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class DataSetSortTest {
    public static final String EXPENSE_REPORTS = "expense_reports_dataset";
    @Inject
    DataSetManager dataSetManager;
    protected DataSet dataSet;
    protected DataSetFormatter dataSetFormatter;

    @Deployment
    public static Archive<?> createTestArchive() {
        return ShrinkWrapHelper.createJavaArchive().addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void setUp() throws Exception {
        this.dataSet = RawDataSetSamples.EXPENSE_REPORTS.toDataSet();
        this.dataSet.setUUID(EXPENSE_REPORTS);
        this.dataSetManager.registerDataSet(this.dataSet);
        this.dataSetFormatter = new DataSetFormatter();
    }

    @Test
    public void testSortByString() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EXPENSE_REPORTS)).sort("city", SortOrder.ASCENDING)).buildLookup());
        Assertions.assertDataSetValue(result, 0, 1, "Barcelona");
        Assertions.assertDataSetValue(result, 6, 1, "Brno");
        Assertions.assertDataSetValue(result, 15, 1, "London");
        Assertions.assertDataSetValue(result, 22, 1, "Madrid");
        Assertions.assertDataSetValue(result, 28, 1, "Raleigh");
        Assertions.assertDataSetValue(result, 41, 1, "Westford");
    }

    @Test
    public void testSortByNumber() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EXPENSE_REPORTS)).sort("amount", SortOrder.ASCENDING)).buildLookup());
        Assertions.assertDataSetValue(result, 0, 0, "23.00");
        Assertions.assertDataSetValue(result, 49, 0, "2.00");
    }

    @Test
    public void testSortByDate() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EXPENSE_REPORTS)).sort("date", SortOrder.ASCENDING)).buildLookup());
        Assertions.assertDataSetValue(result, 0, 0, "50.00");
        Assertions.assertDataSetValue(result, 49, 0, "1.00");
    }

    @Test
    public void testSortMultiple() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EXPENSE_REPORTS)).sort("city", SortOrder.ASCENDING)).sort("department", SortOrder.ASCENDING)).sort("amount", SortOrder.DESCENDING)).buildLookup());
        Assertions.assertDataSetValue(result, 0, 0, "2.00");
        Assertions.assertDataSetValue(result, 5, 0, "6.00");
        Assertions.assertDataSetValue(result, 6, 0, "19.00");
        Assertions.assertDataSetValue(result, 49, 0, "28.00");
    }

    @Test
    public void testGroupandSort() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EXPENSE_REPORTS)).group("department")).column("department")).column("amount", AggregateFunctionType.SUM, "total")).sort("total", SortOrder.DESCENDING)).buildLookup());
        Assertions.assertDataSetValues(result, this.dataSetFormatter, new String[][]{{"Engineering", "7,650.16"}, {"Management", "6,017.47"}, {"Support", "3,345.60"}, {"Sales", "3,213.53"}, {"Services", "2,504.50"}}, 0);
    }

    private void printDataSet(DataSet dataSet) {
        System.out.print(this.dataSetFormatter.formatDataSet(dataSet, "{", "}", ",\n", "\"", "\"", ", ") + "\n\n");
    }
}

