/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset;

import javax.inject.Inject;
import org.dashbuilder.dataset.Assertions;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.DataSetFormatter;
import org.dashbuilder.dataset.DataSetManager;
import org.dashbuilder.dataset.RawDataSetSamples;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.dashbuilder.test.ShrinkWrapHelper;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class DataSetNestedGroupTest {
    public static final String EXPENSE_REPORTS = "expense_reports";
    @Inject
    public DataSetManager dataSetManager;
    @Inject
    public DataSetFormatter dataSetFormatter;

    @Deployment
    public static Archive<?> createTestArchive() {
        return ShrinkWrapHelper.createJavaArchive().addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void setUp() throws Exception {
        DataSet dataSet = RawDataSetSamples.EXPENSE_REPORTS.toDataSet();
        dataSet.setUUID(EXPENSE_REPORTS);
        this.dataSetManager.registerDataSet(dataSet);
        this.dataSetFormatter = new DataSetFormatter();
    }

    @Test
    public void testGroupSelectionFilter() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EXPENSE_REPORTS)).filter("amount", new ColumnFilter[]{FilterFactory.greaterThan((Comparable)Integer.valueOf(500))})).group("department")).select(new String[]{"Engineering"})).group("city")).select(new String[]{"Westford"})).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(1);
        Assertions.assertDataSetValue(result, 0, 0, "26.00");
    }

    @Test
    public void testNestedGroupFromMultipleSelection() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EXPENSE_REPORTS)).group("department", "Department")).select(new String[]{"Services", "Engineering"})).group("city", "City")).column("city")).column(AggregateFunctionType.COUNT, "Occurrences")).column("amount", AggregateFunctionType.MIN, "min")).column("amount", AggregateFunctionType.MAX, "max")).column("amount", AggregateFunctionType.AVERAGE, "average")).column("amount", AggregateFunctionType.SUM, "total")).sort("city", "asc")).buildLookup());
        Assertions.assertDataSetValues(result, this.dataSetFormatter, new String[][]{{"Barcelona", "6.00", "120.35", "1,100.10", "485.52", "2,913.14"}, {"Brno", "4.00", "159.01", "800.24", "364.86", "1,459.45"}, {"London", "3.00", "333.45", "868.45", "535.40", "1,606.20"}, {"Madrid", "2.00", "800.80", "911.11", "855.96", "1,711.91"}, {"Raleigh", "4.00", "209.55", "401.40", "284.38", "1,137.53"}, {"Westford", "5.00", "1.10", "600.34", "265.29", "1,326.43"}}, 0);
    }

    @Test
    public void testNestedGroupRequiresSelection() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EXPENSE_REPORTS)).group("department", "Department")).column("department")).group("city", "city")).sort("department", "asc")).buildLookup());
        Assertions.assertDataSetValues(result, this.dataSetFormatter, new String[][]{{"Engineering"}, {"Management"}, {"Sales"}, {"Services"}, {"Support"}}, 0);
    }

    @Test
    public void testNoResultsSelection() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EXPENSE_REPORTS)).group("employee")).select(new String[]{"Jerri Preble"})).group("department")).select(new String[]{"Engineering"})).group("city")).select(new String[]{"Westford"})).group("date")).fixed(DateIntervalType.MONTH, true)).column("date")).column("amount", AggregateFunctionType.SUM, "total")).buildLookup());
        Assertions.assertDataSetValues(result, this.dataSetFormatter, new String[][]{{"1", "0.00"}, {"2", "0.00"}, {"3", "0.00"}, {"4", "0.00"}, {"5", "0.00"}, {"6", "0.00"}, {"7", "0.00"}, {"8", "0.00"}, {"9", "0.00"}, {"10", "0.00"}, {"11", "0.00"}, {"12", "0.00"}}, 0);
    }

    @Test
    public void testThreeNestedLevels() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EXPENSE_REPORTS)).group("department")).select(new String[]{"Services", "Engineering"})).group("city")).select(new String[]{"Madrid", "Barcelona"})).group("date")).fixed(DateIntervalType.MONTH, true)).column("date")).column("amount", AggregateFunctionType.SUM, "total")).buildLookup());
        Assertions.assertDataSetValues(result, this.dataSetFormatter, new String[][]{{"1", "0.00"}, {"2", "0.00"}, {"3", "0.00"}, {"4", "0.00"}, {"5", "0.00"}, {"6", "911.11"}, {"7", "800.80"}, {"8", "152.25"}, {"9", "300.00"}, {"10", "340.34"}, {"11", "900.10"}, {"12", "1,220.45"}}, 0);
    }

    @Test
    public void testGroupByQuarter() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EXPENSE_REPORTS)).group("date")).fixed(DateIntervalType.QUARTER, true)).select(new String[]{"1"})).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(14);
    }

    private void printDataSet(DataSet dataSet) {
        System.out.print(this.dataSetFormatter.formatDataSet(dataSet, "{", "}", ",\n", "\"", "\"", ", ") + "\n\n");
    }
}

