/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset;

import javax.inject.Inject;
import org.dashbuilder.dataset.Assertions;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFormatter;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.dataset.DataSetManager;
import org.dashbuilder.dataset.RawDataSetSamples;
import org.dashbuilder.test.ShrinkWrapHelper;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class DataSetLookupConstraintsTest {
    public static final String EXPENSE_REPORTS = "expense_reports_dataset";
    @Inject
    DataSetManager dataSetManager;
    @Inject
    DataSetFormatter dataSetFormatter;
    protected DataSet dataSet;

    @Deployment
    public static Archive<?> createTestArchive() {
        return ShrinkWrapHelper.createJavaArchive().addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void setUp() throws Exception {
        this.dataSet = RawDataSetSamples.EXPENSE_REPORTS.toDataSet();
        this.dataSet.setUUID(EXPENSE_REPORTS);
        this.dataSetManager.registerDataSet(this.dataSet);
        this.dataSetFormatter = new DataSetFormatter();
    }

    @Test
    public void testEmptyConstraints() throws Exception {
        DataSetLookupConstraints constraints = ((DataSetLookupConstraints)new DataSetLookupConstraints().setColumnTypes((ColumnType[][])null)).setGroupRequired(false);
        DataSetLookup lookup = constraints.newDataSetLookup(this.dataSet.getMetadata());
        org.fest.assertions.api.Assertions.assertThat((Throwable)constraints.check(lookup)).isNull();
        DataSet result = this.dataSetManager.lookupDataSet(lookup);
        org.fest.assertions.api.Assertions.assertThat((int)result.getColumns().size()).isEqualTo(6);
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(50);
    }

    @Test
    public void testGroupWithOneCalculation() throws Exception {
        DataSetLookupConstraints constraints = ((DataSetLookupConstraints)new DataSetLookupConstraints().setColumnTypes((ColumnType[][])new ColumnType[][]{{ColumnType.LABEL, ColumnType.NUMBER}})).setGroupRequired(true);
        DataSetLookup lookup = constraints.newDataSetLookup(this.dataSet.getMetadata());
        org.fest.assertions.api.Assertions.assertThat((Throwable)constraints.check(lookup)).isNull();
        DataSet result = this.dataSetManager.lookupDataSet(lookup);
        Assertions.assertDataSetValues(result, this.dataSetFormatter, new String[][]{{"Barcelona", "21.00"}, {"Madrid", "57.00"}, {"Brno", "153.00"}, {"Westford", "234.00"}, {"Raleigh", "481.00"}, {"London", "329.00"}}, 0);
    }

    @Test
    public void testGroupWithLabels() throws Exception {
        DataSetLookupConstraints constraints = ((DataSetLookupConstraints)new DataSetLookupConstraints().setColumnTypes((ColumnType[][])new ColumnType[][]{{ColumnType.LABEL, ColumnType.LABEL}})).setGroupRequired(true);
        DataSetLookup lookup = constraints.newDataSetLookup(this.dataSet.getMetadata());
        org.fest.assertions.api.Assertions.assertThat((Throwable)constraints.check(lookup)).isNull();
        DataSet result = this.dataSetManager.lookupDataSet(lookup);
        Assertions.assertDataSetValues(result, this.dataSetFormatter, new String[][]{{"Barcelona", "Engineering"}, {"Madrid", "Services"}, {"Brno", "Support"}, {"Westford", "Engineering"}, {"Raleigh", "Management"}, {"London", "Engineering"}}, 0);
    }

    @Test
    public void testGroupMultipleColumns() throws Exception {
        DataSetLookupConstraints constraints = ((DataSetLookupConstraints)new DataSetLookupConstraints().setColumnTypes((ColumnType[][])new ColumnType[][]{{ColumnType.LABEL, ColumnType.NUMBER, ColumnType.NUMBER, ColumnType.NUMBER}})).setGroupRequired(true);
        DataSetLookup lookup = constraints.newDataSetLookup(this.dataSet.getMetadata());
        org.fest.assertions.api.Assertions.assertThat((Throwable)constraints.check(lookup)).isNull();
        DataSet result = this.dataSetManager.lookupDataSet(lookup);
        Assertions.assertDataSetValues(result, this.dataSetFormatter, new String[][]{{"Barcelona", "21.00", "2,913.14", "21.00"}, {"Madrid", "57.00", "2,453.36", "57.00"}, {"Brno", "153.00", "4,659.24", "153.00"}, {"Westford", "234.00", "3,594.97", "234.00"}, {"Raleigh", "481.00", "4,970.78", "481.00"}, {"London", "329.00", "4,139.77", "329.00"}}, 0);
    }

    private void printDataSet(DataSet dataSet) {
        System.out.print(this.dataSetFormatter.formatDataSet(dataSet, "{", "}", ",\n", "\"", "\"", ", ") + "\n\n");
    }
}

