/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset;

import javax.inject.Inject;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.RawDataSetSamples;
import org.dashbuilder.dataset.engine.SharedDataSetOpEngine;
import org.dashbuilder.dataset.engine.index.DataSetIndex;
import org.dashbuilder.dataset.engine.index.stats.DataSetIndexStats;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.dashbuilder.test.ShrinkWrapHelper;
import org.fest.assertions.api.Assertions;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class DataSetIndexTest {
    public static final String EXPENSE_REPORTS = "expense_reports_dataset";
    DataSetLookup groupByDeptAndCount = ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset("expense_reports_dataset")).group("department", "Department")).column(AggregateFunctionType.COUNT, "occurrences")).buildLookup();
    DataSetLookup groupByDeptAndSum = ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset("expense_reports_dataset")).group("department", "Department")).column("amount", AggregateFunctionType.AVERAGE)).buildLookup();
    DataSetLookup filterByCityAndDept = ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset("expense_reports_dataset")).filter("city", new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"Barcelona"))})).filter("department", new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"Engineering"))})).buildLookup();
    DataSetLookup sortByAmountAsc = ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset("expense_reports_dataset")).sort("amount", "asc")).buildLookup();
    DataSetLookup sortByAmountDesc = ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset("expense_reports_dataset")).sort("amount", "desc")).buildLookup();
    @Inject
    SharedDataSetOpEngine dataSetOpEngine;

    @Deployment
    public static Archive<?> createTestArchive() {
        return ShrinkWrapHelper.createJavaArchive().addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void setUp() throws Exception {
        DataSet dataSet = RawDataSetSamples.EXPENSE_REPORTS.toDataSet();
        dataSet.setUUID(EXPENSE_REPORTS);
        this.dataSetOpEngine.getIndexRegistry().put(dataSet);
    }

    @Test
    public void testGroupPerformance() throws Exception {
        long begin = System.nanoTime();
        int lookupTimes = 1000;
        for (int i = 0; i < lookupTimes; ++i) {
            this.dataSetOpEngine.execute(EXPENSE_REPORTS, this.groupByDeptAndCount.getOperationList());
            this.dataSetOpEngine.execute(EXPENSE_REPORTS, this.groupByDeptAndSum.getOperationList());
        }
        long time = System.nanoTime() - begin;
        DataSetIndex dataSetIndex = this.dataSetOpEngine.getIndexRegistry().get(EXPENSE_REPORTS);
        DataSetIndexStats stats = dataSetIndex.getStats();
        DataSet dataSet = dataSetIndex.getDataSet();
        System.out.println(stats.toString("\n"));
        Assertions.assertThat((int)stats.getNumberOfGroupOps()).isEqualTo(1);
        Assertions.assertThat((int)stats.getNumberOfAggFunctions()).isEqualTo(10);
        Assertions.assertThat((long)stats.getBuildTime()).isLessThan(time);
        Assertions.assertThat((double)stats.getReuseRate()).isGreaterThanOrEqualTo((double)(lookupTimes - 1));
        Assertions.assertThat((long)stats.getIndexSize()).isLessThan(dataSet.getEstimatedSize() / 5L);
    }

    @Test
    public void testFilterPerformance() throws Exception {
        long begin = System.nanoTime();
        int lookupTimes = 1000;
        for (int i = 0; i < lookupTimes; ++i) {
            this.dataSetOpEngine.execute(EXPENSE_REPORTS, this.filterByCityAndDept.getOperationList());
        }
        long time = System.nanoTime() - begin;
        DataSetIndex dataSetIndex = this.dataSetOpEngine.getIndexRegistry().get(EXPENSE_REPORTS);
        DataSetIndexStats stats = dataSetIndex.getStats();
        DataSet dataSet = dataSetIndex.getDataSet();
        System.out.println(stats.toString("\n"));
        Assertions.assertThat((int)stats.getNumberOfFilterOps()).isEqualTo(2);
        Assertions.assertThat((long)stats.getBuildTime()).isLessThan(time);
        Assertions.assertThat((double)stats.getReuseRate()).isGreaterThanOrEqualTo((double)(lookupTimes - 1));
        Assertions.assertThat((long)stats.getIndexSize()).isLessThan(dataSet.getEstimatedSize() / 5L);
    }

    @Test
    public void testSortPerformance() throws Exception {
        long begin = System.nanoTime();
        int lookupTimes = 1000;
        for (int i = 0; i < lookupTimes; ++i) {
            this.dataSetOpEngine.execute(EXPENSE_REPORTS, this.sortByAmountAsc.getOperationList());
            this.dataSetOpEngine.execute(EXPENSE_REPORTS, this.sortByAmountDesc.getOperationList());
        }
        long time = System.nanoTime() - begin;
        DataSetIndex dataSetIndex = this.dataSetOpEngine.getIndexRegistry().get(EXPENSE_REPORTS);
        DataSetIndexStats stats = dataSetIndex.getStats();
        DataSet dataSet = dataSetIndex.getDataSet();
        System.out.println(stats.toString("\n"));
        Assertions.assertThat((int)stats.getNumberOfSortOps()).isEqualTo(2);
        Assertions.assertThat((long)stats.getBuildTime()).isLessThan(time);
        Assertions.assertThat((double)stats.getReuseRate()).isGreaterThanOrEqualTo((double)(lookupTimes - 1));
        Assertions.assertThat((long)stats.getIndexSize()).isLessThan(dataSet.getEstimatedSize() / 5L);
    }
}

